@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Refund Report</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">DMT Report</a></li>
        <li class="active">Refund Report</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Refund Report</h3>
                </div>

                <div class="collapse out">
    
                    <form id="refund-report" action="{{url('/refund_mtransfer_report')}}" method="post">
                        {{ csrf_field() }}
                            <div class="panel-body">

    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="YYYY-MM-DD"  value="{{$start}}"  autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="YYYY-MM-DD"  value="{{$end}}"  autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_account">Consumer No</label>
                                        <input type="text" id="txt_account" name="txt_account" class="form-control" placeholder="Enter Consumer No."  value="{{$txt_account}}"  >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id."  autocomplete="off"  value="{{$txt_memberids}}" >
										<ul class="list-group costom-list" id="member_name"> </ul> 
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Transaction Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid" class="form-control" placeholder="Enter Transaction Id."  value="{{$txt_transid}}" >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Status</label>
                                        <select name="dd_status" id="dd_status" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                           
                                            <option value="3" {{3 == $dd_status? 'selected':'' }}>FOR REFUND</option>
                                            <option value="5" {{5 == $dd_status? 'selected':'' }}>REJECT</option>
                                            <option VALUE="6" {{6 == $dd_status? 'selected':'' }}>REFUNDED</option>
                                           
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Api</label>
                                        <select name="dd_api" id="dd_api" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{'-1' == $dd_status? 'selected':'' }}>Select Api</option>
                                            @foreach($API as $api)
                                            <option value="{{ $api->API_ID }}" {{$api->API_ID == $dd_api? 'selected':'' }}>{{$api->API_NAME}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{'-1' == $dd_api? 'selected':'' }}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}" {{$op->TelecomBrandId == $dd_operator? 'selected':'' }}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords" class="form-control" placeholder="Enter No. of Records."  value="{{$txt_noofrecords}}" >
                                    </div>
                                </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                           <button class="btn btn-primary" type="submit">Reset</button>
                            
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
				<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('recharge-report');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBERID</th>
								<th>SERVICE PROVIDER</th>
								<th>ACCOUNT NO</th>
								<th>AMOUNT</th>
								<th>API</th>
								<th>LIVE ID</th>	
								<th>TRANSACTION ID</th>	
                                <th>RECHARGE DATE</th> 
                                <th>REQUEST DATE</th> 
                                <th>STATUS</th> 
                                <th>ACTION</th> 
							</tr>
						</thead>
						<tbody>

						</tbody>

					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection