@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Recharge Reports</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Reports</a></li>
            <li class="active">Recharge Reports</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->


    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Recharge Report Filter Here
			 @if(count($today_hit) != 0)

					@foreach( $today_hit as $rec_hit)

					@endforeach

				 <b><span class="btn btn-success btn-xs">[{{$rec_hit->TOTAL_HITSUCCESS}}]- &#8377 {{$rec_hit->SUCCESS}}</span></b>

				<b><span class="btn btn-danger btn-xs"> [{{$rec_hit->TOTAL_HITFAILED}}]- &#8377 {{$rec_hit->FAILED}}</b></span>

				<b><span class="btn btn-warning btn-xs">[{{$rec_hit->TOTAL_HITPENDING}}]- &#8377 {{$rec_hit->PENDING}}</b></span>

				<b><span class="btn btn-info btn-xs"> [{{$rec_hit->TOTAL_HITREFUND}}]- &#8377 {{$rec_hit->REFUND}}</b></span>

				<b><span class="btn btn-danger btn-xs"> [{{$rec_hit->TOTAL_HITREFUNDED}}]- &#8377 {{$rec_hit->REFUNDED}}</b></span>

				<b><span class="btn btn-success btn-xs">[{{$rec_hit->TOTAL_HITREJECT}}]- &#8377 {{$rec_hit->REJECT}}</b></span> 

		@endif</h3>
                    </div>

                    <div class="collapse out">
        
                        <form action="{{url('/recharge_report')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                     <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date </label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="YYYY-MM-DD" value="{{$start}}"  autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="YYYY-MM-DD" value="{{$end}}"  autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_account">Consumer No</label>
                                        <input type="text" id="txt_account" name="txt_account" class="form-control" placeholder="Enter Consumer No."  value="{{$txt_account}}">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." value="{{$txt_memberids}}" autocomplete="off">
										<ul class="list-group costom-list" id="member_name"> </ul>  
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Transaction Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid" class="form-control" placeholder="Enter Transaction Id."  value="{{$txt_transid}}">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Status</label>
                                        <select name="dd_status" id="dd_status" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_status == -1? 'selected':'' }}>Select Status</option>
										  <option value="1" {{$dd_status == 1? 'selected':'' }}>SUCCESS</option>
											<option value="2" {{$dd_status == 2? 'selected':'' }}>PENDING</option>
											<option value="3" {{$dd_status == 3? 'selected':'' }}>COMPLAINT</option>
											<option value="4" {{$dd_status == 4? 'selected':'' }}>FAILED</option>
                                            <option value="5" {{$dd_status == 5? 'selected':'' }}>REJECT</option>
                                            <option value="6" {{$dd_status == 6? 'selected':'' }}>REFUNDED</option>
                                            <option value="7" {{$dd_status == 7? 'selected':'' }}>RE-SUCCESS</option>
                                            <option value="8" {{$dd_status == 8? 'selected':'' }}>RE-FAILED</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Api</label>
                                        <select name="dd_api" id="dd_api" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1"  {{$dd_api == -1? 'selected':''}}>Select Api</option>
                                            @foreach($API as $api)
                                            <option value="{{ $api->API_ID }}" {{$dd_api == $api->API_ID? 'selected':''}}>{{$api->API_NAME}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1"  {{$dd_operator == -1? 'selected':''}}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}"  {{$dd_operator == $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords" class="form-control" placeholder="Enter No. of Records." value="{{$txt_noofrecords}}">
                                    </div>
                                </div>
                                    </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
								 <button class="btn btn-primary" type="reset" >Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
            

                <div class="panel-body">
				<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('RECHARGE_REPORT');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                     <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>TXN_DATE</th>
                                <th>MEMBERID/NAME</th>
                                <th>CONSUMERNO</th>
                                <th>OPERATOR</th>
                                <th>CIRCLE</th>
                                <th>STATUS</th>
                                <th>TXN_ID</th>
                                <th>OP.BAL</th>
                                <th>AMOUNT</th>
                                <th>COMMI</th>
                                <th>CL.BAL</th>
                                <th>VIA</th>
								<th>API</th>
                                <th>ACTION</th>
								<th>VIEW_RESPONSE</th>
								<th>RECEIPT</th>
								<th>HIT CALLBACK</th>
                            </tr>
                        </thead>
                        <tbody>
							@php 
							$PreBal =0;
							$Amount =0;
							$Commision =0;
							$PostBal =0;
							@endphp
                            @foreach( $rec_report as $key => $con)
                            <tr>
                                <td>{{ $key +1}}</td>
                                <td>{{ $con->RequestDate }}</td>
                                <td>{{ $con->RegCode }}-</br>[{{ $con->MemberFirstName}} {{ $con->MemberLastName}}]</br>[{{ $con->MemberAffiliate}}]</br>[{{ $con->MemberRole}}]</td>
                                <td>{{ $con->Account }}</td>
                                <td>{{ $con->ServiceProvider }}</td>
                                <td>{{ $con->CircleName }}</td>
                                <td>
                                    @if( $con->Status == 'SUCCESS') 
                                    <button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
                                    @elseif( $con->Status == 'PENDING') 
                                    <button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
                                    @else
                                    <button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
                                    @endif
                                </td>
                                <td>{{ $con->LiveId }}</td>
                                <td>{{ $con->PreBal }}</td>
                                <td>{{ $con->Amount }}</td>
                                <td>{{ $con->Commision }}</td>
                                <td>{{ $con->PostBal }}</td>
                                <td>{{ $con->RequestType }}</td>
								<td>{{ $con->ApiName }}</td>
								@if( $con->Status == 'SUCCESS' || $con->Status == 'FOR REFUND' || $con->Status == 'REJECT') 
								<td>
									<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
									data-account="{{$con->Account}}" data-recstatus="{{$con->Status}}" data-recopertid="{{$con->LiveId}}"
									data-amount="{{$con->Amount}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->Transactionid}}" 
									data-target="#tid_modal" title="ACTION" onClick="show_rechdetails(this)">ACTION</button></td>
								@elseif( $con->Status == 'PENDING') 
								<td>
									<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
									data-account="{{$con->Account}}" data-recstatus="{{$con->Status}}" data-recopertid="{{$con->LiveId}}"
									data-amount="{{$con->Amount}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->Transactionid}}" 
									data-target="#status_modal" title="ACTION" onClick="show_rechdetails2(this)">ACTION</button></td>
								@elseif( $con->Status == 'FAILED' || $con->Status == 'REFUNDED') 
								<td>
									<button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
									data-account="{{$con->Account}}" data-recstatus="{{$con->Status}}" data-recopertid="{{$con->LiveId}}"
									data-amount="{{$con->Amount}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->Transactionid}}" 
									data-target="#failed_refunded_modal" title="ACTION" onClick="show_rechdetails1(this)">ACTION</button></td>
								@else
								<td></td>
								@endif
								<td><button type="button" class="btn btn-info btn-xs" data-toggle="modal" data-target="#response_modal" title="VIEW RESPONSE" 
									data-rechresponse="{{$con->Remarks}}"  data-response="{{$con->Remarks}}"onClick="show_response(this)">VIEW RESPONSE</button>
								</td>
								@if( $con->Status == 'SUCCESS')
								<td><a class="btn btn-warning btn-xs" href="{{url('bill_receipt/'.$con->Transactionid)}}" target="_blank">PRINT RECEIPT</a></td>
								@else
								<td></td>
								@endif
				    	<td><input type="hidden" id="txt_rechtxnid" name="txt_rechtxnid" value="{{$con->Transactionid}}"/><button type="button" class="btn btn-success btn-xs" title="HIT CALLBACK" onClick="hit_callback({{$con->Transactionid}})">HIT CALLBACK</button></td>
						</tr>

							@php 
							$PreBal =$con->PreBal + $PreBal;
							$Amount =$con->Amount + $Amount;
							$Commision =$con->Commision+ $Commision;
							$PostBal =$con->PostBal+$PostBal;
							@endphp

                       @endforeach
						</tbody>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>Total</th>
                                <th>{{number_format($Amount, 2)}}</th>
                                <th>{{number_format($Commision, 2)}}</th>
                                <th></th>
                                <th></th>
								<th></th>
                                <th></th>
								<th></th>
								<th></th>
								<th></th>
                            </tr>
                        </tfoot>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<script type="text/javascript">
function hit_callback(trans_id)
{
var txt_rechtxnid=$('#txt_rechtxnid').val();
//alert(txt_rechtxnid);
if(trans_id!="")
{
	$.ajax({	
		type:"POST",
							url:"{{ url('hit_callback')}}",
							dataType: 'json',
							data:{"txt_forrefundtxnid":txt_rechtxnid,_token: '{{csrf_token()}}'},
							beforeSend : function(){
								$('img.loader').show('fadein');
							},
							success:function(msg) 
							{
							    if(msg==1)
								{
								alert("CALLBACK HIT SUCCESFULLY");
								window.location.reload();
								}
								else
								{
									alert(msg);
								}
							}
						});
					}
				} 
			</script>
  <!-- Modal content-->
<div class="modal fade" id="response_modal" role="dialog">
		<div class="modal-dialog">
		  <!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
					<h4 class="modal-title" id="status_modallabel"><center>RECHARGE RESPONSE</center></h4>
				</div>
				<div class="modal-body fs-12">
					<div class="col-md-12 col-sm-12 col-xs-12" >
						<div class="form-group mb-0">
						<label class="control-label"> <span id="rech_response" style="overflow-wrap: break-word;"></span></label>
						</div>
					</div>	
					<center>RESPONSE AFTER API HIT</center>
				</div>
			</div>
			<script type="text/javascript">
				function show_response(obj)
				{
				//$('#rech_response').text($(obj).data('rechresponse'));
				var myJSON = JSON.stringify($(obj).data('response'));
				document.getElementById("rech_response").innerHTML = myJSON;
				} 
			</script>
		</div>
	</div>

	<div class="modal fade" id="status_modal" role="dialog">
		<div class="modal-dialog">
		  <!-- Modal content-->
		  <div class="modal-content">
		  <form name="rec_statuschng" action="{{'update_rech_status'}}" class="cmxform form-horizontal" method="post" >
		  	{{ csrf_field() }}
			<div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h4 class="modal-title" id="status_modallabel"><center>CHANGE RECHARGE STATUS</center></h4>
            </div>
			<div class="modal-body fs-12">
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group mb-0">
						<label class="control-label">MOBILE NUMBER :- <span id="pending_mobileno"></span></label>
						<input id="txt_pendingmobileno" name="txt_pendingmobileno" type="hidden" class="form-control" required="required">
						<input id="txt_pendingstatus" name="txt_pendingstatus" type="hidden" class="form-control" required="required" value="">
						<input id="txt_pendingtxnid" name="txt_pendingtxnid" type="hidden" class="form-control" required="required" >
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group mb-0">
						<label class="control-label">RECHARGE AMOUNT :- <span id="pending_amount"></span></label>
						<input id="txt_pendingamount" name="txt_pendingamount" type="hidden" class="form-control" required="required">
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group mb-0">
						<label class="control-label">REMARKS OR OPERATOR TXN ID :-<span id="pending_liveid"></span></label>
						<input id="txt_pendingoperaterid" name="txt_pendingoperaterid" type="text" class="form-control" required="required">
					</div>
			</div>
				<center>Would you like to change the status of recharge?</center>
			</div>
			<div class="modal-footer">
			<script type="text/javascript">
				function show_rechdetails2(obj)
				{
					$('#pending_mobileno').html($(obj).data('account'));
					$('#txt_pendingmobileno').val($(obj).data('account'));
					$('#pending_amount').html($(obj).data('amount'));
					$('#txt_pendingamount').val($(obj).data('amount'));
					$('#txt_pendingtxnid').val($(obj).data('transid'));
					$('#pending_liveid').html($(obj).data('recopertid'));
					$('#txt_pendingoperaterid').val($(obj).data('recopertid'));
				} 
			</script>
			<script type="text/javascript">
				function update_success()
				{
				   var txt_rechtxnid=$('#txt_pendingtxnid').val();
					var txt_rechopid=$('#txt_pendingoperaterid').val();
					var csrf = $("input[name='csrf_token']").val();
					if($("#txt_pendingtxnid").val()!="" && $("#txt_pendingoperaterid").val()!="")
					{
						$.ajax({	
							type:"POST",
							url:"{{ url('refund_recharge')}}",
							dataType: 'json',
							data:{"txt_pendingtxnid":txt_rechtxnid,"txt_pendingstatus":"SUCCESS","txt_pendingoperaterid":txt_rechopid,_token: '{{csrf_token()}}'},
							beforeSend : function(){
								$('img.loader').show('fadein');
							},
							success:function(msg) 
							{
							    if(msg==1)
								alert("RECHARGE UPDATE SUCCESFULLY");
								window.location.reload();
							}
						});
					}
				} 
			</script>
			<script type="text/javascript">
				function update_failed()
				{
					var txt_rechtxnid=$('#txt_pendingtxnid').val();
					var txt_rechopid=$('#txt_pendingoperaterid').val();
					var csrf = $("input[name='csrf_token']").val();
					if($("#txt_pendingtxnid").val()!="" && $("#txt_pendingoperaterid").val()!="")
					{
						$.ajax({	
							type:"POST",
							url:"{{ url('refund_recharge')}}",
							dataType: 'json',
							data:{"txt_pendingtxnid":txt_rechtxnid,"txt_pendingstatus":"FAILURE","txt_pendingoperaterid":txt_rechopid,_token: '{{csrf_token()}}'},
							beforeSend : function(){
								$('img.loader').show('fadein');
							},
							success:function(msg) 
							{
								if(msg==1)
								alert("RECHARGE REFUND SUCCESFULLY");
								window.location.reload();
							}
						});
					}
				} 
			</script>
				<button type="button" onClick="update_success()" class="btn btn-success">SUCCESS</button>
				<button type="button" onClick="update_failed()" class="btn btn-danger">FAILED</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">CANCEL</button>
			</div>
			</form>
		  </div>
		</div>
	</div>
	<div class="modal fade" id="failed_refunded_modal" role="dialog">
		<div class="modal-dialog">
		  <!-- Modal content-->
		  <div class="modal-content">
		  <form name="rec_statuschng" action="{{'resuccess_recharge'}}" class="cmxform form-horizontal" method="post">
		  	{{ csrf_field() }}
			<div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h4 class="modal-title" id="status_modallabel"><center>CHANGE RECHARGE STATUS</center></h4>
            </div>
			<div class="modal-body fs-12">
				<div class="col-md-12 col-sm-12 col-xs-12">
					<div class="form-group mb-0">
						<label class="control-label">MOBILE NUMBER :- <span id="failed_mobileno"></span></label>
						<input id="txt_failedmobileno" name="txt_failedmobileno" type="hidden" class="form-control" required="required">
						<input id="txt_failedtxnid" name="txt_failedtxnid" type="hidden" class="form-control" required="required" >
						<input id="txt_failedstatus" name="txt_failedstatus" type="hidden" class="form-control" required="required" value="RSUCCESS">
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xs-12">
					<div class="form-group mb-0">
						<label class="control-label">RECHARGE AMOUNT :- <span id="failed_amount"></span></label>
						<input id="txt_failedamount" name="txt_failedamount" type="hidden" class="form-control" required="required">
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xs-12">
					<div class="form-group mb-0">
						<label class="control-label">REMARKS OR OPERATOR TXN ID :-<span id="operater_tid"></span></label>
						<input id="txt_failedoperaterid" name="txt_failedoperaterid" type="text" class="form-control" required="required">
					</div>
				</div>
				<center>Would you like to change the status of recharge?</center>
			</div>
			<div class="modal-footer">
				<script type="text/javascript">
					function show_rechdetails1(obj)
					{
						$('#failed_mobileno').html($(obj).data('account'));
						$('#txt_failedmobileno').val($(obj).data('account'));
						$('#failed_amount').html($(obj).data('amount'));
						$('#txt_failedamount').val($(obj).data('amount'));
						$('#txt_failedtxnid').val($(obj).data('transid'));
						$('#operater_tid').html($(obj).data('recopertid'));
						$('#txt_failedoperaterid').val($(obj).data('recopertid'));
					} 
				</script>
	<script type="text/javascript">
				function update_revertsuccess()
				{
				    var txt_rechtxnid=$('#txt_failedtxnid').val();
					var txt_rechopid=$('#txt_failedoperaterid').val();
					var csrf = $("input[name='csrf_token']").val();
					if($("#txt_failedtxnid").val()!="" && $("#txt_failedoperaterid").val()!="")
					{
						$.ajax({	
							type:"POST",
							url:"{{ url('refund_recharge')}}",
							dataType: 'json',
							data:{"txt_pendingtxnid":txt_rechtxnid,"txt_pendingstatus":"RSUCCESS","txt_pendingoperaterid":txt_rechopid,_token: '{{csrf_token()}}'},
							beforeSend : function(){
								$('img.loader').show('fadein');
							},
							success:function(msg) 
							{
							    if(msg==1)
								alert("RECHARGE UPDATE SUCCESFULLY");
								window.location.reload();
							}
						});
					}
				} 
			</script>
				<button  type="button" onClick="update_revertsuccess()" class="btn btn-success">REVERT SUCCESS</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">CANCEL</button>
			</div>
			</form>
		  </div>
		</div>
	</div>
	<div class="modal fade" id="tid_modal" role="dialog">
		<div class="modal-dialog">
		  <!-- Modal content-->
		  <div class="modal-content">
		  <form name="rec_statuschng" action="{{'refund_recharge'}}" class="cmxform form-horizontal"  method="post" >
		  	{{ csrf_field() }}
			<div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h4 class="modal-title" id="status_modallabel"><center>CHANGE RECHARGE STATUS</center></h4>
            </div>
			<div class="modal-body fs-12">
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group mb-0">
						<label class="control-label">MOBILE NUMBER :- <span id="pendingstatususer_mobileno"></span></label>
						<input id="txt_pendingmobileno" name="txt_pendingmobileno" type="hidden" class="form-control" required="required">
					    <input id="txt_pendingstatus" name="txt_pendingstatus" type="hidden" class="form-control" required="required" value="REFUNDED">
						<input id="txt_pendingrechid" name="txt_pendingrechid" type="hidden" class="form-control" required="required">
						<input id="txt_successtxnid" name="txt_successtxnid" type="hidden" class="form-control" required="required" >
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group mb-0">
						<label class="control-label">RECHARGE AMOUNT :- <span id="pendingstatususer_amount"></span></label>
						<input id="txt_pendingamount" name="txt_pendingamount" type="hidden" class="form-control" required="required">
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group mb-0">
						<label class="control-label">REMARKS OR OPERATOR TXN ID :-<span id="pendingoperater_tid"></span></label>
						<input id="txt_optid" name="txt_optid" type="text" class="form-control" required="required">
					</div>
				</div>
				<center>Would you like to change the status of recharge?</center>
			</div>
			<div class="modal-footer">
				<button type="button" onClick="update_tid()" class="btn btn-primary">UPDATE TID</button>
				<button type="button" onClick="update_refund()" class="btn btn-danger">REFUND</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">CANCEL</button>
			</div>
			<script type="text/javascript">
				function show_rechdetails(obj)
				{
					$('#txt_successtxnid').val($(obj).data('transid'));
					$('#txt_pendingrechid').val($(obj).data('rechid'));
					$('#pendingstatususer_mobileno').html($(obj).data('account'));
					$('#txt_pendingmobileno').val($(obj).data('account'));
					$('#pendingstatususer_amount').html($(obj).data('amount'));
					$('#txt_pendingamount').val($(obj).data('amount'));
					$('#pendingoperater_tid').html($(obj).data('recopertid'));
					$('#txt_optid').val($(obj).data('recopertid'));
				} 
			</script>
			<script type="text/javascript">
				function update_tid()
				{
					var txt_rechtxnid=$('#txt_successtxnid').val();
					var txt_rechid=$('#txt_pendingrechid').val();
					var txt_rechopid=$('#txt_optid').val();
					var csrf = $("input[name='csrf_token']").val();
					if($("#txt_successtxnid").val()!=""	&& $("#txt_pendingrechid").val()!="" && $("#txt_optid").val()!="")
					{
						$.ajax({	
							type:"POST",
							url:"{{ url('update_rechargetid')}}",
							dataType: 'json',
							data:{"txt_transid":txt_rechtxnid,"txt_rechid":txt_rechid,"txt_rechopid":txt_rechopid,_token: '{{csrf_token()}}'},
							beforeSend : function(){
								$('img.loader').show('fadein');
							},
							success:function(msg) 
							{
								if(msg==1)
								alert("RECHARGE LIVE TID UPDATE SUCCESFULLY");
						        window.location.reload();
							}
						});
					}
				} 
			</script>
				<script type="text/javascript">
				function update_refund()
				{
					var txt_rechtxnid=$('#txt_successtxnid').val();
					var txt_rechopid=$('#txt_optid').val();
					var csrf = $("input[name='csrf_token']").val();
					if($("#txt_successtxnid").val()!="" && $("#txt_optid").val()!="")
					{
						$.ajax({	
							type:"POST",
							url:"{{ url('refund_recharge')}}",
							dataType: 'json',
							data:{"txt_pendingtxnid":txt_rechtxnid,"txt_pendingstatus":"REFUNDED","txt_pendingoperaterid":txt_rechopid,_token: '{{csrf_token()}}'},
							beforeSend : function(){
								$('img.loader').show('fadein');
							},
							success:function(msg) 
							{
								if(msg==1)
								alert("RECHARGE REFUND SUCCESFULLY");
							    window.location.reload();
							}
						});
					}
				} 
			</script>
			</form>
		  </div>
		</div>
</div>
<!-- /page content -->
<script type="text/javascript">
    window.setTimeout('refreshPage()', 10000);
    function refreshPage()
    {
        window.location.reload(true);
    }
</script>
@endsection