@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Pending BillPay Report</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa  fa-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">BillPay Report</a></li>
            <li class="active">Pending BillPay Report</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->


    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Pending BillPay Report</h3>
                    </div>

                    <div class="collapse out">
        
                        <form action="{{url('/pendingbillpay_report')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtfromdate">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txtfromdate" id="txtfromdate" class="form-control input-inline input-medium" placeholder="YYYY-MM-DD" value="{{$start}}" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txttodate">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txttodate" id="txttodate" class="form-control input-inline input-medium" placeholder="YYYY-MM-DD" value="{{$end}}"  autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>
                                <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Consumer No</label>
                                            <input type="text" id="txt_account" name="txt_account" class="form-control input-inline input-medium" value="{{$txt_account}}" placeholder="Enter Consumer No." >
                                        </div>
                                    </div> 
								<div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" value="{{$txt_memberids}}"  placeholder="Enter Member Id." >
                                    </div>
                                </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Trnx ID</label>
                                            <input type="text" id="txt_transid" name="txt_transid" class="form-control input-inline input-medium" value="{{$txt_transid}}" placeholder="Enter User ID." >
                                        </div>
                                    </div>  

                                    <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Api</label>
                                        <select name="dd_api" id="dd_api" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_api == '-1'? 'selected':'' }}>Select Api</option>
                                            @foreach($API as $api)
                                            <option value="{{ $api->API_ID }}" {{$api->API_ID == $dd_api? 'selected':'' }}>{{$api->API_NAME}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_operator == '-1'? 'selected':'' }}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}" {{$op->TelecomBrandId == $dd_operator? 'selected':'' }}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                    
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
								<button class="btn btn-primary" type="reset">Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
            <div class="col-md-12 mb-10 mt-10">
						<button type="button" id="all_success" class="btn btn-success pull-left mr-5" data-toggle="tooltip" data-placement="bottom" title="ALL SUCCESS" data-original-title="ALL SUCCESS">ALL SUCCESS</button>
						<button type="button" id="all_failed" class="btn btn-danger pull-left mr-5" data-toggle="tooltip" data-placement="bottom" title="ALL REFUND" data-original-title="ALL REFUND">ALL REFUND</button>
				</div>
                <div class="panel-body">
 <div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('pendingbillpay_report');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
								<th><input type="checkbox" name="all_check" id="all_check" value="-1"/></th>
                                <th>S.NO.</th>
                                <th>TXN DATE</th>
                                <th>MEMBERID/NAME</th>
                                <th>CONSUMERNO</th>
                                <th>OPERATOR</th>
								<th>AMOUNT</th>
                                <th>STATUS</th>
                                <th>TXN ID</th>
                                
                                <th>VIA</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach( $rec_report as $con)
                            <tr>
                                <td><input type="checkbox" name="pending" value="{{$con->Transactionid}}" /></td>
								<td>{{ '#'}}</td>
                                <td>{{ $con->RequestDate }}</td>
                                <td>{{ $con->MemberID }}/ {{ $con->MemberFirstName  }}</td>
                                <td>{{ $con->Account }}</td>
                                <td>{{ $con->ServiceProvider }}</td>
								<td>{{ $con->Amount }}</td>
                                <td><button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button></td>
                                <td>{{ $con->LiveId }}</td>
                                <td>{{ $con->RequestType }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
    </div>
    <!--===================================================-->
    <!--End page content-->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
    $('#all_check').click(function (e){
        $(this).closest('table').find('td input:checkbox').prop('checked', this.checked);
    });
</script>
<script>
$('#all_success').click(function(){
	var myCheckboxes = new Array();
	$("input[name='pending']:checked").each(function(){
	if($(this).val()>0)
	myCheckboxes.push($(this).val());
	});
	console.log(myCheckboxes);
	if(myCheckboxes.length > 0)
	{
	$.ajax({	
		type:"POST",
		url:"{{ url('/update_billpaystatus') }}",
		dataType: 'json',
		data:{"txt_transid":myCheckboxes,"txt_operid":'N/A',"status":"SUCCESS",_token: '{{csrf_token()}}',_method: "PATCH"},
		success: function(response){
				alert("BillPay Success Update Successfully!");
				console.log(response);
				window.location.reload(); 
        },
        error: function( req, status, err ) {
           console.log( 'something went wrong', status, err );
			alert(err);
        }
		}); 
	}
	else
	{
		alert("Please select recharge for change the status.");
	}
	});
$('#all_failed').click(function(){
	var myCheckboxes = new Array();
	$("input[name='pending']:checked").each(function(){
	if($(this).val()>0)
	myCheckboxes.push($(this).val());
	});
	console.log(myCheckboxes);
	if(myCheckboxes.length > 0)
	{
		$.ajax({	
			type:"POST",
			url:"{{ url('update_billpaystatus') }}",
			dataType: 'json',
			data:{"txt_transid":myCheckboxes, "txt_operid":'N/A',"status":"FAILURE",_token: '{{csrf_token()}}',_method: "PATCH"},
			success: function(response){
					alert("BillPay Refund Update Successfully!");
					console.log(response);
					window.location.reload(); 
			},
			error: function( req, status, err ) {
				console.log( 'something went wrong', status, err );
				alert(err);
			}
		}); 
	}
	else
	{
		alert("Please select user for change the status.");
	}
});
</script>
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection