@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Operator Wise Report</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
        <li class="active">Operator Wise Report</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Operator Wise Report</h3>
                </div>

                <div class="collapse out">
    
                    <form id="payment-summary" action="{{url('/operator_wise')}}" method="post">
                        {{ csrf_field() }}
                            <div class="panel-body">

    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control"  value="{{$start}}"  placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control"  value="{{$end}}" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1"  {{$dd_operator == -1? 'selected':''}}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}"  {{$dd_operator == $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Api</label>
                                        <select name="dd_api" id="dd_api" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_api == -1? 'selected':''}}>Select Api</option>
                                            @foreach($API as $api)
                                            <option value="{{ $api->API_ID }}" {{$dd_api == $api->API_ID? 'selected':''}}>{{$api->API_NAME}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>


                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-primary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
                <div class="panel-body">
					<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('ledger-report');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>DATE</th>
								<th>OPERATOR</th>
								<th>SUCCESS</th>
								<th>PENDING</th>
								<th>FOR REFUND</th>
								<th>REJECT</th>
								<th>TOTAL (SUCCESS+PENDING+ FOR REFUND +REJECT)</th>
                            </tr>
						</thead>
						<tbody>
							@php 
							$SUCCESS=0;
							$PENDING=0;
							$FORREFUND=0;
							$REJECT=0;
							$SUBTOTAL=0;
							@endphp
                            @foreach( $rec_report as $key => $con)
                            <tr>
                                <td>{{ $key +1}}</td>
                                <td>{{ $con->RECDATE }}</td>
                                <td>{{ $con->TELECOM_BRAND }}</td>
								<td>{{ $con->SUCCESS }}</td>
								<td>{{ $con->PENDING }}</td>
								<td>{{ $con->FORREFUND }}</td>
								<td>{{ $con->REJECT }}</td>
                                <td>{{ $con->SUCCESS + $con->PENDING + $con->FORREFUND + $con->REJECT}}</td>
                            </tr>

							@php 
							$SUCCESS=$con->SUCCESS +$SUCCESS ;
							$PENDING=$con->PENDING +$PENDING ;
							$FORREFUND=$con->FORREFUND +$FORREFUND ;
							$REJECT=$con->REJECT +$REJECT;
							$SUBTOTAL= $SUBTOTAL+$con->SUCCESS + $con->PENDING + $con->FORREFUND + $con->REJECT;
							@endphp

                            @endforeach
						</tbody>
						<tfoot>
							<tr>
								<th></th>
								<th></th>
								<th>TOTAL</th>
								<th>{{number_format($SUCCESS, 2)}}</th>
								<th>{{number_format($PENDING, 2)}}</th>
								<th>{{number_format($FORREFUND, 2)}}</th>
								<th>{{number_format($REJECT, 2)}}</th>
								<th>{{number_format($SUBTOTAL, 2)}}</th>
                            </tr>
						</tfoot>
					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection