@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
        <li class="active">Ledger</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">Ledger</h3>
                </div>

                <div class="collapse in">
    
                    <form id="ledger-report" action="{{url('/ledger')}}" method="post">
                        {{ csrf_field() }}
                            <div class="panel-body">

    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Transaction Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid" class="form-control" placeholder="Enter Transaction Id." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords" class="form-control" placeholder="Enter No. of Records." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Ledger Status</label>
                                        <select name="dd_ledgertype" id="dd_ledgertype" class="form-control">
                                            <option value="-1">Select Ledger</option>
                                            <option value="1">CREDIT</option>
                                            <option value="2">DEBIT</option>
                                            <option value="3">RECHARGE PROCESS</option>
                                            <option value="4">RECHARGE FAILED</option>
                                            <option value="5">CASHBACK</option>
                                            <option value="6">EXTRA DEDUCTION</option>
                                            <option value="7">RE-RECHARGE PROCESS</option>
                                            <option value="8">RE-RECHARGE FAILED</option>
                                        </select>
                                    </div>
                                </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-success" type="button" onclick="EXPORTTOEXCEL('ledger-report');">Export To Excel</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
  
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBERID/NAME</th>
								<th>TRANSACTION ID</th>
								<th>TRANSACTION DATE</th>
								<th>DESCRIPTION</th>
								<th>CR.AMOUNT</th>
								<th>DR.AMOUNT</th>	
								<th>BALANCE FOR</th>	
                                <th>RECHARGE BAL</th> 
                                <th>UTILITY BAL</th> 
							</tr>
						</thead>
						<tbody>
                            @foreach( $ledger_report as $con)
                             <tr>
                                 <td >{{'#'}}</td >
                                <td>{{$con->MemberID}}<span style="color:red;">/</span>{{$con->MemberFirstName}} {{$con->MemberLastName}}</td>
                                <td>{{$con->Transactionid}}</td>
                                <td>{{$con->TransactionDate}}</td>
                                <td>{{$con->Description}}</td>
                                <td>{{$con->AmountCredited}}</td>
                                <td>{{$con->AmountDedited}}</td>
                                <td>{{$con->BalanceType}}</td>
                                <td>{{$con->CurrentBalance}}</td>
                                <td>{{$con->UtilityBalance}}</td>
                            </tr>
                             @endforeach

						</tbody>

					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection