@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Day Book</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
        <li class="active">Day Book</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Date Wise Day Book Report</h3>
                </div>

                <div class="collapse out">
    
                    <form id="user-wise" action="{{url('/day_book')}}" method="post">
                        {{ csrf_field() }}
                            <div class="panel-body">

    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate"   value="{{$start}}"  class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate"   value="{{$end}}" class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-primary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
					<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('daybook');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table  id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>DATE</th>
								<th>OPENING_BAL</th>
								<th>PURCHASE</th>
								<th>SALE</th> 
								<th>RECHARGE</th>
								<th>SERVICE_FEE</th>
								<th>KYC_FEE</th>
								<th>REGISTRATION_FEE</th>
								<th>BENE_ACCOUNT_VERIFICATION</th>
								<th>COMMISON</th>
								<th>REFUND</th>
								<th>CLOSING_BAL</th>
                            </tr>
						</thead>
						<tbody>
							<?php $op_bal=0.00;$purchase=0.00;$sale=0.00;$recharge=0.00;
								$rsf=0.00;$ksf=0.00;$rsf=0.00;$ksf=0.00;$urf=0.00;$bav=0.00;$rc=0.00;$rfa=0.00;$cl_bal=0.00;?>
                            @foreach( $rec_report as $sn=>$con)
								<?php $op_bal=$op_bal+$con->OPENING_BAL;$purchase=$purchase+$con->PURCHASE_AMOUNT;$sale=$sale+$con->SALE_AMOUNT;$recharge=$recharge+$con->RECHARGE_AMOUNT;
$rsf=$rsf+$con->RETAILER_SERVICE_FEE;$ksf=$ksf+$con->KYC_SERVICE_FEE;
$urf=$urf+$con->USER_REGISTRATION_FEE;$bav=$bav+$con->BENEFICIARY_ACCOUNT_VERIFICATION;
$rc=$rc+$con->RECHARGE_COMMISON;$rfa=$rfa+$con->REFUND_AMOUNT;$cl_bal=$cl_bal+$con->CLOSING_BAL;
 ?>
                            <tr>
                                <td>{{ $sn+1 }}</td>
                                <td>{{ $con->TRXN_DATE }}</td>
								<td>{{ $con->OPENING_BAL}}</td>
								<td>{{ $con->PURCHASE_AMOUNT }}</td>
								<td>{{ $con->SALE_AMOUNT }}</td>
								<td>{{ $con->RECHARGE_AMOUNT }}</td>
                                <td>{{ $con->RETAILER_SERVICE_FEE}}</td>
								<td>{{ $con->KYC_SERVICE_FEE}}</td>
								<td>{{ $con->USER_REGISTRATION_FEE}}</td>
								<td>{{ $con->BENEFICIARY_ACCOUNT_VERIFICATION }}</td>
								<td>{{ $con->RECHARGE_COMMISON }}</td>
								<td>{{ $con->REFUND_AMOUNT }}</td>
								<td>{{ $con->CLOSING_BAL }}</td>
                            </tr>
                            @endforeach
							
						</tbody>
						<tfoot>
							<tr>
								<th>#</th>
								<th>TOTAL</th>
								<th>{{$op_bal}}</th>
								<th>{{$purchase}}</th>
								<th>{{$sale}}</th> 
								<th>{{$recharge}}</th>
								<th>{{$rsf}}</th>
								<th>{{$ksf}}</th>
								<th>{{$urf}}</th>
								<th>{{$bav}}</th>
								<th>{{$rc}}</th>
								<th>{{$rfa}}</th>
								<th>{{$cl_bal}}</th>
                            </tr>
						</tfoot>
					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection