@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Date Wise Report</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
        <li class="active">Date Wise Report</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Date Wise Report</h3>
                </div>

                <div class="collapse out">
    
                    <form id="user-wise" action="{{url('/date_wise')}}" method="post">
                        {{ csrf_field() }}
                            <div class="panel-body">

    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate"   value="{{$start}}"  class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate"   value="{{$end}}" class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-primary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
					<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('date-wise');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>DATE</th>
								<th>SUCCESS</th>
								<th>PENDING</th>
								<th>FOR_REFUND</th>
								<th>REJECT</th>
								<th>TOTAL</br>(SUCCESS+PENDING+ </br> FOR REFUND +REJECT)</th>
								<th>FAILED</th>
								<th>REFUND</th>
                                <th>API COMMISION</th>
                                <th>COMMISION</th>
                                <th>PROFIT</th>
                            </tr>
						</thead>
						<tbody>
	<?php 
$hit_success=0.00;$sucess=0.00;$comm=0.00;$apicomm=0.00;
$hit_pending=0.00;$pending=0.00;
$hit_forrefund=0.00;$forrefund=0.00;
$hit_reject=0.00;$reject=0.00;
$hit_failed=0.00;$failed=0.00;
$hit_refunded=0.00;$refunded=0.00;?>
@foreach( $rec_report as $sn=> $con)
<?php 
$hit_success=$hit_success+$con->TOTAL_HITSUCCESS;
$sucess=$sucess+$con->SUCCESS;
$comm=$comm+$con->COMMISION;
$apicomm=$apicomm+$con->APICOMMISION;
$hit_pending=$hit_pending+$con->TOTAL_HITPENDING;
$pending=$pending+$con->PENDING;
$hit_forrefund=$hit_forrefund+$con->TOTAL_HITREFUND;
$forrefund=$forrefund+$con->FORREFUND;
$hit_reject=$hit_reject+$con->TOTAL_HITREJECT;
$reject=$reject+$con->REJECT;
$hit_failed=$hit_failed+$con->TOTAL_HITFAILED;
$failed=$failed+$con->FAILED;
$hit_refunded=$hit_refunded+$con->TOTAL_HITREFUNDED;
$refunded=$refunded+$con->REFUNDED;
?>
                            <tr>
                                <td>{{ $sn+1 }}</td>
                                 <td>{{ $con->RECDATE }}</td>
								<td>[{{$con->TOTAL_HITSUCCESS}} ] {{ $con->SUCCESS}}</td>
								<td>[{{$con->TOTAL_HITPENDING}} ] {{ $con->PENDING }}</td>
								<td>[{{$con->TOTAL_HITREFUND}} ] {{ $con->FORREFUND }}</td>
								<td> [{{$con->TOTAL_HITREJECT}} ] {{ $con->REJECT }}</td>
                                <td>[{{$con->TOTAL_HITSUCCESS+$con->TOTAL_HITPENDING+$con->TOTAL_HITREFUND +$con->TOTAL_HITREJECT}}] {{ $con->SUCCESS + $con->PENDING + $con->FORREFUND + $con->REJECT}}</td>
								<td>[{{$con->TOTAL_HITFAILED}} ] {{ $con->FAILED }}</td>
								<td>[{{$con->TOTAL_HITREFUNDED}} ] {{ $con->REFUNDED }}</td>
                                <td> {{$con->APICOMMISION }}</td>
                                <td> {{$con->COMMISION }}</td>
                                <td> {{ $con->APICOMMISION -$con->COMMISION}}</td>
                            </tr>
                            @endforeach
						</tbody>
						<tfoot>
							<tr>
								<th></th>
								<th></th>
								<th>[{{$hit_success}}] {{number_format($sucess,2) }}</th>
								<th>[{{$hit_pending}}] {{number_format($pending,2) }}</th>
								<th>[{{$hit_forrefund}}] {{number_format($forrefund,2) }}</th>
								<th>[{{$hit_reject}}] {{number_format($reject,2) }}</th>
								<th>[{{$hit_success+$hit_pending+$hit_forrefund +$hit_reject}}] {{number_format($sucess+$pending+$forrefund+$reject,2) }}</th>
								<th>[{{$hit_failed}}] {{number_format($failed,2) }}</th>
								<th>[{{$hit_refunded}}] {{number_format($refunded,2) }}</th>
                                <th> {{number_format($apicomm,2) }}</th>
                                <th> {{number_format($comm,2) }}</th>
                                <th> {{number_format(($apicomm-$comm),2) }}</th>
                            </tr>
						</tfoot>
					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection