@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Commission Reports</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Commission Reports</a></li>
            <li class="active">Commission Reports</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->


    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Report Filter Here        </h3>
                    </div>

                    <div class="collapse out">
        
                        <form action="{{url('/commission_report')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                     <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date </label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="YYYY-MM-DD" value="{{$start}}"  autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="YYYY-MM-DD" value="{{$end}}"  autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_account">Consumer No</label>
                                        <input type="text" id="txt_account" name="txt_account" class="form-control" placeholder="Enter Consumer No."  value="{{$txt_account}}">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." value="{{$txt_memberids}}" autocomplete="off">
										<ul class="list-group costom-list" id="member_name"> </ul>  
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Transaction Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid" class="form-control" placeholder="Enter Transaction Id."  value="{{$txt_transid}}">
                                    </div>
                                </div>

                                

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value='-1'  {{$dd_operator == -1?'selected':''}}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}"  {{$dd_operator == $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords" class="form-control" placeholder="Enter No. of Records." value="{{$txt_noofrecords}}">
                                    </div>
                                </div>
                                    </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
								 <button class="btn btn-primary" type="reset" >Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
                <div class="panel-body">
				<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('RECHARGE_REPORT');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                     <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>DATE</th>
                                <th>RETAILER</th>
                                <th>INTRODUCER</th>
								<th>CONSUMERNO</th>
                                <th>OPERATOR</th>
                                <th>API</th>
                                <th>AMOUNT</th>
                                <th>RETAILER</th>
                                <th>FOS</th>
								<th>DISTRIBUTOR</th>
                                <th>MASTER<br>DISTRIBUTOR</th>
                                <th>BRANCH/ <br>API / WL</th>
                                <th>TOTAL COMM</th>
								<th>BY_API</th>
                                <th>PROFIT</th>
                            </tr>
                        </thead>
                        <tbody>

							@php 
							
							$Amount =0;
							$RTCommision =0;
							$DCommision =0;$MDCommision =0;$SDCommision =0;$ApiCommision =0;
							$Commision =0;$TtlCommision=0;
	
							@endphp
                            @foreach( $rec_report as $key => $con)
                            <tr>
                                <td>{{ $key +1}}</td>
                                <td>{{ $con->RequestDate }}</td>
                                <td>{{ $con->RegCode }}-</br>[{{ $con->MemberName}} ]</br>[{{ $con->MemberAffiliate}}]</br>[{{ $con->MemberRole}} }<br>[{{$con->GroupName}}]</td>
								<td>{{ $con->ReferralMobileNo }}</td>
                                <td>{{ $con->Account }}</td>
                                <td>{{ $con->ServiceProvider }}</td>
								<td>{{ $con->ApiName }}</td>
                                <td>{{ $con->Amount }}</td>
                                <td>{{ $con->RTCommision }}</td>
								<td>{{ $con->DCommision }}</td>
								<td>{{ $con->MDCommision }}</td>
								<td>{{ $con->SDCommision }}</td>
								<td>{{ $con->ApiCommision }}</td>
                                <td>{{ $con->ApiCommision+$con->SDCommision +$con->MDCommision+$con->DCommision+$con->RTCommision }}</td>
								<td>{{ $con->CommisionByAPI }}</td>
                                <td>{{ $con->CommisionByAPI-($con->ApiCommision+$con->SDCommision +$con->MDCommision+$con->DCommision+$con->RTCommision) }}</td>
				    	</tr>

							@php 
							
							$Amount =$con->Amount + $Amount;
							$RTCommision =$con->RTCommision+ $RTCommision;
							$DCommision =$con->DCommision+ $DCommision;
							$SDCommision =$con->SDCommision+ $SDCommision;
							$MDCommision =$con->MDCommision+ $MDCommision;
							$ApiCommision =$con->ApiCommision+ $ApiCommision;
                            $TtlCommision= $ApiCommision+ $MDCommision+ $SDCommision+ $DCommision+ $RTCommision;
							$Commision =$con->CommisionByAPI+ $Commision;
							@endphp

                       @endforeach
						</tbody>
                      <tfoot>
                            <tr>
                                <th>#</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>Total</th>
                                <th>{{number_format($Amount, 2)}}</th>
								<th>{{number_format($RTCommision, 2)}}</th>
                                <th>{{number_format($DCommision, 2)}}</th>
                                <th>{{number_format($MDCommision, 2)}}</th>
								<th>{{number_format($SDCommision, 2)}}</th>
                                <th>{{number_format($ApiCommision, 2)}}</th>
								<th>{{number_format($TtlCommision, 2)}}</th>
								<th>{{number_format($Commision, 2)}}</th>
                                <th>{{number_format(($Commision-$TtlCommision), 2)}}</th>
                            </tr>
                        </tfoot>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection