@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Cash Collection Reports</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Cash Collection Reports</a></li>
            <li class="active">Cash Collection Reports</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
    </div>
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Report Filter Here        </h3>
                    </div>

                    <div class="collapse out">
        
                        <form action="{{url('/recharge_report')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                     <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date </label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="YYYY-MM-DD" value="{{$start}}"  autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="YYYY-MM-DD" value="{{$end}}"  autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_account">Consumer No</label>
                                        <input type="text" id="txt_account" name="txt_account" class="form-control" placeholder="Enter Consumer No."  value="{{$txt_account}}">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." value="{{$txt_memberids}}" autocomplete="off">
										<ul class="list-group costom-list" id="member_name"> </ul>  
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Transaction Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid" class="form-control" placeholder="Enter Transaction Id."  value="{{$txt_transid}}">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Status</label>
                                        <select name="dd_status" id="dd_status" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_status == -1? 'selected':'' }}>Select Status</option>
										  <option value="1" {{$dd_status == 1? 'selected':'' }}>SUCCESS</option>
											<option value="2" {{$dd_status == 2? 'selected':'' }}>PENDING</option>
											<option value="3" {{$dd_status == 3? 'selected':'' }}>COMPLAINT</option>
											<option value="4" {{$dd_status == 4? 'selected':'' }}>FAILED</option>
                                            <option value="5" {{$dd_status == 5? 'selected':'' }}>REJECT</option>
                                            <option value="6" {{$dd_status == 6? 'selected':'' }}>REFUNDED</option>
                                            <option value="7" {{$dd_status == 7? 'selected':'' }}>RE-SUCCESS</option>
                                            <option value="8" {{$dd_status == 8? 'selected':'' }}>RE-FAILED</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1"  {{$dd_operator == -1? 'selected':''}}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}"  {{$dd_operator == $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords" class="form-control" placeholder="Enter No. of Records." value="{{$txt_noofrecords}}">
                                    </div>
                                </div>
                                    </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
								 <button class="btn btn-primary" type="reset" >Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
                <div class="panel-body">
				<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('cash_collocation');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                     <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>DATE</th>
                                <th>COLLECTEDFROM</th>
                                <th>OPENING</th>
                                <th>AMOUNT</th>
                                <th>CLOSING</th>
                                <th>CREDIT</th>
                                <th>DEBIT</th>
                                <th>REMARK</th>
                                <th>ADMIN</th>
                            </tr>
                        </thead>
                        <tbody>
                         
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection