@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">AEPS Report</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">AEPS Report</a></li>
            <li class="active">AEPS Report</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->


    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">AePS Report Filter Here </h3>
                    </div>

                    <div class="collapse out">
        
                        <form action="{{url('/apestransfer_report')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                     <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate"  value="{{$start}}"  class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate"  value="{{$end}}"  class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_account">Consumer No</label>
                                        <input type="text" id="txt_account" name="txt_account"  value="{{$txt_account}}"  class="form-control" placeholder="Enter Consumer No." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid"  value="{{$txt_memberids}}"  class="form-control" placeholder="Enter Member Id." autocomplete="off">
										<ul class="list-group costom-list" id="member_name"> </ul> 
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Transaction Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid"  value="{{$txt_transid}}"  class="form-control" placeholder="Enter Transaction Id." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Status</label>
                                        <select name="dd_status" id="dd_status" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{'-1' == $dd_status? 'selected':'' }}>Select Status</option>
										  <option value="1" {{1 == $dd_status? 'selected':'' }}>SUCCESS</option>
											<option value="2" {{2 == $dd_status? 'selected':'' }}>PENDING</option>
											<option value="3" {{3 == $dd_status? 'selected':'' }}>COMPLAINT</option>
											<option value="4" {{4 == $dd_status? 'selected':'' }}>FAILED</option>
                                            <option value="5" {{5 == $dd_status? 'selected':'' }}>REJECT</option>
                                            <option VALUE="6" {{6 == $dd_status? 'selected':'' }}>REFUNDED</option>
                           
                                        </select>
                                    </div>
                                </div>
								<div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords"  value="{{$txt_noofrecords}}"  class="form-control" placeholder="Enter No. of Records." >
                                    </div>
                                </div>
                                    </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
 <button class="btn btn-primary" type="reset">Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('aeps-report');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                     <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">

						<thead>
							<tr>
								<th >SN. No.</th>
								<th>REQUEST_DATE </th>
								<th>APPROVED_DATE </th>
							    <th>MEMBER_ID</th>
								<th>MEMBER_NAME</th>
								<th>BANK_NAME</th>
								<th>PAYEE_NAME</th>
								<th>ACCOUNT_NUMBER</th>
								<th>IFSCODE</th>
								<th>WALLET_TYPE</th>
								<th>MODE</th>
								<th>AMOUNT</th>
								<th>UTR/BANK_REFRENCE</th>
								<th>ADMIN_RESPONSE </th>
								<th>STATUS</th>
								<th>ACTION</th>
							</tr>
						</thead>
						<tbody>
							<?php $sn =  1; ?>
							@foreach( $data as $key => $ba)
							<tr>
								<td>{{$key+1}}</td>
								<td>{{$ba->FUNDREQ_CREATEDAT}}</td>
								<td>{{$ba->FUNDREQ_UPDATEAT}}</td>
								<td>{{$ba->MEMBER_CODE}}</td>
								<td>{{$ba->MEMBER_FIRSTNAME}}{{$ba->MEMBER_FIRSTNAME}}</td>
								<td>{{$ba->BANK_NAME}}</td>
								<td>{{$ba->FUNDREQ_PAYEE}}</td>
								<td>{{$ba->FUNDREQ_ACCOUNTNO}}</td>
								<td>{{$ba->FUNDREQ_IFSCODE}}</td>
								<td>{{$ba->FUNDREQ_TOWALLET}}</td>
								<td>{{strtoupper($ba->FUNDREQ_MODE)}}</td>
								<td>{{strtoupper($ba->FUNDREQ_AMOUNT)}}</td>
								<td>{{strtoupper($ba->FUNDREQ_UTRNO)}}</td>
								<td>{{strtoupper($ba->FUNDREQ_ADMINRES)}}</td>
								<td>
										@if($ba->FUNDREQ_STATUS == 'APPROVED') 
										<button type="button" class="btn btn-success btn-xs">{{strtoupper($ba->FUNDREQ_STATUS)}}</button>
										@elseif( $ba->FUNDREQ_STATUS  == 'PENDING') 
										<button type="button" class="btn btn-warning btn-xs">{{strtoupper($ba->FUNDREQ_STATUS)}}</button>
										@elseif( $ba->FUNDREQ_STATUS  == 'CANCELED') 
										<button type="button" class="btn btn-danger btn-xs">{{strtoupper($ba->FUNDREQ_STATUS)}}</button>
										@else
										<button type="button" class="btn btn-info btn-xs">{{strtoupper($ba->FUNDREQ_STATUS)}}</button>
										@endif
								</td>
								<td>
								@if($ba->FUNDREQ_STATUS=="PENDING")
							  <button type="button" class="btn btn-success btn-xs" data-toggle="modal" data-target="#status_modal" title="{{$ba->FUNDREQ_STATUS}}" onclick="get_status_details(this,'{{ $ba->FUNDREQ_ID }}');" data-status="APPROVED" data-trasnid="{{$ba->FUNDREQ_TRANID}}" data-amount="{{$ba->FUNDREQ_AMOUNT}}" data-mobieno="{{$ba->MEMBER_CONTACT}}" data-regcode="{{$ba->MEMBER_CODE}}" data-mode="{{$ba->FUNDREQ_MODE1}}">
							  <i class="fa fa-check">ACCEPT</i>
							  <button type="button" class="btn btn-danger btn-xs" data-toggle="modal" data-target="#status_modal" title="{{$ba->FUNDREQ_STATUS}}" onclick="get_status_details(this,'{{ $ba->FUNDREQ_ID }}');" data-status="CANCELED" data-trasnid="{{$ba->FUNDREQ_TRANID}}" data-amount="{{$ba->FUNDREQ_AMOUNT}}" data-mobieno="{{$ba->MEMBER_CONTACT}}" data-regcode="{{$ba->MEMBER_CODE}}"  >
							  <i class="fa fa-close">REJECT</i>
								@endif
								</td>
			 </tr>
			 @endforeach
						</tbody>
					</table>
                </div>
            
            </div>
        </div>
        
    </div>
    <!--===================================================-->
    <!--End page content-->
    
</div>
    <div class="modal fade" id="status_modal" role="dialog">
    <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
      <form action="{{url('/wdrequest_status')}}" class="cmxform form-horizontal" enctype="multipart/form-data" method="post" >
        {{ csrf_field() }}
       <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"></span></button>
                <h4 class="modal-title" id="status_modallabel"><center>CHANGE WITHDRAW REQUEST STATUS</center></h4>
             </div>
      <div class="modal-body" style="font-size: medium;">
        <div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
          <label class="control-label">REQUEST TRANSACTION ID :-  <span id="request_trasnid"></span></label>
          <label class="control-label">REQUEST AMOUNT :-  <span id="request_amount"></span></label>
          <input id="txt_mobileno" name="txt_mobileno" type="hidden" class="form-control" required="required">
          <input id="txt_regcode" name="txt_regcode" type="hidden" class="form-control" required="required">
          <input id="txt_amount" name="txt_amount" type="hidden" class="form-control" required="required">
          <input id="txt_status" name="txt_status" type="hidden" class="form-control" required="required">
          <input id="txt_mode" name="txt_mode" type="hidden" class="form-control" required="required">
          <input id="txt_fundrequestid" name="txt_fundrequestid" type="hidden" class="form-control" required="required">
          </div>
        </div>  
        <div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
          <label class="control-label">WOULD YOU LIKE TO -  <span id="request_status" style="color:red; "></span> THIS FUND REQUEST.</label>
          </div>
        </div>
        <div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
          <label class="control-label">ADMIN REPLY</label>
          <input id="txt_adminreply" name="txt_adminreply" type="text" class="form-control" required="required">
          </div>
        </div>
        <center>Would you like to change the status of withdraw request.?</center>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal" onclick="javascript:window.location.reload()">NO</button>
        <button type="submit" class="btn btn-primary">YES</button>
      </div>
      </form>
      </div>
    </div>
  </div>
  <script>
    $('.loader').hide();
    function get_status_details(obj,id)
    {
      $('#txt_fundrequestid').val(id);
      $('#txt_status').val($(obj).data('status'));
      $('#txt_mode').val($(obj).data('mode'));
      $('#request_status').html($(obj).data('status'));
      $('#request_trasnid').html($(obj).data('trasnid'));
      $('#request_amount').html($(obj).data('amount'));
      $('#txt_amount').val($(obj).data('amount'));
      $('#txt_mobileno').val($(obj).data('mobieno'));
      $('#txt_regcode').val($(obj).data('regcode'));
    } 
  </script>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection