@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Pan Token Request</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Pan Token</a></li>
        <li class="active">Pan Token Request</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                @if(Session::has('panrq_msg')) 
                <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                    <h4 class="alert-heading">{{ Session::get("panrq_msg") }}</h4>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Pan Token Request</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{url('/user_pan_token')}}" method="POST">
                      {{ csrf_field() }}
                        <div class="panel-body form-padding">

                            <div class="row">

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                            <input type="text" name="txt_memberid" id="txt_memberid" class="form-control" placeholder="Enter Member Id."  value={{$txt_memberid}} >
										
                    											<ul class="list-group " id="member_name"> 
                    									
                    											</ul> 

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" value="{{$start}}" autocomplete="off" >
                                        </div>
                                    </div>
                                </div>   

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class=" control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" value="{{$end}}" autocomplete="off" >
                                        </div>   
                                    </div>
                                </div>      

                                <div class="col-sm-3">
                                    <div class="form-group">
                                      <label class="control-label">Status</label>
                                        <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_status" id="dd_status">
                                            <option value="">Select Status</option>
                                            <option value="PENDING" {{$status == 'PENDING' ? 'selected' : ''}}>PENDING</option>
                                            <option value="APPROVED" {{$status == 'APPROVED' ? 'selected' : ''}}>APPROVED</option>
                                            <option value="CANCELLED" {{$status == 'CANCELLED' ? 'selected' : ''}}>CANCELLED</option>
                                        </select>
                                    </div>
                                </div>                        

                            </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-primary" type="reset">Reset</button>                            

                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">Pan Request<span class="pull-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('fund_req_status');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></span></h3>
					
                </div>
            
                <div class="panel-body">
                    
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                         	<tr>
          								<th>S.No.</th>
          								<th>MEMBER ID</th>
          								<th>MEMBER NAME</th>
										<th>PSA LOGIN ID</th>
										<th>NO OF TOKEN</th>
										<th>TOKEN AMOUNT</th>
										<th>PAN TOKEN AMOUNT</th>
          								<th>REMARK</th>
          								<th>ADMIN REPLY</th>
          								<th>STATUS</th>			
										<th>MAHAGRAM STATUS</th>
          								<th>UPDATED DATE</th>
          								<th>ACTION</th>
          							</tr>
                        </thead>
                        <tbody>
                          @foreach($pan_token as $key=>$value)
                          <tr>
                              <td>{{$key+1}}</td>
                              <td>{{$value->USER_CODE}}</td>
                              <td>{{$value->USER_NAME}}</td>
							  <td>{{$value->PSA_LOGIN_ID}}</td>
                              <td>{{$value->PAN_TOKEN}}</td>
                              <td>{{107}}</td>
                              <td>{{$value->PAN_TOKEN*107}}</td>
                              <td>{{$value->REMARK}}</td>
                              <td>{{$value->ADMIN_RES}}</td>
                              <td>{{$value->STATUS}}</td>
							  <td>{{$value->MG_REQUEST_STATUS}}</td>
                              <td>{{$value->UPDATED_AT}}</td>
                              <td>
								@if($value->STATUS=='PENDING')
                                <button data-id="{{$value->TOKEN_ID}}" data-usercode="{{$value->USER_CODE}}" data-username="{{$value->USER_NAME}}" data-pantoken="{{$value->PAN_TOKEN}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-success btn-xs val">APPROVE</button>
								<button data-id="{{$value->TOKEN_ID}}" data-usercode="{{$value->USER_CODE}}" data-username="{{$value->USER_NAME}}" data-pantoken="{{$value->PAN_TOKEN}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-danger btn-xs val">REJECT</button>
								@endif
								@if($value->STATUS=='APPROVED' && $value->MG_REQUEST_STATUS=='Pending')
								<a href="{{url('/change_reqstatus/'.$value->TOKEN_ID)}}" class="btn btn-primary btn-xs val">STATUS RESPONSE</a>
                                @endif
								</td>
                          </tr>
                          @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>   
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
	<div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

            <form action="{{url('pantoken_status')}}" method="POST"> 
                {{ csrf_field() }}

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title text-center">CHANGE PAN TOKEN STATUS</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body  fs-12">
                    <div class="form-group">
                        <input id="txt_tokenid" name="txt_tokenid" type="hidden" class="form-control" required="required">
                    </div>
                    <p class="text-semibold text-main">USER CODE :-<span id="usercode"></span></p>

                    <p class="text-semibold text-main">USER NAME :-<span id="username"></span></p>

                    <p class="text-semibold text-main">PAN TOKEN AMOUNT:-<span id="tokenamt"></span></p>

                    <div class="form-group">
                      <label class="control-label">Status</label>
                        <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_status" id="dd_status">
                            <option value="">Select Status</option>
                            <option value="1">PENDING</option>
                            <option value="2">APPROVED</option>
                            <option value="3">CANCELLED</option>
                        </select>
                    </div>
                    <div class="form-group">
                      <label class="control-label">Admin Reply</label>  
                      <input id="txt_adminreply" name="txt_adminreply" type="text" class="form-control" required="required">
                    </div>
                    <p class="text-semibold text-main">Would you like to change the status of pan token request?</p>       
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                    <button class="btn btn-primary" type="submit">Yes</button>
                </div>

            </form>
            </div>
        </div>
</div>
		<div class="modal fade" id="demo-default-modal1" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

            <form action="{{url('change_reqstatus')}}" method="POST"> 
                {{ csrf_field() }}

                <!--Modal header-->
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title text-center">CHANGE MAHAGRAM STATUS</h4>
                </div>

                <!--Modal body-->
                <div class="modal-body  fs-12">
                    <div class="form-group">
                        <input id="txt_tokenid" name="txt_tokenid" type="hidden" class="form-control" required="required">
                    </div>
                    <p class="text-semibold text-main">USER CODE :-<span id="usercode"></span></p>

                    <p class="text-semibold text-main">USER NAME :-<span id="username"></span></p>

                    <p class="text-semibold text-main">Would you like to change the mahagram status of pan token request?</p>       
                </div>

                <!--Modal footer-->
                <div class="modal-footer">
                    <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                    <button class="btn btn-primary" type="submit">Yes</button>
                </div>

            </form>
            </div>
        </div>

    </div>
  <script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var usercode = $(this).data('usercode');
        var username = $(this).data('username');
        var pantoken = $(this).data('pantoken');
        var tokenamt = parseFloat(pantoken*107);
        $('#txt_tokenid').val(id);
        $('#usercode').text(usercode);
        $('#username').text(username);
        $('#tokenamt').text(tokenamt);
    });
});
</script>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection