@extends('mainlayout')
@section('content')

<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->

        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">Transaction History</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
    </div>
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
            <div class="col-12">
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">Transaction History Detail</h3>
                </div>
                <div class="collapse in">
                    <form  action="{{ url('/transaction_history_list') }}" method="POST">
						{{ csrf_field() }}
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-sm-2"> 
                                    <div class="form-group">
                                        <label class="control-label" for="txt_membercode">Member Code</label>
                                        <input type="text" name="txt_membercode" id="txt_membercode" class="form-control" placeholder="Enter Member Code." value="{{request()->txt_membercode}}" >
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="from_date">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="from_date" id="from_date" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" value="{{request()->from_date}}" >
                                        </div>
                                    </div>  
                                </div>                              
                                
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="to_date">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="to_date" id="to_date" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" value="{{request()->to_date}}" >
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2"> 
                                    <div class="form-group">
                                        <label class="control-label" for="txt_trans_id">Txn Id</label>
                                        <input type="text" name="txt_trans_id" id="txt_trans_id" class="form-control" placeholder="Enter Txn Id." value="{{request()->txt_trans_id}}">
                                    </div>
                                </div>
                                <div class="col-sm-2"> 
                                    <div class="form-group">
                                        <label class="control-label" for="txt_trans_hash">Txn Hash</label>
                                        <input type="text" name="txt_trans_hash" id="txt_trans_hash" class="form-control" placeholder="Enter Txn Hash." value="{{request()->txt_trans_hash}}" >
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Txn Type</label>
                                        <select class="form-control" name="dd_txn_type">
                                            <option value="">Select Txn Type</option>
                                            <option value="BUY" {{request()->dd_txn_type == 'BUY'?'selected':''}}>BUY</option>
                                            <option value="SELL" {{request()->dd_txn_type == 'SELL'?'selected':''}}>SELL</option>
                                        </select>
                                    </div> 
                                </div>     
                            </div>       
                        </div>
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-default" type="button">Close</button>
                        </div>
                    </form>
                </div>
            </div>
            </div>
        </div>  
        <div class="row">
            <div class="col-md-6">
                <div class="panel panel-clr-bg" style="background: #4fc054;">
                    <div class="panel-head pad-all panel-clr-bg" style="box-shadow: none!important;padding: 10px;background: #4fc054;">
                        <p class="mar-no text-lg text-semibold text-white text-right"><span class="pull-left">TOTAL BUY ETG</span>{{number_format($total_buy_coin)}} </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="panel panel-clr-bg" style="background: #f26161fc;">
                    <div class="panel-head pad-all panel-clr-bg" style="box-shadow: none!important;padding: 10px;background: #f26161fc;">
                        <p class="mar-no text-lg text-semibold text-white text-right"><span class="pull-left">TOTAL SELL ETG</span>{{number_format($total_sell_coin)}} </p>
                    </div>
                </div> 
            </div>
            </div>
        <div class="row">
            <div class="col-12">
            <div class="panel">
                @if(Session::has('message')) 
				<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
					<h4 class="alert-heading">{{ Session::get("message") }}</h4>
					<button type="button" class="close" data-dismiss="alert" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				@endif
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                       <thead>
							<tr>
								<th>S.NO.</th>
                                <th>USER</th>
                                <th>TXN ID</th>
                                <th>ETG COIN</th>
                                <th>TXN TYPE</th>
							    <th>STATUS</th>
                                <th>TXN HASH</th>
                                <th>REMARKS</th>
								<th>TXN DATE</th>
                                <th>ACTION</th>
							</tr>
						</thead>
						<tbody>
							@foreach($data as $key => $con)
							<tr>
								<td>{{ $key+1 }}</td>
                                <td>{{ $con->MEMBER_NAME }} - <strong>[ {{ $con->MEMBER_CODE }} ]</strong></td>
                                <td>{{ $con->TRANS_ID }}</td>
								<td>{{ $con->TXN_COIN_UNIT }}</td>
								<td><span style="font-weight: 600;" class="{{ $con->SERVICE_ID == 'BUY'?'text-success':'text-danger'  }}">{{$con->SERVICE_ID}}</span></td>
							    <td><span style="font-weight: 600;" class="{{ $con->TXN_STATUS == 'SUCCESS'?'text-success':'text-danger'  }}">{{ $con->TXN_STATUS  }}</span></td>
                                <td>{{ $con->API_TXNID }}</td>
                                <td>{{ $con->REMARKS  }}</td>
								<td>{{ $con->TXN_ONADD  }}</td>
                                <td>
                                    <div style="display: flex;">
                                    @if($con->TXN_STATUS=="PENDING")
                                      <button type="button" class="btn btn-success btn-xs" data-toggle="modal" data-target="#status_modal" title="{{$con->TXN_STATUS}}" onclick="get_status_details(this,'{{ $con->COIN_BUYSELL_ID }}');" data-status="APPROVED">
                                      ACCEPT</button>
                                      <button type="button" class="btn btn-danger btn-xs" data-toggle="modal" data-target="#status_modal" title="{{$con->TXN_STATUS}}" onclick="get_status_details(this,'{{ $con->COIN_BUYSELL_ID }}');" data-status="CANCELED">
                                      REJECT</button>
                                      @endif
                                      </div>
                                  </td>
                            </tr>
							@endforeach
						</tbody>
					    <tr>
							<th></th>
							<th>TOTAL</th>
                            <th>{{$total_coin}}</th>
							<th></th>
							<th></th>
							<th></th>
                            <th></th>
							<th></th>
                            <th></th>
                            <th></th>
						</tr>
                    </table>
                </div>
            
            </div>
            </div>
        </div> 
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

    <div class="modal fade" id="status_modal" role="dialog">
    <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
      <form action="{{url('chnage_status_coin_transaction')}}" class="cmxform form-horizontal" enctype="multipart/form-data" method="post" >
        {{ csrf_field() }}
       <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h4 class="modal-title" id="status_modallabel"><center>CHANGE REQUEST STATUS</center></h4>
             </div>
      <div class="modal-body fs-12">
        <div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
          <label class="control-label">TRANSACTION ID :-  <span id="request_trasnid"></span></label>
          <label class="control-label">COIN :-  <span id="request_amount"></span></label>
          <input id="txt_status" name="txt_status" type="hidden" class="form-control" required="required">
          <input id="txt_requestid" name="txt_requestid" type="hidden" class="form-control" required="required">
          </div>
        </div>  
        <div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
          <label class="control-label">WOULD YOU LIKE TO -  <span id="request_status" style="color:red; "></span> THIS REQUEST.</label>
          </div>
        </div>
        <div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
            <label class="control-label">TXN HASH</label>
            <input id="txt_txn_hash" name="txt_txn_hash" type="text" class="form-control" placeholder="Enter Txn Hash">
          </div>
        </div>
        <div class="col-md-12 col-sm-12 col-xs-12" >
          <div class="form-group">
            <label class="control-label">ADMIN REPLY <span class="text-danger">*</span></label>
            <input id="txt_adminreply" name="txt_adminreply" type="text" class="form-control" required="required" placeholder="Enter Remarks">
          </div>
        </div>
        <center>Would you like to change the status of request.?</center>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal" onclick="javascript:window.location.reload()">NO</button>
        <button type="submit" class="btn btn-primary">YES</button>
      </div>
      </form>
      </div>
    </div>
  </div>
    <script>

    $('.loader').hide();
    function get_status_details(obj,id)
    {
      $('#txt_requestid').val(id);
      $('#txt_status').val($(obj).data('status'));
      $('#request_status').html($(obj).data('status'));
      $('#request_trasnid').html($(obj).data('trasnid'));
      $('#request_amount').html($(obj).data('amount'));
    } 
  </script>
@endsection
