@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
			<li class="active">RE-Topup</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-md-4">
                <div class="panel">

					@if(Session::has('message')) 
					<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
						<h4 class="alert-heading">{{ Session::get("message") }}</h4>
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					@endif
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
                        <h3 class="panel-title">Re-Topup </h3>
					</div>
					
                    <div class="collapse in">
						
						<form action="{{url('/retopup')}}" id="topupForm" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
							
							<div class="panel-body form-horizontal form-padding">
								 
                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="txt_referralcode">User Id</label>
                                    <div class="col-md-9">
                                        <input type="text" name="txt_referralcode" id="txt_referralcode" class="form-control" placeholder="Enter User Id." required onBlur="get_member_name()">
									</div>
								</div>
								
                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="txt_referralname">User Name</label>
                                    <div class="col-md-9">
                                        <input type="text" name="txt_referralname" id="txt_referralname" class="form-control" placeholder="Enter User Name." readonly>
										
									</div>
								</div>
								<div class="form-group">
                                    <label class="col-md-3 control-label" for="txt_balance">Avail Balance</label>
                                    <div class="col-md-9">
                                        <input type="text" name="txt_balance" id="txt_balance" class="form-control" placeholder="Enter User Name." readonly>
									</div>
								</div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Package</label>
                                    <div class="col-md-9">
                                        <select class="form-control" id="dd_package" name="dd_package" required onchange="get_package_amount();">
                                            <option>Select Package</option>
											@foreach( $package as $pack)
											<option value="{{ $pack->PACKAGE_ID}}">{{ $pack->PACKAGE_NAME }}</option>
											@endforeach
										</select>
									</div>
								</div>
								<div class="form-group">
                                    <label class="col-md-3 control-label" for="txt_packageamt">Package Amount</label>
                                    <div class="col-md-9">
                                        <input type="text" name="txt_packageamt" id="txt_packageamt" class="form-control" placeholder="Enter Package Amount." required>
									</div>
								</div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Payment By</label>
                                    <div class="col-md-9">
                                        <select id="dd_user_forwallet" name="dd_user_forwallet" class="form-control opt">
											<option value="-1">Select Wallet</option>
											<option value="1">Self Wallet</option>
										</select>
									</div>
								</div>
							</div>
							<div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('topupForm')">Submit</button>
							</div>
							
						</form>
						
					</div>
					
				</div>
			</div>
			
			
            <div class="col-md-8">
                <div class="row">
                    <div class="panel">
						
                        <div class="panel-heading">
                            <div class="row">
                                <div class="col-md-8 col-sm-8 col-xs-6">
                                    <h3 class="panel-title">Topup Or Buy Subscription</h3>
								</div>
                                <div class="col-md-4 col-sm-4 col-xs-6">
                                    <div class="text-right" style="padding:4% 8% 0 0;">
                                        <div class="form-group">
                                            <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('fund_request');">Export To Excel</button>
										</div>
									</div>
								</div>
							</div>
						</div>
						
                        <div class="panel-body">
                            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>USER ID</th>
                                        <th class="min-tablet">USER NAME</th>
                                        <th class="min-tablet">PACKAGE</th>
                                        <th class="min-tablet">PACKAGE AMOUNT</th>
                                        <th class="min-tablet">MAIN WALLET</th>
                                        <th class="min-tablet">ACTION</th>
									</tr>
								</thead>
                                <tbody>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
									</tr>
								</tbody>
							</table>
						</div>
						
					</div>
				</div>
				
			</div>
		</div>
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection