@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Reassigned Employee</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{ url('/admin_dashboard') }}">Member</a></li>
			<li class="active">Reassigned Employee</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">

                	@if ($errors->any())
				    <div class="alert alert-danger">
				        <ul>
				            @foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
				            @endforeach
						</ul>
					</div>
				    @endif

                	@if(Session::has('message')) 
						<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
							<h4 class="alert-heading">{{ Session::get('message') }}</h4>
							<button type="button" class="close" data-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
					@endif
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
                        <h3 class="panel-title">Reassigned Employee</h3>
					</div>
                    
                    <div class="collapse in">	
					
						<form action="{{'reassigned_employee'}}" id="profile_edit" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_memberid">Member Id *</label>
                                            <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." required value="{{$USERID}}"  autocomplete="off">
											<ul class="list-group costom-list" id="member_name"> </ul> 										
											</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
										</div>
									</div>
								</div>
							</div>    
						</form>  
						
						@if($get_useralldetail != '')
						@foreach( $get_useralldetail as $con)
						@endforeach
						<form id="profile_update" action="{{ url('update_reassigned_emp') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
							{{ csrf_field() }}
							<div class="panel-body">
								<input id="txt_membercode" name="txt_membercode" type="hidden" required value="{{$con->RegCode}}" readonly>
						<input id="txt_userid" name="txt_userid" type="hidden" required="required" value="{{$con->RegId}}" readonly>
								<div class="row">
									<legend>Employee Details</legend>
								<div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_referralcode"> Employee Id *</label>
                                            <input type="text" id="txt_referralcode" name="txt_referralcode" class="form-control empty" placeholder="Enter Referral User Id." required  onfocusout="get_member_name();" onfocusin="get_member_name();" value="{{ $con->EmpCode}}" readonly>
										</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_username">Name</label>
                                            <input type="text" class="form-control empty" placeholder="Referral Name" name="txt_referralname" id="txt_referralname" required autocomplete="off" value="{{ $con->EmpName}}" readonly>
										</div>
									</div>
									
								</div>
								<legend>Reassigned Employee</legend>
								<div class="row">
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="dd_bank">Select Employee</label>
											<select class="form-control selectpicker" data-live-search="true" data-width="100%"  name="dd_employee" id="dd_employee" onchange="getinfo(this.id)">
												<option value="">Select</option>
												@foreach($emp as $b)
												<option value="{{$b->RegId}}" data1="{{$b->MemberName}}" data2="{{$b->MemberEmail}}" data3="{{$b->MemberContactNo}}">{{$b->RegCode}} {{$b->MemberName}}</option>
												@endforeach
											</select>
										</div>
                                    </div>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_username">Name <span style="color: #e30808;font-size: 10px;">(eg.First Name {SPACE} Last Name)</span></label>
											<input type="text" id="txt_username" name="txt_username" class="form-control" value="" required  readonly="true">
										</div>
									</div>
									
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="Email">Email Id</label>
											<input type="text" id="Email" name="Email" class="form-control" value="" required readonly="true">
										</div>
									</div>									
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="Contact">Contact Number</label>
											<input type="text" id="Contact" name="Contact" class="form-control" value="" required readonly="true">
										</div>
									</div>
								</div>
						
						
							</div>
							<div class="panel-footer text-center">
								<button class="btn btn-success" type="button" onclick="conwv('profile_update')">UPDATE</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
							</div>
						</form>
						@endif
						
					</div>
					
				</div>
			</div>
            
		</div>
        
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
<script type="text/javascript">
	function getinfo(id) {
		$('#txt_username').val('');
		$('#Email').val('');
		$('#Contact').val('');
		$('#txt_username').val($("#dd_employee option:selected").attr('data1'));
		$('#Email').val($("#dd_employee option:selected").attr('data2'));
		$('#Contact').val($("#dd_employee option:selected").attr('data3'));

	}
</script>

@endsection