@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Live Game Report</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Game Reports</a></li>
        <li class="active">LIVE GAME REPORT</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
    </div><age content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">LIVE GAME REPORT FILTER</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{url('/game_results')}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">   

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="control-label" for="txt_fromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="YYYY-mm-dd" autocomplete="off" >
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="control-label" for="txt_todate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="YYYY-mm-dd" autocomplete="off" >
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="control-label" for="txt_lottery_number">Game ID</label>
                                    <input type="text" id="txt_lottery_number" name="txt_lottery_number" class="form-control" placeholder="Enter Game ID." autocomplete="off"> 
                                </div>
                            </div>
                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-primary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div>


        <div class="row">
          <div class="panel">
            <div class="panel-heading">
              <div class="panel-control">
                <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
              </div>
              <h3 class="panel-title">LIVE GAME RESULT</h3>
            </div>
            <div class="collapse in">
              <div class="panel-body">
                <div class="text-right">
                </div>
                <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th>S.No</th>
                      <th>Game ID</th>
                      <th>Win Lottery No</th>
                      <th>Start Time</th>
                      <th>End Time</th>
                      <th>Status</th>
                      <th>Date</th>
                    </tr>
                  </thead>
                  <tbody>

                  @foreach($all_orders as $key => $values)
                    <tr>
                      <td>{{++$key}}</td>
                      <td>{{$values->CODE}}</td>
                      <td>{{$values->WIN_LOTTERY_NO}}</td>
                      <td>{{date('d-m-Y h:i:s', strtotime($values->START_TIME))}}</td>
                      <td>{{date('d-m-Y h:i:s', strtotime($values->END_TIME))}}</td>
                      <td>{{$values->STATUS}}</td>
                      <td>{{$values->CREATED_AT}}</td>
                    </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>

        </div>  
    </div>
    <!--===================================================-->
    <!--End page content-->
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection