@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Registration</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Employee</a></li>
			<li class="active">Employee Registration</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
	</div>
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
			<div class="col-lg-offset-3 col-lg-6">
				
                <div class="panel">

                	@if(Session::has('message')) 
					<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
						<h4 class="alert-heading">{{ Session::get("message") }}</h4>
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					@endif
					
                    <div class="panel-heading">
						
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
                        <h3 class="panel-title">Employee Registration</h3>
					</div>
                    <div class="collapse in">
                        <form action="{{ url('employee_signup') }}" enctype="multipart/form-data"  id="empForm" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_referralcode">Referral Employee  Id <span class="text-danger">*</span></label>
                                            <input type="text" id="txt_referralcode" name="txt_referralcode" class="form-control empty" placeholder="Enter Referral Employee  Id." required  onfocusout="get_employee_name();" onfocusin="get_employee_name();" autocomplete="off" value="{{old('txt_referralcode')}}" >
                                            <span class="text-danger" id="divtxt_referralcode"></span>
										</div>
									</div>    
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_username">Name <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control empty" placeholder="Referral Name" name="txt_referralname" id="txt_referralname" required autocomplete="off" value="{{old('txt_referralname')}}" >
                                            <span class="text-danger" id="divtxt_referralname"></span>
										</div>
									</div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class=" control-label">Position <span class="text-danger">*</span></label>
                                            <div class="" style="margin-top: 5px;">
                                                <input id="demo-inline-form-radio-2" class="magic-radio" type="radio" name="position" value="JUNIOR"  {{ old('position') == 'JUNIOR'? 'checked':''}} required>
                                                <label for="demo-inline-form-radio-2">Junior</label>
                                                <input id="demo-inline-form-radio-3" class="magic-radio" type="radio" name="position" value="SENIOR"   {{ old('position') == 'SENIOR'? 'checked':''}} >
                                                <label for="demo-inline-form-radio-3">Senior</label>
											</div>
											<span class="text-danger" id="divdemo-inline-form-radio-2"></span>
											<span class="text-danger" id="divdemo-inline-form-radio-3"></span>
										</div>
									</div>
								</div>
                                <div class="row">
                                    <legend>Personal Details</legend>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_username">Name <span class="text-danger">*</span></label>
											<input type="text" class="form-control aplha_only" placeholder="Full Name" name="txt_username" id="txt_username" value="{{old('txt_username')}}" required>
										<span class="text-danger" id="divtxt_username"></span>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_email">Email Id <span class="text-danger">*</span></label>
											<input type="email" class="form-control" placeholder="Your E-mail" name="txt_email" id="txt_email" value="{{old('txt_email')}}" required>
											<span class="text-danger" id="divtxt_email"></span>
										</div>
									</div>
									
								</div>
                                <div class="row">
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_mobileno">Mobile No. <span class="text-danger">*</span></label>
											<input type="number" class="form-control" placeholder="Mobile No." name="txt_mobileno" id="txt_mobileno" value="{{old('txt_mobileno')}}"  required>
											<span class="text-danger" id="divtxt_mobileno"></span>
										</div>
									</div>
									<div class="col-sm-6">    
										<div class="form-group">
											<label class="control-label" for="txt_dob">Date Of Birth <span class="text-danger">*</span></label>
											<div id="demo-dp-txtinput">
												<input name="txt_dob" id="txt_dob" type="text" class="form-control empty" date_format="YYYY-mm-dd" placeholder="dd/mm/yyyy" autocomplete="off"  value="{{old('txt_dob')}}"  required>
											</div>
											<span class="text-danger" id="divtxt_dob"></span>
										</div>
									</div>

									<div class="col-sm-6">
											<div class="form-group">
					                            <label class="control-label">Country</label>
					                            <select class="selectpicker opt" id="dd_country" name="dd_country" data-live-search="true" data-width="100%">
					                                <option>Select Country</option>
					                                @foreach($data['country'] as $value)
					                                <option value="{{$value->LOC_ID}}">{{$value->LOC_NAME}}</option>
					                                @endforeach
					                            </select>
					                            <span class="text-danger" id="divdd_country"></span>
					                        </div>
									</div>
									<div class="col-sm-6">
											<div class="form-group">
					                            <label class="control-label">State</label>
												<select class="selectpicker opt" id="dd_state" name="dd_state" data-live-search="true" data-width="100%">
					                                <option>Select State</option>
					                            </select>
					                        <span class="text-danger" id="divdd_state"></span>
					                   </div>
									</div>
									<div class="col-sm-6">
											<div class="form-group">
					                            <label class="control-label">City</label>
					                            <select class="selectpicker opt" name="dd_city" id="dd_city" data-live-search="true" data-width="100%">
					                                <option>Select City</option>
					                            </select>
					                        <span class="text-danger" id="divdd_city"></span>
					                  </div>
									</div>
								</div>
                                <div class="row">
									<div class="col-sm-12">
										<div class="form-group">
											<label class="control-label" for="txt_address">Address <span class="text-danger">*</span></label>
											<textarea class="form-control empty" name="txt_address" id="txt_address" rows="5" style="height:;"required>{{old('txt_address')}}</textarea>
											<span class="text-danger" id="divtxt_address"></span>
										</div>
									</div>

									<div class="col-sm-12">
										<div class="form-group">
											<label class="control-label" for="dd_role">Role <span class="text-danger">*</span></label>
											<select class="selectpicker opt" data-live-search="true" data-width="100%" name="dd_role" id="dd_role" required>
												<option value="" {{ old('dd_role') == ''? 'selected':''}}>Select Role</option>
												<option value="3" {{ old('dd_role') == 3? 'selected':''}}>SUPPORT</option>
												<option value="5" {{ old('dd_role') == 5? 'selected':''}}>TECHNICAL</option>
												<option value="7" {{ old('dd_role') == 7? 'selected':''}}>BACKOFFICE</option>
											</select>
											<span class="text-danger" id="divdd_role"></span>
										</div>
									</div>  
								
                                <div class="row">
									</div>	<legend>KYC Details</legend>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_aadhar">Aadhar Number <span style="color: #e30808;font-size: 10px;">(eg. 1234 5678 9876)</span></label>
											<input type="text" id="txt_aadhar" name="txt_aadhar" class="form-control aadhar" placeholder="Enter Aadhar Number." value="{{old('txt_aadhar')}}">
											<span class="text-danger" id="divtxt_aadhar"></span>
										</div>
                                    </div>
								
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_panno">PAN Card Number <span style="color: #e30808;font-size: 10px;">(eg. ALMPJ4444J)</span></label>
											<input type="text" id="txt_panno" name="txt_panno" class="form-control pan" placeholder="Enter PAN Card Number."  value="{{old('txt_panno')}}">
											<span class="text-danger" id="divtxt_panno"></span>
										</div>
                                    </div>
								</div>  
								
                                <div class="row">
									<legend>Account Details</legend>
								<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="dd_bank">Bank Name</label>
											<select class="form-control selectpicker" name="dd_bank" id="dd_bank" data-live-search="true" data-width="100%">
												@foreach($banks as $b)
												<option value="{{$b->BANK_ID}}">{{$b->BANK_NAME}}</option>
												@endforeach
											</select>
										</div>
                                    </div>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_branchname">Branch Name</label>
											<input type="text" id="txt_branchname" name="txt_branchname" class="form-control" placeholder="Enter Branch Name." >
										</div>
                                    </div>
								
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_ifsccode">IFSC Code <span style="color: #e30808;font-size: 10px;">(eg. ASDF1234567)</span></label>
											<input type="text" id="txt_ifsccode" name="txt_ifsccode" class="form-control ifsc" placeholder="Enter IFSC Code."  value="{{old('txt_ifsccode')}}">
											<span class="text-danger" id="divtxt_ifsccode"></span>
										</div>
                                    </div>
                                    	<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_accno">Account Number <span style="color: #e30808;font-size: 10px;">(eg. 1233455345345)</span></label>
											<input type="text" id="txt_accno" name="txt_accno" class="form-control accno" placeholder="Enter Account Number."  value="{{old('txt_accno')}}">
											<span class="text-danger" id="divtxt_accno"></span>
										</div>
                                    </div>
									
									<input type="hidden" name="dd_status" value="1">
									<input type="hidden" name="txt_shopname" value="sads">
									<input type="hidden" name="txt_gstno" value="sdfs">
								</div>  
								
                                <div class="row">
                                    <legend>Login Details</legend>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_password">Password <span class="text-danger">*</span></label>
                                            <input type="password" class="form-control" placeholder="Password" name="txt_password" id="txt_password" required>

											<span class="text-danger" id="divtxt_password"></span>
										</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_confpassword">Confirm Password <span class="text-danger">*</span></label>
                                            <input type="password" class="form-control" placeholder="Password" name="txt_confpassword" id="txt_confpassword" required>
											<span class="text-danger" id="divtxt_confpassword"></span>
										</div>
									</div>
								</div>
                               
		

                                <div class="row">
								<div class="col-md-12 text-center">
									<div class="checkbox" style="margin-top: 28px;">
										<input id="terms" class="magic-checkbox empty" type="checkbox" name="ckbterms" value="0" required>
									<label for="terms">I Accept Terms & Condition</label>
									</div>
									<span class="text-danger" id="divterms"></span>
								</div>
								</div>
							</div>
                            <div class="panel-footer text-center">
                                <button id="regbtn" class="btn btn-success" type="button" onclick="conw_v('empForm')">Register</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
    <!--===================================================-->
    <!--End page content-->
</div>
<!--===================================================-->

<!--END CONTENT CONTAINER-->
@endsection