@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Change Status</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Employee</a></li>
        <li class="active">Change Status</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">All Employee Status Details</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{url('change_status')}}" method="POST">
                        {{ csrf_field() }} 
                        <div class="panel-body">

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="control-label">Members</label>
                                    <div class="radio">
                                        <input id="rballmembers" class="magic-radio" type="radio" name="rbmembers" value="0" >
                                        <label for="rballmembers">All Members</label>

                                        <input id="rbjoinmember" class="magic-radio" type="radio" name="rbmembers" value="1">
                                        <label for="rbjoinmember">Join Member</label>

                                        <input id="rbtopupmember" class="magic-radio" type="radio" name="rbmembers" value="2">
                                        <label for="rbtopupmember">Topup Member</label>
                                    </div>
                                </div>
                            </div>    

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txtfromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txtfromdate" id="txtfromdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txttodate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txttodate" id="txttodate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txtuserid">Employee Id</label>
                                    <input type="text" id="txtuserid" name="txtuserid" class="form-control" placeholder="Enter Employee Id." >
                                </div>
                            </div>
                            
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label">Position</label>
                                    <select class="form-control selectpicker" data-live-search="true" data-width="100%">
                                        <option>Select</option>
                                        <option>Left</option>
                                        <option>Right</option>
                                    </select>
                                </div>
                            </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-primary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">

                <div class="col-md-12 mb-10 mt-10">
                        @if( Session::get('USER_ID') == -1 )
                
                        <button type="button" id="activate_user" class="btn btn-success pull-left mr-5" data-toggle="tooltip" data-placement="bottom" title="ACTIVATE EMPLOYEE" data-original-title="ACTIVATE EMPLOYEE">ACTIVATE EMPLOYEE</button>
                        
                        <button type="button" id="deactivate_user" class="btn btn-warning pull-left mr-5" data-toggle="tooltip" data-placement="bottom" title="DEACTIVATE EMPLOYEE" data-original-title="DEACTIVATE EMPLOYEE">DEACTIVATE EMPLOYEE</button>

                        <button type="button" id="block_user" class="btn btn-pink pull-left mr-5" data-toggle="tooltip" data-placement="bottom" title="BLOCK EMPLOYEE" data-original-title="BLOCK EMPLOYEE">BLOCK EMPLOYEE</button>
                        
                        <button type="button" id="unblock_user" class="btn btn-danger pull-left mr-5" data-toggle="tooltip" data-placement="bottom" title="UNBLOCK EMPLOYEE" data-original-title="UNBLOCK EMPLOYEE">UNBLOCK EMPLOYEE</button>
                        
                        <button type="button" id="stop_user" class="btn btn-primary pull-left mr-5" data-toggle="tooltip" data-placement="bottom" title="STOP ALL EMPLOYEE" data-original-title="STOP ALL EMPLOYEE">STOP ALL EMPLOYEE</button>
                        @endif
						<button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('emp_changestatus');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button>
                </div>
                <div class="panel-body">
            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th><input type="checkbox" name="all_check" id="all_check" value="-1"/></th>
                                <th>MEMBER NAME</th>
                                <th>CONTACTNO</th>
								<th>EMAIL</th>
								<th>DESIGNATION</th>
                                <th>POSITION</th>
                                <th>JOINING DATE</th>     
                                <th>STATUS</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $sn = 1;$lvl_no="1"; $totalpv=0.00;$totalretopup_pv=0.00;?>
                                @if( !empty($user_report))
                                    @foreach( $user_report as $con)
                            <tr>
                                <td><input type="checkbox" name="activate" value="{{$con->RegId}}" /></td>
                                <td>{{$con->MemberName}}</td>
                                <td>{{ $con->MemberContactNo }}</td>
								<td>{{ $con->MemberEmail }}</td>
								<td>{{ $con->Role}}</td>
                                <td>{{ $con->Position}}</td>
								 <td>{{ $con->JOINING_DATE}}</td>
                                <td>{{ $con->MemberStatus }}</td>
                                </tr>
                             @endforeach
                            @endif
                        </tbody>
                            </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
    $('#all_check').click(function (e){
        $(this).closest('table').find('td input:checkbox').prop('checked', this.checked);
    });

    $('#activate_user').click(function(){
    var myCheckboxes = new Array();
    $("input[name='activate']:checked").each(function(){
    if($(this).val()>0)
    myCheckboxes.push($(this).val());
    });
    if(myCheckboxes.length > 0)
    {
    $.ajax({    
        type:"POST",
        url:"{{ url('/emp_updatestatus') }}",
        dataType: 'json',
        data:{"regid":myCheckboxes,"status":"1",_token: '{{csrf_token()}}',_method: "PATCH"},
        success: function(response){
                alert("Member Update Successfully!");
                window.location.reload(); 
        },
        error: function( req, status, err ) {
            console.log( 'something went wrong', status, err );
            alert(err);
        }
        }); 
    }
    else
    {
        alert("Please select user for change the status.");
    }
    });
    
$('#deactivate_user').click(function(){
    var myCheckboxes = new Array();
    $("input[name='activate']:checked").each(function(){
    myCheckboxes.push($(this).val());
    });
    if(myCheckboxes.length > 0)
    {
        $.ajax({    
            type:"POST",
            url:"{{ url('emp_updatestatus') }}",
            dataType: 'json',
            data:{"regid":myCheckboxes, "status":"2",_token: '{{csrf_token()}}',_method: "PATCH"},
            success: function(response){
                    alert("Member Update Successfully!");
                    window.location.reload(); 
            },
            error: function( req, status, err ) {
                console.log( 'something went wrong', status, err );
                alert(err);
            }
        }); 
    }
    else
    {
        alert("Please select user for change the status.");
    }
});

$('#block_user').click(function(){
    var myCheckboxes = new Array();
    $("input[name='activate']:checked").each(function(){
    myCheckboxes.push($(this).val());
    });
    if(myCheckboxes.length > 0)
    {
        $.ajax({    
            type:"POST",
            url:"{{ url('emp_updatestatus') }}",
            dataType: 'json',
            data:{"regid":myCheckboxes, "status":"8",_token: '{{csrf_token()}}',_method: "PATCH"},
            success: function(response){
                    alert("Member Update Successfully!");
                    window.location.reload(); 
            },
            error: function( req, status, err ) {
                console.log( 'something went wrong', status, err );
                alert(err);
            }
        }); 
    }
    else
    {
        alert("Please select user for change the status.");
    }
});

$('#unblock_user').click(function(){
    var myCheckboxes = new Array();
    $("input[name='activate']:checked").each(function(){
    myCheckboxes.push($(this).val());
    });
    if(myCheckboxes.length > 0)
    {
        $.ajax({    
            type:"POST",
            url:"{{ url('emp_updatestatus') }}",
            dataType: 'json',
            data:{"regid":myCheckboxes, "status":"1",_token: '{{csrf_token()}}',_method: "PATCH"},
            success: function(response){
                    alert("Member Update Successfully!");
                    window.location.reload(); 
            },
            error: function( req, status, err ) {
                console.log( 'something went wrong', status, err );
                alert(err);
            }
        }); 
    }
    else
    {
        alert("Please select user for change the status.");
    }
});

$('#stop_user').click(function(){

    $.ajax({    
        type:"POST",
        url:"{{ url('stop_all_emp') }}",
        dataType: 'json',
        data:{"regid":"-1", "status":"2",_token: '{{csrf_token()}}',_method: "PATCH"},
        success: function(response){
                alert("Member Update Successfully!");
                window.location.reload(); 
        },
        error: function( req, status, err ) {
            console.log( 'something went wrong', status, err );
            alert(err);
        }
    }); 
    
});
</script>
@endsection