@extends('mainlayout')
@section('content')
<style>
   .error {
   border-color: red;
   }
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
   <div id="page-head">
      <!--Page Title-->
      <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
      <div id="page-title">
         <h1 class="page-header text-overflow">Edit Member Shop Details</h1>
      </div>
      <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
      <!--End page title-->
      <!--Breadcrumb-->
      <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
      <ol class="breadcrumb">
         <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
         <li><a href="{{ url('/admin_dashboard') }}">Member</a></li>
         <li class="active">Edit Member Shop Details</li>
      </ol>
      <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
      <!--End breadcrumb-->
   </div>
   <!--Page content-->
   <!--===================================================-->
   <div id="page-content">
      <div class="row">
         <div class="col-lg-offset-3 col-lg-6">
            <div class="panel">
               @if ($errors->any())
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               @if(Session::has('message')) 
               <div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
                  <h4 class="alert-heading">{{ Session::get('message') }}</h4>
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                  </button>
               </div>
               @endif
               <div class="panel-heading">
                  <div class="panel-control">
                     <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                  </div>
                  <h3 class="panel-title">Edit Member Shop Details</h3>
               </div>
               <div class="collapse in">
                  <form action="{{url('edit_shopdetails')}}" id="shop_edit" method="post" accept-charset="utf-8">
                     {{ csrf_field() }} 
                     <div class="panel-body">
                        <div class="row">
                           <div class="col-sm-6">
                              <div class="form-group">
                                 <label class="control-label" for="txt_memberid">Member Id *</label>
                                 <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." required value="{{$USERID}}"  autocomplete="off">
								         <ul class="list-group costom-list" id="member_name"> </ul> 
                              </div>
                           </div>
                           <div class="col-sm-6">
                              <div class="form-group">
                                 <label class="control-label" style="display:block;">&nbsp;</label>
                                 <button class="btn btn-success" type="submit">Find</button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </form>
                  @if($user_shop_details != '')
                  @foreach( $user_shop_details as $con)
                  @endforeach
                  <form action="{{ url('update_shop')}}" enctype="multipart/form-data" id="shop_update" 
                     method="post" accept-charset="utf-8">
                     {{ csrf_field() }}
                     <div class="panel-body">
                        <input id="txt_membercode" name="txt_membercode" type="hidden" required value="{{$con->RegCode}}" readonly>
                        <input id="txt_userid" name="txt_userid" type="hidden" required="required" value="{{$con->RegId}}" readonly>
                        <input type="hidden" name="txt_shop_id" id="txt_shop_id" class="form-control" value="{{$shop_info[0]->m22_shop_id}}" required>
                        <div class="row">
							     <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label" for="txt_shop_name">Shop Name</label>
                                    <input type="text" name="txt_shop_name" id="txt_shop_name" class="form-control empty" value="{{$con->Shop_CompanyName}}">
                                    <span id="spantxt_shop_name" class="text-danger"></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label" for="txt_shop_gst">GST Number</label>
                                    <input type="text" name="txt_shop_gst" id="txt_shop_gst" class="form-control" value="{{$con->ShopGST}}" >
                                    <span id="spantxt_shop_gst" class="text-danger"></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label" for="txt_shop_image">Shop Front Image</label>
                                    <input type="file" name="txt_shop_image" id="txt_shop_image" class="form-control">
                                    <input type="hidden" name="txt_shophd" id="txt_shophd" value="{{$con->ShopIMAGE}}"> 
                                </div>
                           <div class="text-center">
                                   @if($con->ShopIMAGE!='')
                           <img src="{{ asset('/images/SHOP_IMAGE/'.$con->ShopIMAGE) }}" height="100" />
                           @else
                           <img src="{{ asset('images/user.png') }}" height="100" />
                           @endif
                           </div>
                               </div>

                               <div class="col-md-6">
                                   <div class="form-group">
                                       <label class="control-label" for="txt_gst_image">GST Certificate</label>
                                       <input type="file" name="txt_gst_image" id="txt_gst_image" class="form-control">
                                       <input type="hidden" name="txt_gsthd" id="txt_gsthd" value="{{$con->ShopGSTImage}}"> 
                                   </div>
                           <div class="text-center">
                                   @if($con->ShopGSTImage!='')
                           <img src="{{ asset('/images/GST_CERTIFICATE/'.$con->ShopGSTImage) }}" height="100" />
                           @else
                           <img src="{{ asset('images/user.png') }}" height="100" />
                           @endif
                           </div>
                        </div>

                     

                   

                            <div class="col-md-6">
                              <div class="form-group">
                                 <label class="control-label" for="dd_shop_type">Shop Type</label>
                                 <select class="form-control selectpicker empty" name="dd_shop_type" id="dd_shop_type" data-live-search="true" data-width="100%">
                                    <option value="-1">SELECT TYPE</option>
                                    <option value="1" {{($con->ShopType1==1)?'selected':''}}>Kirana Shop</option>
                                    <option value="2" {{($con->ShopType1==2)?'selected':''}}>Mobile Shop</option>
                                    <option value="3" {{($con->ShopType1==3)?'selected':''}}>Copier Shop</option>
                                    <option value="4" {{($con->ShopType1==4)?'selected':''}}>Internet Cafe</option>
                                    <option value="5" {{($con->ShopType1==5)?'selected':''}}>Medical Store</option>
                                    <option value="6" {{($con->ShopType1==6)?'selected':''}}>PanShop</option>
                                    <option value="7" {{($con->ShopType1==7)?'selected':''}}>Confectionary Store</option>
                                 </select>
                                 <span id="spandd_shop_type" class="text-danger"></span>
                              </div>
                            </div>

                            <div class="col-md-6">
                              <div class="form-group">
                                 <label class="control-label" for="dd_loc_type">Locality Type</label>
                                 <select class="form-control selectpicker empty" name="dd_loc_type" id="dd_loc_type" data-live-search="true" data-width="100%">
                                    <option value="-1">SELECT LOCALITY TYPE</option>
                                    <option value="1" {{($con->ShopLocationType1==1)?'selected':''}}>Rural</option>
                                    <option value="2" {{($con->ShopLocationType1==2)?'selected':''}}>Urban</option>
                                    <option value="3" {{($con->ShopLocationType1==3)?'selected':''}}>Semi Urban</option>
                                 </select>
                                 <span id="spandd_loc_type" class="text-danger"></span>
                              </div>
                            </div>

                            <div class="col-md-6">
                              <div class="form-group">
                                 <label class="control-label" for="dd_popl">Select Population</label>
                                 <select class="form-control selectpicker empty" name="dd_popl" id="dd_popl" data-live-search="true" data-width="100%">
                                    <option value="-1">SELECT POPULATION</option>
                                    <option value="1" {{($con->ShopNearPollution1==1)?'selected':''}}>0 to 2000</option>
                                    <option value="2" {{($con->ShopNearPollution1==2)?'selected':''}}>2000 to 5000</option>
                                    <option value="3" {{($con->ShopNearPollution1==3)?'selected':''}}>5000 to 10000</option>
                                    <option value="4" {{($con->ShopNearPollution1==4)?'selected':''}}>10000 to 50000</option>
                                    <option value="5" {{($con->ShopNearPollution1==5)?'selected':''}}>10000 to 50000</option>
                                 </select>
                                 <span id="spandd_popl" class="text-danger"></span>
                              </div>
                            </div>

                            <div class="col-sm-6">
                              <div class="form-group">
                                  <label class="control-label">Country</label>
                                  <select class="form-control selectpicker empty" id="dd_country" name="dd_country" data-live-search="true" data-width="100%">
                                      <option value="-1">Select Country</option>
                                      @foreach($data['country'] as $value)
                                      <option value="{{$value->LOC_ID}}" {{$con->ShopCountry == $value->LOC_ID ? 'selected' : ''}}>{{$value->LOC_NAME}}</option>
                                      @endforeach
                                  </select>
                                  <span id="spandd_country" class="text-danger"></span>
                              </div>
                           </div>
                           <div class="col-sm-6">
                              <div class="form-group">
                                 <label class="control-label">State</label>
                                 <select class="form-control selectpicker empty" id="dd_state" name="dd_state" data-live-search="true" data-width="100%">
                                    <option value="-1">Select State</option>
                                    @foreach($state as $value)
                                    <option value="{{$value->LOC_ID}}" {{$con->ShopState == $value->LOC_ID ? 'selected' : ''}}>{{$value->LOC_NAME}}</option>
                                    @endforeach
                                 </select>
                                 <span id="spandd_state" class="text-danger"></span>
                              </div>
                           </div>
                           <div class="col-sm-6">
                              <div class="form-group">
                                  <label class="control-label">City</label>
                                  <select class="form-control selectpicker empty" name="dd_city" id="dd_city" data-live-search="true" data-width="100%">
                                      <option value="-1">Select City</option>
                                       @foreach($city as $value)
                                      <option value="{{$value->LOC_ID}}" {{$con->ShopCity == $value->LOC_ID ? 'selected' : ''}}>{{$value->LOC_NAME}}</option>
                                      @endforeach
                                  </select>
                                  <span id="spandd_city" class="text-danger"></span>
                              </div>
                           </div>

                           <div class="col-md-6">
                              <div class="form-group">
                                 <label class="control-label" for="txt_block">Block</label>
                                 <input type="text" class="form-control empty" id="txt_block" name="txt_block" value="{{$con->ShopBlock}}">
                              </div>
                           </div>

                           <div class="col-md-6">
                              <div class="form-group">
                                 <label class="control-label" for="txt_mohhalla">Mohhalla</label>
                                 <input type="text" class="form-control empty" id="txt_mohhalla" name="txt_mohhalla" value="{{$con->ShopMohhalla}}">
                              </div>
                           </div>

                           <div class="col-md-6">
                              <div class="form-group">
                                 <label class="control-label" for="txt_landmark">Landmark</label>
                                 <input type="text" class="form-control empty" id="txt_landmark" name="txt_landmark" value="{{$con->ShopLandmark}}">
                              </div>
                           </div>

                           <div class="col-md-6">
                              <div class="form-group">
                                 <label class="control-label" for="txt_pincode">Pincode</label>
                                 <input type="text" class="form-control numeric" id="txt_pincode" name="txt_pincode" value="{{$con->ShopPincode}}">
                                 <span id="spantxt_pincode" class="text-danger"></span>
                              </div>
                           </div>

                           <div class="col-md-12">
                              <div class="form-group">
                                 <label class="control-label" for="txt_address">Address</label>
                                 <textarea class="form-control empty" id="txt_address" name="txt_address" rows="5">{{$con->Shop_Address}}</textarea>
                              </div>
                           </div>
                     </div>
                     <div class="panel-footer text-center">
                        <button class="btn btn-success" type="button" onclick="conwv('shop_update');">UPDATE</button>
                        <button type="reset" class="btn btn-primary">RESET</button>	
                     </div>
                  </form>
                  @endif
               </div>
            </div>
         </div>
      </div>
   </div>
   <!--===================================================-->
   <!--End page content-->
</div>
@endsection