@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Edit Employee Profile</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Employee</a></li>
			<li class="active">Edit Employee Profile</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
			<li>{{ $error }}</li>
            @endforeach
		</ul>
	</div>
    @endif
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
                        <h3 class="panel-title">Edit Employee Profile</h3>
					</div>
                    
                    <div class="collapse in">	
					@if(Session::has('message')) 
							<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
								<h4 class="alert-heading">{{ Session::get('message') }}</h4>
								<button type="button" class="close" data-dismiss="alert" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
						@endif
						<form action="{{'edit_employee'}}" id="profile_edit" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_empid">Employee Id *</label>
                                            <input type="text" id="txt_empid" name="txt_empid" class="form-control" placeholder="Enter Employee Id." required value={{$EMPID}}>
										</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
										</div>
									</div>
								</div>
							</div>    
						</form>  
						
						@if($get_empalldetail != '')
						@foreach( $get_empalldetail as $con)
						@endforeach
						<form id="profile_update" action="{{ url('update_empprofile') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
							{{ csrf_field() }}
							<div class="panel-body">
								<input id="txt_membercode" name="txt_membercode" type="hidden" required value="{{$con->RegCode}}" readonly>
						<input id="txt_empid" name="txt_empid" type="hidden" required="required" value="{{$con->RegId}}" readonly>
						<div class="row">
<legend>Personal Details</legend>
							<div class="col-sm-4">
                                <div class="form-group">
                                    <label class="control-label" for="txt_referralcode">Referral Employee Id *</label>
                                    <input type="text" id="txt_referralcode" name="txt_referralcode" class="form-control empty" placeholder="Enter Referral Employee Id." required  onfocusout="get_employee_name();" onfocusin="get_employee_name();"  value="{{ $con->ReferralCode}}" readonly>
								</div>
							</div>    
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="control-label" for="txt_username">Name</label>
                                    <input type="text" class="form-control empty" placeholder="Referral Name" name="txt_referralname" id="txt_referralname" required autocomplete="off" value="{{ $con->ReferralName}}" readonly>
								</div>
							</div>
							<div class="col-sm-4">
                                        <div class="form-group">
                                            <label class=" control-label">Position</label>
                                            <div class="" style="margin-top: 5px;">
                                                <input id="demo-inline-form-radio-2" class="magic-radio" type="radio" name="position" value="JUNIOR" {{ $con->Position == 'JUNIOR' ? 'checked' : ''}} required>
                                                <label for="demo-inline-form-radio-2">Junior</label>
                                                <input id="demo-inline-form-radio-3" class="magic-radio" type="radio" name="position" value="SENIOR" {{ $con->Position == 'SENIOR' ? 'checked' : ''}}>
                                                <label for="demo-inline-form-radio-3">Senior</label>
											</div>
										</div>
									</div>
						</div>
								<div class="row">

									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_username">Name <span style="color: #e30808;font-size: 10px;">(eg.First Name {SPACE} Last Name)</span></label>
											<input type="text" id="txt_username" name="txt_username" class="form-control" value="{{$con->FirstName}} {{ $con->LastName}}" required>
										</div>
									</div>
									
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_email">Email Id</label>
											<input type="text" id="txt_email" name="txt_email" class="form-control" value="{{$con->MemberEmail}}" required>
										</div>
									</div>
								</div>
								<div class="row">	
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_mobileno">Mobile No.</label>
											<input type="text" id="txt_mobileno" name="txt_mobileno" class="form-control" value="{{$con->MemberContactNo}}" required>
										</div>
									</div>
									<div class="col-sm-6">    
										<div class="form-group">
											<label class="control-label" for="txt_dob">Date Of Birth</label>
											<div id="demo-dp-txtinput">
												<input id="txt_dob" name="txt_dob" type="text" class="form-control" value="{{$con->MemberDOB}}" autocomplete="off" required >
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-sm-12">
										<div class="form-group">
											<label class="control-label" for="txt_address">Address</label>
											<textarea class="form-control" name="txt_address" id="txt_address" rows="5" required>{{ $con->MemberLocation}}</textarea>
										</div>
									</div>
									<div class="col-sm-6">   
										<div class="form-group">
											<label class="control-label" for="txt_pin">Postal Code</label>
											<input type="text" id="txt_postalcode" name="txt_postalcode" class="form-control" placeholder="Enter Pin Code." required value="{{$con->MemberPostalCode}}">
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="dd_role">Role</label>
											<select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_role" id="dd_role" required>
												<option value="3" {{$con->MemberRole == 'SUPPORT' ? 'selected' : ''}}>SUPPORT</option>
												<option value="5" {{$con->MemberRole == 'TECHNICAL' ? 'selected' : ''}}>TECHNICAL</option>
												<option value="7" {{$con->MemberRole == 'BACKOFFICE' ? 'selected' : ''}}>BACKOFFICE</option>
											</select>
										</div>
									</div>
	</div>
								<div class="row">
							<div class="col-sm-6"><div class="form-group">
									<label class="control-label" for="txt_yourphoto">Your Photo Upload</label><br>
											<input type="hidden" name="txt_yourphotohd" id="txt_yourphotohd" value="{{$con->MemberImage}}"> 
											<input type="file" name="txt_yourphoto" id="txt_yourphoto" class="form-control" required>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
											
											@if($con->MemberImage!='')
										<img src="{{ asset('/images/USER_PHOTO/'.$con->MemberImage) }}" height="100" />
										@else
										<img src="{{ asset('images/user.png') }}" height="100" />
										@endif
</div></div>
								</div>
                                <div class="row">
									</div>	<legend>KYC Details</legend>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_aadhar">Aadhar Number <span style="color: #e30808;font-size: 10px;">(eg. 1234 5678 9876)</span></label>
											<input type="text" id="txt_aadhar" name="txt_aadhar" class="form-control" placeholder="Enter Aadhar Number." onchange="aadharValidate();"  value="{{$con->AadharCard}}" required>
											<span id="txt_aad_err" style="color:red;"></span>
										</div>
                                    </div>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_panno">PAN Card Number <span style="color: #e30808;font-size: 10px;">(eg. ALMPJ4444J)</span></label>
											<input type="text" id="txt_panno" name="txt_panno" class="form-control" placeholder="Enter PAN Card Number." onchange="panValidate();"  value="{{$con->Pancarno}}" required>
											<span id="txt_pan_err" style="color:red;"></span>
										</div>
										<span class="error"></span>
                                    </div>
                                <div class="row">
									</div>	<legend>Bank Details</legend>
									 <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="dd_bank">Bank Name</label>
											<select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_bank" id="dd_bank">
												@foreach($banks as $b)
												<option value="{{$b->BANK_ID}}">{{$b->BANK_NAME}}</option>
												@endforeach
											</select>
										</div>
                                    </div>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_branchname">Branch Name</label>
											<input type="text" id="txt_branchname" name="txt_branchname" class="form-control" placeholder="Enter Branch Name." value="{{$con->Branch}}" required>
										</div>
                                    </div>
                                    <div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_ifsccode">IFSC Code <span style="color: #e30808;font-size: 10px;">(eg. ASDF1234567)</span></label>
											<input type="text" id="txt_ifsccode" name="txt_ifsccode" class="form-control" placeholder="Enter IFSC Code." onchange="ifscValidate();" value="{{$con->IFSCode}}"  required>
											<span id="txt_ifsc_err" style="color:red;"></span>
										</div>
                                    </div>
								<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_accno">Account Number <span style="color: #e30808;font-size: 10px;">(eg. 1233455345345)</span></label>
											<input type="text" id="txt_accno" name="txt_accno" class="form-control" placeholder="Enter Account Number." onchange="accnoValidate();"   value="{{$con->CBSACno}}"  required>
											<span id="txt_acc_err" style="color:red;"></span>
										</div>
                                    </div>
                                   
								</div>  

							 
								
							</div>
							<div class="panel-footer text-center">
								<button class="btn btn-success" type="button" onclick="conwv('profile_update')">UPDATE</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
							</div>
						</form>
						@endif
						
					</div>
					
				</div>
			</div>
            
		</div>
        
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>

@endsection