@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">LUCKY DRAW COUPAN REPORT</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="panel">
                @if(Session::has('cpadd_msg')) 
                <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                  <h4 class="alert-heading">{{ Session::get("cpadd_msg") }}</h4>
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                @endif
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">LUCKY DRAW COUPAN  REPORT</h3>
                </div>

                <div class="collapse in">

                    <form action="{{url('/coupon')}}" method="POST">
                    {{ csrf_field() }}
                        <div class="panel-body">

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txt_fromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                    </div>
                                </div>                                
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txt_todate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txt_user_id">User Id</label>
                                    <input type="text" id="txt_user_id" name="txt_user_id" class="form-control" placeholder="Enter User Id." >
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label" for="txt_coupon_no">Coupan Number</label>
                                    <input type="text" id="txt_coupon_no" name="txt_coupon_no" class="form-control" placeholder="Enter Voucher Number." >
                                </div>
                            </div>
                          
                        </div>

                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-success" type="button">Export To Excel</button>
                        </div>
                    </form>
                </div>

            </div>
        </div> 

        <div class="row">
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">HOLIDAYS COUPAN  REPORT</h3>
                </div>
            
                <div class="collapse in">
                    <div class="panel-body">
                        <div class="text-right">
                            <div class="form-group">
                                <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('coupan_report');">Export To Excel</button>
                            </div>
                        </div>
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                              <tr>
                                <th>S.No</th>
                                <th>Member Id</th>
                                <th>Member Name</th>
                                <th>Coupan Number</th>
                                <th>Status</th>
                                <th>Created Date</th>
                                <th>View</th>
                                <th>Redeem</th>
                              </tr>
                            </thead>

                            <tbody>
                                @foreach($coupon as $key=>$value)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$value->USER_CODE}}</td>
                                    <td>{{$value->USER_NAME}}</td>
                                    <td>{{$value->CP_NUMBER}}</td>
                                    <td>{{$value->STATUS}}</td>
                                    <td>{{$value->CREATED_AT}}</td>
                                    <td><a target="_blank" class="btn btn-success btn-xs" href="{{url('/view_coupon/'.$value->CP_ID)}}">VIEW COUPON</a></td>
                                    <td><?php if($value->REDEEM_STATUS=='PENDING'){?>
                                        <button data-id="{{ $value->USER_ID }}" data-coupan="{{$value->CP_NUMBER}}" data-toupid="{{$value->TOPUP_ID}}"  data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val" onClick="get_details(this);" data-userid="{{ $value->USER_CODE }}" data-username="{{ $value->USER_NAME }}" ">REDEEM COUPON</button>
                                        <?php 
                                    }
                                        else{
                                    echo $value->REDEEM_REMARK;
                                      
                               }?>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

 <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content" style="text-align: left;">

                    <form action="{{url('/redeem_coupan')}}" method="POST"> 
                        {{ csrf_field() }}

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title">PAY INCOME HERE</h4>
                        </div>

                        <!--Modal body-->
                        <div class="modal-body">
                            <div class="form-group">
                                <input id="txt_topupid" name="txt_topupid" type="hidden" class="form-control" required="required">
                                
                            </div>
                            <h5>USER ID :-<span id="user_id"></span></h5>

                            <h5>USER NAME :-<span id="user_name"></span></h5>

                            <h5>COUPAN CODE:-<span id="fnl_amt"></span></h5>
                            
                            <h5>REMARKS :-</h5>

                            <div class="form-group">
                                <input type="text" class="form-control" name="txt_remark" id="txt_remark">  
                            </div>
                            <h5 class="text-semibold text-main">Would you like to redeem the coupan ?</h5>

                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                            <button class="btn btn-primary" type="submit">Yes</button>
                        </div>

                    </form>
                    </div>
                </div>
            </div>
            <script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">

function get_details(obj)
{
    var toupid = $(obj).data('toupid');
    var user_id = $(obj).data('userid');
    var user_name = $(obj).data('username');
    var coupan=$(obj).data('coupan');
  
    $('#user_id').text(user_id);
    $('#user_name').text(user_name);
    $('#fnl_amt').text(coupan);
    $('#txt_topupid').val(toupid);
 
}
</script>
@endsection