@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
			<li class="active">Member Change Group</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
                        <h3 class="panel-title">Member Change Group</h3>
					</div>
                    
                    <div class="collapse in">	
					@if(Session::has('message')) 
							<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
								<h4 class="alert-heading">{{ Session::get('message') }}</h4>
								<button type="button" class="close" data-dismiss="alert" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
						@endif
						<form action="{{url('/change_slab')}}" id="profile_edit" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_memberid">Member Id *</label>
                                            <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id."  autocomplete="off">
											<ul class="list-group costom-list" id="member_name"> </ul> 
										</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
										</div>
									</div>
								</div>
							</div>    
						</form>
					</div>  
				</div>
			</div>
		</div>
		
				
		@if($user_details!="")
		<div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <div class="table-responsive">
                 <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>ROLE</th>
                                <th>NAME</th>
                                <th>MOBILENO</th>
                                <th>GROUP</th>
                                <th>INTRODUCER</th>
                                <th>STATUS</th>
                                <th>ACTION</th>             
                            </tr>
                        </thead>
                        <tbody>
                            @foreach( $user_details as $con)
                            <tr>
                                <td>{{ '#' }}</td>
                                <td>{{ $con->MemberRole }}</td>
                                <td>{{$con->FirstName.' '.$con->LastName}} -[ {{$con->RegCode}} ]</td>
                                <td>{{ $con->MemberContactNo }}</td>
                                <td>{{ $con->GroupName }}</td>
                                <td>{{ $con->ReferralMobileNo }}</td>
                                <td>{{ $con->MemberStatus }}</td>
                                <td><button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#intro_modal" title="CHANGE SLAB" onclick="get_user_details(this,'{{ $con->RegId }}');" data-code="{{ $con->RegCode}}" data-groupname="{{ $con->GroupName}}" data-group="{{ $con->GroupId}}" data-mobileno="{{ $con->MemberContactNo}}" data-fname="{{$con->FirstName}}" data-lname="{{$con->LastName}}" >
                                <i class="fa fa-child"></i>
                                </button></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            </div>
        </div>  
		@endif
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
<div class="modal fade" id="intro_modal" role="dialog">
    
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
           <form action="{{'update_usergroup'}}" class="cmxform form-horizontal" enctype="multipart/form-data" method="post">
          {{ csrf_field() }}
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"></span></button>
                <h4 class="modal-title" id="group_modallabel">CHANGE USER GROUP</h4> 
            </div>
            <div class="modal-body fs-12">
                <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="form-group mb-0">
                            <label class="control-label"> ENTER MEMBER CODE</label>  
                            <input id="txt_membercode" name="txt_membercode" type="text" class="typeahead form-control" required="required" autofocus  readonly="true">
                            <span id="divtxt_mobileno" style="color:red;"></span> 
                        </div>     
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12" >
                      <div class="form-group mb-0">
                        <label class="control-label">USER NAME :- <span id="groupuser_name"></span></label>
                      </div>
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12" >
                      <div class="form-group mb-0">
                        <label class="control-label">USER CURRENT GROUP :- <span id="user_group"></span></label>    
                <input id="txt_currentgrouphd" name="txt_currentgrouphd" type="hidden" class="form-control" required="required" value="">                   
                      </div>
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12" >
                        <div class="form-group ">
                            <label class="control-label">SELECT NEW GROUP</label>
                                <select name="dd_group" id="dd_group" class="form-control empty">
                                        <option value="-1">SELECT GROUP</option>
                                        @foreach( $GROUP as $group)
                                        <option value="{{$group->GROUP_ID}}">{{strtoupper($group->GROUP_NAME)}}</option>
                                        @endforeach
                                </select>
                        </div>
                    </div>
            
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal" onclick="javascript:window.location.reload()">CLOSE</button>
                <button type="submit" class="btn btn-primary">SUBMIT</button>
            </div>
            </form>
        </div>
        <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
        
      <script type="text/javascript">

			

		</script>
        <script>
       
            function get_user_details(obj,id)
            {
                $('#txt_membercode').val($(obj).data('code'));
				$("#groupuser_name").html($(obj).data('fname')+' '+$(obj).data('lname'));
				$("#user_group").html($(obj).data('groupname'));
                $('#txt_currentgrouphd').val($(obj).data('group'));
                
            } 
        </script>
    </div>
</div>
@endsection