@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
			<li class="active">Member Change Team</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
					
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
                        <h3 class="panel-title">Member Change Team</h3>
					</div>
                    
                    <div class="collapse in">	
					@if(Session::has('message')) 
							<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
								<h4 class="alert-heading">{{ Session::get('message') }}</h4>
								<button type="button" class="close" data-dismiss="alert" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
						@endif
						<form action="{{url('/change_role')}}" id="profile_edit" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_memberid">Member Id *</label>
                                            <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id."  autocomplete="off">
											<ul class="list-group costom-list" id="member_name"> </ul> 
										</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
										</div>
									</div>
								</div>
							</div>    
						</form>
					</div>  
				</div>
			</div>
		</div>
		
				
		@if($user_details!="")
		<div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <div class="table-responsive">
                 <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>INFO</th>
                                <th>ROLE</th>
                                <th>NAME</th>
                                <th>MOBILENO</th>
                                <th>GROUP</th>
                                <th>STATUS</th>
                                <th>ACTION</th>             
                            </tr>
                        </thead>
                        <tbody>
                       
                            <tr>
                                <td>{{ '#' }}</td>
                                <td>USER</td>
                                <td>{{ $user_details->MemberRole }}</td>
                                <td>{{$user_details->FirstName.' '.$user_details->LastName}}-[{{$user_details->RegCode}} ]</td>
                                <td>{{ $user_details->MemberContactNo }}</td>
                                <td>{{ $user_details->GroupName }}</td>
                                <td>{{ $user_details->MemberStatus }}</td>
                                <td><button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#intro_modal" title="CHANGE TEAM" onclick="get_user_details(this,'{{ $user_details->RegId }}');" data-referralcode="{{$user_details->MemberRole}} "data-referral="{{$user_details->MemberRole}} "data-code="{{ $user_details->RegCode}}" data-mobileno="{{ $user_details->MemberContactNo}}" data-fname="{{$user_details->FirstName}}" data-lname="{{$user_details->LastName}}" >
                                <i class="fa fa-child"></i>
                                </button></td>
                            </tr>

							@if($ReferralUser_details != '')
								@if($ReferralUser_details) >0)
									<tr>
										<td>{{ '#' }}</td>
										<td>INTRODUCER</td>
										<td>{{ $ReferralUser_details->MemberRole }}</td>
										<td>{{$ReferralUser_details->FirstName.' '.$ReferralUser_details->LastName}}-[{{$ReferralUser_details->RegCode}} ]</td>
										<td>{{ $ReferralUser_details->MemberContactNo }}</td>
										<td>{{ $ReferralUser_details->GroupName }}</td>
										<td>{{ $ReferralUser_details->MemberStatus }}</td>
										<td></td>
									</tr>
								@else
									<tr>
										<td>{{ '#' }}</td>
										<td>INTRODUCER</td>
										<td>{{Session::get('USER_ROLE')}}</td>
										<td>{{Session::get('NAME')}}-[{{Session::get('USER_CODE')}} ]</td>
										<td>{{Session::get('CONTACTNO')}}</td>
										<td></td>
										<td>ACTIVE</td>
										<td></td>
									</tr>
								@endif
							@endif
                        </tbody>
                    </table>
                </div>
            </div>
            </div>
        </div>  
		@endif
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
<div class="modal fade" id="intro_modal" role="dialog">
    
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <form action="{{'update_user_role'}}" class="cmxform form-horizontal" enctype="multipart/form-data" method="post">
                {{ csrf_field() }}
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"></span></button>
                    <h4 class="modal-title" id="intro_modallabel">CHANGE USER INTRODUCER DETAILS</h4> 
                </div>
                <div class="modal-body fs-12">
                    
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="form-group mb-0">
                            <label class="control-label"> ENTER MEMBER CODE </label>  
                            <input id="txt_referralcode" name="txt_referralcode" type="text" value="{{$USERID}}" class="typeahead form-control" required autofocus onBlur="get_member_nameintro()" readonly="true">
                            <span id="divtxt_intromobileno" style="color:red;"></span> 
                        </div>     
                    </div>
					<div class="col-md-12 col-sm-12 col-xs-12" >
                        <div class="form-group mb-0">
                            <label class="control-label">USER NAME :- <span id="user_nameintro"></span></label>
                        </div>
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12" >
                        <div class="form-group mb-0">
                            <label class="control-label">USER ROLE :- <span id="oldroles"></span></label>                      
                        </div>
                    </div>
                    <div class="col-md-12 col-sm-12 col-xs-12" >
                        <div class="form-group">
                            <label class="control-label">CHANGE USER ROLE</label>  
                                 	<select  onchange="selectservice(this.id)" name="dd_role" id="dd_role" class="selectpicker opt" data-live-search="true" data-width="100%">
								
											</select>
                            <input id="txt_id" name="txt_id" type="hidden"  class="form-control" required="required">
							<input id="oldrole" name="oldrole" value="" type="hidden"  class="form-control" required="required">
                            <span id="divtxt_newintro" style="color:red;"></span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal" onclick="javascript:window.location.reload()">CLOSE</button>
                    <button type="submit" class="btn btn-primary"  onclick="return confirm('Are you sure you want to Change user Role?')">SUBMIT</button>
                </div>
            </form>
        </div>
        <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
        
	<input id="get_role" name="get_role" value="{{$data}}" type="hidden"  class="form-control" required="required">
						
        <script>
$( document ).ready(function() {
	var ok = $('#get_role').val();
	$('#dd_role').html(ok);
    $('.selectpicker').selectpicker('refresh');
});

            $('.loader').hide();
            function get_img(obj)
            {
                $('#put_img').attr('src', '');
                var key = '{{ asset("/images/")}}/' + $(obj).data('img');
                $('#put_img').attr('src', key);
            }
            function get_user_details(obj,id)
            {
                $('#txt_referralcode').val($(obj).data('code'));
				$("#user_nameintro").html($(obj).data('fname')+' '+$(obj).data('lname'));
				$("#oldrole").val($(obj).data('referral'));
				$("#oldroles").html($(obj).data('referral'));
                $('#txt_id').val(id);
                
            } 
        </script>
    </div>
</div>
@endsection