@extends('mainlayout')
@section('content')

<div class="right_col" role="main" >
	<div class="row">
		<div class="col-md-4 col-sm-12 col-xs-12">
			<div class="x_panel">
				<div class="x_title">
					<h2>{{ $form_name }}</h2>
					<ul class="nav navbar-right panel_toolbox">
						<li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
						</li>
						<li><a class="close-link"><i class="fa fa-close"></i></a>
						</li>
					</ul>
					<div class="clearfix"></div>
				</div>
				<div class="x_content">
					<div class="col-md-12 col-sm-12 col-xs-12">
						<div class="card-box">
							<div class="form">
								@if(Session::has('message')) 
								<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
									<h4 class="alert-heading">{{ Session::get("message") }}</h4>
									<button type="button" class="close" data-dismiss="alert" aria-label="Close">
										<span aria-hidden="true">&times;</span>
									</button>
								</div>
								@endif
								<form action="{{ url('change_parent') }}" class="cmxform form-horizontal" id="signupForm" method="post" accept-charset="utf-8">
									{{ csrf_field() }} 
									
									<div class="col-md-12 col-sm-12 col-xs-12" >
										<div class="form-group">
											<label class="control-label">MemberId</label>  
											<input id="txt_memberid" type="text" name="txt_memberid"  class="form-control" required="required">
											<span id="divtxt_memberid" style="color:red;"></span> 
										</div>
									</div>
									<div class="clearfix"></div>
									<div class="clearfix"></div>
									<div class="col-md-12 col-sm-12 col-xs-12">
										<div class="form-group">
											<div class="col-md-offset-4 col-md-8">
												<button type="submit" class="btn btn-success">Submit</button>
												<button type="reset" class="btn btn-primary">Reset</button>	
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--/div>
		<div class="row"-->
		@if($user_details!="")
		<div class="col-md-8 col-sm-12 col-xs-12">
			<div class="x_panel">
				<div class="x_title">
					<h2>{{ $form_name }}</h2>
					<ul class="nav navbar-right panel_toolbox">
						<li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
						</li>
						<li><a class="close-link"><i class="fa fa-close"></i></a>
						</li>
					</ul>
					<div class="clearfix"></div>
				</div>
				<div class="x_content">
					<!-- start project list -->
					<table class="table table-striped" id="datatable">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>ROLE</th>
								<th>NAME</th>
								<th>MOBILENO</th>
								<th>GROUP</th>
								<th>PARENT</th>
								<th>STATUS</th>
								<th>ACTION</th>
							</tr>
						</thead>
						<tbody>
							@foreach( $user_details as $con)
							<tr>
								<td>{{ '#' }}</td>
								<td>{{ $con->MemberRole }}</td>
								<td>{{$con->FirstName.' '.$con->LastName}}</td>
								<td>{{ $con->MemberContactNo }}</td>
								<td>{{ $con->GroupName }}</td>
								<td>{{ $con->ParentMobileNo }}</td>
								<td>{{ $con->MemberStatus }}</td>
								<td><button type="button" class="btn btn-default btn-xs" data-toggle="modal" data-target="#intro_modal" title="CHANGE TEAM" onclick="get_user_details(this,'{{ $con->RegId }}');" data-mobileno="{{ $con->MemberContactNo}}" data-fname="{{$con->FirstName}}" data-lname="{{$con->LastName}}" >
								<i class="fa fa-child"></i>
								</button></td>
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			</div>
		</div>
		@endif
	</div>
</div>


<div class="modal fade" id="intro_modal" role="dialog">
	
	<div class="modal-dialog">
		<!-- Modal content-->
		<div class="modal-content">
			<form action="{{'update_userteam'}}" class="cmxform form-horizontal" enctype="multipart/form-data" method="post">
				{{ csrf_field() }}
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
					<h4 class="modal-title" id="intro_modallabel">CHANGE USER PARENT DETAILS</h4> 
				</div>
				<div class="modal-body">
					
					<div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="form-group">
                            <label class="control-label"> ENTER MOBILE NO </label>  
                            <input id="txt_intromobileno" name="txt_intromobileno" type="text" class="typeahead form-control" required="required" autofocus onBlur="get_member_nameintro()" readonly="true">
                            <span id="divtxt_intromobileno" style="color:red;"></span> 
						</div>     
					</div>
                    <div class="col-md-12 col-sm-12 col-xs-12" >
						<div class="form-group">
							<label class="control-label">USER NAME :- <span id="user_nameintro"></span></label>
						</div>
					</div>
                    <div class="col-md-12 col-sm-12 col-xs-12" >
						<div class="form-group">
							<label class="control-label">USER CURRENT PARENT :- <span id="user_introducer"></span></label>                      
						</div>
					</div>
                    <div class="col-md-12 col-sm-12 col-xs-12" >
						<div class="form-group">
							<label class="control-label">ENTER NEW PARENT</label>  
							<input id="txt_newintro" name="txt_newintro" type="text"  class="form-control" required="required">
							<input id="txt_oldintro" name="txt_oldintro" type="hidden"  class="form-control" required="required">
                            <span id="divtxt_newintro" style="color:red;"></span>
						</div>
					</div>
					
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal" onclick="javascript:window.location.reload()">CLOSE</button>
					<button type="submit" class="btn btn-primary">SUBMIT</button>
				</div>
			</form>
		</div>
		<script type="text/javascript">
			var route = "{{ url('autocomplete') }}";
			$('#txt_intromobileno').typeahead({
				source:  function (term, process) {
					return $.get(route, { term: term }, function (data) {
						//alert('hello');
						console.log(process(data));
						return process(data);
					});
				}
			});
		</script>
		
		<script type="text/javascript">
			get_member_nameintro();
			function get_member_nameintro()
			{
				var user_contactno = $("input[name='txt_intromobileno']").val();
				user_contactno = user_contactno.split(' ');
				var txt_contactno=user_contactno[0];
				
				console.log(user_contactno);
				var csrf = $("input[name='csrf_token']").val();
				if($("#txt_intromobileno").val()!="" && txt_contactno.length==10)
				{
					$.ajax({	
						type:"POST",
						url:"{{ url('get_details')}}",
						dataType: 'json',
						data:{"txt_contactno":txt_contactno, _token: '{{csrf_token()}}'},
						beforeSend : function(){
							$('img.loader').show('fadein');
						},
						success:function(msg) 
						{
							console.log(msg);
							$('img.loader').hide('fadeout');
							$('#user_nameintro').html(msg[0].FirstName+' '+msg[0].LastName);
							$("#user_introducer").html(msg[0].ParentMobileNo);
							$("#txt_oldintro").val(msg[0].ParentMobileNo);
						}
					});
				}
			}
		</script>
		<script>
			$('.loader').hide();
			function get_img(obj)
			{
				$('#put_img').attr('src', '');
				var key = '{{ asset("/images/")}}/' + $(obj).data('img');
				$('#put_img').attr('src', key);
			}
			function get_user_details(obj,id)
			{
				
				$('#txt_intromobileno').val($(obj).data('mobileno') +" ["+$(obj).data('fname')+' '+$(obj).data('lname')+"]");
				
			} 
		</script>
	</div>
</div>

@endsection