@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Change Game Winning Number</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{ url('/admin_dashboard') }}">Member</a></li>
			<li class="active">Change Game Winning Number</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
	</div>
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
                        <h3 class="panel-title">Change Game Winning Number</h3>
					</div>
                    <div class="collapse in">	
					   @if(Session::has('message')) 
							<div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
								<h4 class="alert-heading">{{ Session::get('message') }}</h4>
								<button type="button" class="close" data-dismiss="alert" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
						@endif
						  <form action="{{ url('/update_game_winning_number') }}" id="login_password" method="post" accept-charset="utf-8">
                            {{ csrf_field() }}
                            @foreach($data as $value)
                                <input id="txt_live_gmae_id_{{$value->m81_id}}" name="txt_live_gmae_id_{{$value->m81_id}}" type="hidden" required value="{{$value->tr47_id}}" readonly>
                            <div class="panel-body form-horizontal form-padding">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label><strong>Game Name : - </strong> {{$value->m81_name}} </label>
                                        <label><strong>End Time : - </strong> {{date('h:i: A', strtotime($value->tr47_game_end_time))}} </label>
                                        <input type="number" name="txt_game_number_{{$value->m81_id}}" id="txt_game_number_{{$value->m81_id}}" class="form-control" placeholder="Enter New Password." value="{{old('txt_game_number_'.$value->m81_id)}}" required>
                                        <span class="text-danger">Enter Numer Min {{$value->m81_start_number}} Max {{$value->m81_end_number}}</span>
                                    </div>                                
                                </div>
                            </div>
                            @endforeach
                            <div class="panel-footer text-center">
                                <span class="text-danger">Enter the number in the box only if you want to change winning number otherwise don't enter number</span><br>
                                <button class="btn btn-success" type="button" onclick="conwv('login_password')">Change</button>
                            </div>
                        </form>
					</div>
				</div>
			</div>
		</div>
	</div>
    <!--===================================================-->
    <!--End page content-->
</div>
@endsection