@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Employee Details</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Employee</a></li>
        <li class="active">Employee Details</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">All Employee Details</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{url('/all_employee')}}" method="POST">
                        {{ csrf_field() }}
                            <div class="panel-body">

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtfromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="YYYY-mm-dd" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txttodate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="YYYY-mm-dd" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_empid">Employee Id</label>
                                        <input type="text" id="txt_empid" name="txt_empid" class="form-control" placeholder="Enter Employee Id." >
                                    </div>
                                </div>

                            
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="control-label">Employee Role</label>
                                    <select name="dd_role " data-live-search="true" data-width="100%" id="dd_role" class="form-control selectpicker">
                                        <option value="-1">Select</option>
                                        <option value="BACK_ADMIN">ADMIN</option>
                                        <option VALUE="SALES">SALES</option>
                                        <option value="SUPPORT">SUPPORT</option>
                                        <option VALUE="ACCOUNT">ACCOUNT</option>
                                        <option value="TECHNICAL">TECHNICAL</option>
                                        <option VALUE="EMPLOYEE">EMPLOYEE</option>
                                        <option VALUE="BACKOFFICE">BACKOFFICE</option>
                                    </select>
                                </div>
                            </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-primary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
  <div class="mb-10 text-right"><button id="demo-btn-addrow" class="btn btn-primary mr-5 "onclick="location.href = 'employee_reg';" ><i class="demo-pli-add"></i> Add Employee</button><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('all_user');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>EMPLOYEE NAME</th>
								<th>EMPLOYEE ID</th>
								<th>CONTACTNO</th>
								<th>SPONSOR ID</th>
								<th>PARENT ID</th>
                                <th>EMPLOYEE ROLE</th>
								<th>POSITION</th>
								<th>JOINING DATE</th>	
								<th>STATUS</th>	
							</tr>
						</thead>
						<tbody>
							<?php $i=1; ?>
							@foreach( $user_report as $con)

							<tr>
								  <td>{{ $i++}}</td>
								<td>{{$con->MemberName}}</td>
								<td>{{$con->MemberCode}}</td>
								<td>{{ $con->MemberContactNo }}</td>
								<td>{{ $con->ReferralMobileNo }}</td>
								<td>{{ $con->ParentMobileNo }}</td>
                                <td>{{ $con->Role }}</td>
								<td>{{ $con->Position}}</td>
								<td>{{ $con->JOINING_DATE  }}</td>
								<td>{{ $con->MemberStatus }}</td>
								
                            </tr>


							 @endforeach
						</tbody>

					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection