@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Shopping Product</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Shopping Product</a></li>
        <li class="active">MARKET</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        

        <div class="row">
            
          <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">MARKET LISTING</h3>
                    </div>
                
                    <div class="collapse in">
                        <div class="panel-body">
                            <div class="text-right">
								<div class="form-group">
									<a class="btn btn-success pull-left" href="{{url('create_market')}}">Add Market</a><button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('market_listing');">Export To Excel</button>
								</div>
							</div>
                            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>S.No</th>
                                        <th>Market Name</th>
                                        <th>Market Address</th>
                                        <th>Market Phone</th>
                                        <th class="min-tablet">Market Closed/Not</th>
                                        <th class="min-tablet">Delivery Available/Not</th>
                                        <th class="min-tablet">Image</th>
                                        <th class="min-tablet">Created At</th>
                                        <th class="min-tablet">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i=1;?>
                                    @foreach($markets as $values)
                                    <tr>
                                        <td>{{$i++}}</td>
                                        <td>{{$values->MK_NAME}}</td>
                                        <td>{{$values->MK_ADDRESS}}</td>
                                        <td>{{$values->MK_PHONE}}</td>
                                        <td>{{$values->MK_CLOSED}}</td>
                                        <td>{{$values->MK_AVLDELIVERY}}</td>
                                        <td><img src="{{asset('/images/market_logo/'.$values->MK_IMAGE)}}" width="100"></td>
                                        <td>{{$values->MK_CREATED_AT}}</td>
                                        <td>
                                            <a class="btn btn-success btn-xs" href="{{url('edit_market/'.$values->MK_ID)}}">EDIT</a>
                                            <button data-id="{{$values->MK_ID}}" data-mkname="{{$values->MK_NAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$values->MK_STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                
    
            </div>

            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">

                        <form action="{{url('prod_status')}}" method="POST"> 
                            {{ csrf_field() }}

                            <!--Modal header-->
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                                <h4 class="modal-title">CHANGE PRODUCT STATUS</h4>
                            </div>

                            <!--Modal body-->
                            <div class="modal-body">
                                <div class="form-group">
                                    <input id="txt_prodid" name="txt_prodid" type="hidden" class="form-control" required="required">
                                </div>
                                <p class="text-semibold text-main">PRODUCT NAME :-<span id="prodname"></span></p>
                                <br>
                                <p class="text-semibold text-main">Would you like to change the status of product ?</p>

                            </div>

                            <!--Modal footer-->
                            <div class="modal-footer">
                                <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                                <button class="btn btn-primary" type="submit">Yes</button>
                            </div>

                        </form>
                        </div>
                    </div>
                </div>

        </div>    
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var prodname = $(this).data('prodname');
        $('#txt_prodid').val(id);
        $('#prodname').text(prodname);
    });
});
</script>
@endsection