@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Shopping Product</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Shopping Product</a></li>
        <li class="active">ORDERS</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
    </div><age content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">ALL ORDERS DETAILS</h3>
                </div>

                <div class="collapse in">
                @if(Session::has('message')) 
                <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                    <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif
                    <form action="{{url('/orders')}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">   

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="control-label" for="txt_fromdate">From Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="YYYY-mm-dd" autocomplete="off" >
                                    </div>
                                </div>                                
                            </div>
                        
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="control-label" for="txt_todate">To Date</label>
                                    <div id="demo-dp-txtinput">
                                        <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="YYYY-mm-dd" autocomplete="off" >
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="control-label" for="txt_memberid">Member ID</label>
                                    <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." autocomplete="off">
                                    <ul class="list-group costom-list" id="member_name"> </ul> 
                                </div>
                            </div>


                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="control-label" for="txt_orderid">Order ID</label>
                                    <input type="text" id="txt_orderid" name="txt_orderid" class="form-control" placeholder="Enter Order Id." autocomplete="off"> 
                                </div>
                            </div>
                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-primary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div>


        <div class="row">
          <div class="panel">
            <div class="panel-heading">
              <div class="panel-control">
                <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
              </div>
              <h3 class="panel-title">ORDERS LISTING</h3>
            </div>
            <div class="collapse in">
              <div class="panel-body">
                <div class="text-right">
                </div>
                <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th>S.No</th>
                      <th>User Code</th>
                      <th>User Name</th>
                      <th>Order Id</th>
                      <th>Address</th>
                      <th>Amount</th>
                      <th>Order Status</th>
                      <th>Payment Status</th>
                      <th>Payment Method</th>
                      <th>Shipment Id</th>
                      <th>Pickup Date</th>
                      <th>Order Return</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                  <?php $i=1;?>
                  @foreach($all_orders as $values)
                    <tr>
                      <td>{{$i++}}</td>
                      <td>{{$values->USER_CODE}}</td>
                      <td>{{$values->USER_NAME}}</td>
                      <td>{{$values->ORDER_CODE}}</td>
                      <td>{{$values->FLAT, $values->AREA, $values->LANDMARK, $values->PINCODE, $values->ADDRESS_TYPE}}</td>
                      <td>{{$values->FINAL_AMOUNT}}</td>
                      <td>{{$values->ORDER_STATUS}}</td>
                      <td>{{$values->PAYMENT_STATUS}}</td>
                      <td>{{$values->PAYMENT_METHOD}}</td>
                      <td>{{$values->SHIPMENT_Id}}</td>
                      <td>{{$values->PICKUP_SCHEDULED_DATE}}</td>
                      <td>{{$values->ORDER_RETURN}}</td>
                
                      <td>
                         <a class="btn btn-success btn-xs" href="{{url('view_send_order/'.$values->ORDER_CODE)}}"><i class="fa fa-truck" aria-hidden="true"></i></a>
                      </td>                      
                    </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>

        </div>  
    </div>
    <!--===================================================-->
    <!--End page content-->
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection