@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Send Order</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Order</a></li>
        <li class="active">Send Order</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		 <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class=" fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Ticket Reply Filter</h3>
                    </div>

                    <div class="collapse in">
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-1">
                                        @if(count( $ship) > 0)
                                            <input type="hidden" name="txt_shipment_id" id="txt_shipment_id" value="{{$ship[0]->SHIPMENT_Id}}">
                                            <button class="btn btn-success btn-sm" type="button">#{{$ship[0]->SHIPMENT_Id}} <i class="fa fa-check-circle" aria-hidden="true"></i></button>
                                        @else
                                            <button class="btn btn-warning btn-sm" type="button" onclick="conwv_order('{{$orderid}}')">Send Order <i class="fa fa-truck" aria-hidden="true"></i></button>
                                        @endif
                                    </form> 
                                    </div>    
                                    <div class="col-sm-1" style="text-align: center;"> 
                                        <i class="fa fa-arrow-right" aria-hidden="true" style="margin-top: 7px;"></i>
                                    </div>
                                    <div class="col-sm-4" style="text-align: center;">
                                        @if(count( $ship) > 0)
                                            @if($ship[0]->AWB_CODE == '')
                                           <div class="form-group" style="display: flex;">
                                                <select name="dd_couriers" id="dd_couriers" class="form-control empty selectpicker" data-live-search="true" data-width="100%">
                                                        <option value="">Select Couriers</option>
                                                    @foreach($couriers as $value)
                                                        <option value="{{$value->m80_courier_code}}">{{$value->m80_courier_name}}</option>
                                                    @endforeach
                                                </select>
                                                <button class="btn btn-warning btn-sm " style="margin-left: 10px;" type="button" @if(count( $ship) > 0) onclick="conwv_order_awb('{{$ship[0]->SHIPMENT_Id}}')"  @else disabled @endif > Generate Label <i class="fa fa-braille" aria-hidden="true"></i></button>
                                            </div>
                                            @else
                                                <button class="btn btn-success btn-sm" type="button">AWB : {{$ship[0]->AWB_CODE}} @if($ship[0]->COURIER_NAME == '') [Courier Company Code {{$ship[0]->COURIER_ID}} @else Courier Company  Name {{$ship[0]->COURIER_NAME}} @endif]</button>
                                            @endif
                                         @else
                                            <div class="form-group" style="display: flex;">
                                                <select name="dd_couriers" id="dd_couriers" class="form-control empty selectpicker" data-live-search="true" data-width="100%">
                                                        <option value="">Select Couriers</option>
                                                    @foreach($couriers as $value)
                                                        <option value="{{$value->m80_courier_code}}">{{$value->m80_courier_name}}</option>
                                                    @endforeach
                                                </select>
                                                <button class="btn btn-warning btn-sm " style="margin-left: 10px;" type="button" @if(count( $ship) > 0) onclick="conwv_order_awb('{{$orderid}}')"  @else disabled @endif > Generate Label <i class="fa fa-braille" aria-hidden="true"></i></button>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-sm-1" style="text-align: center;"> 
                                        <i class="fa fa-arrow-right" aria-hidden="true" style="margin-top: 7px;"></i> 
                                    </div>
                                    <div class="col-sm-2">
                                        @if(count( $ship) > 0)
                                            @if($ship[0]->PICKUP_SCHEDULED_DATE !='' && $ship[0]->PICKUP_GENERATED_DATE !='')
                                            <button class="btn btn-success btn-sm" type="button" >PICKUP DATE : {{$ship[0]->PICKUP_SCHEDULED_DATE}} <i class="fa fa-truck" aria-hidden="true"></i></button>
                                            @else
                                            <button class="btn btn-warning btn-sm" type="button" onclick="conwv_orderRequest('{{$orderid}}')">Shipment Request <i class="fa fa-truck" aria-hidden="true"></i></button>
                                            @endif
                                        @else
                                            <button class="btn btn-warning btn-sm" type="button">Send Order <i class="fa fa-truck" aria-hidden="true"></i></button>
                                        @endif
                                    </div>
                                    <div class="col-sm-1" style="text-align: center;"> 
                                        <i class="fa fa-arrow-right" aria-hidden="true" style="margin-top: 7px;"></i> 
                                    </div>
                                    <div class="col-sm-2">
                                        @if(count( $ship) > 0)
                                            @if($ship[0]->LABEL_URL !='' && $ship[0]->MANIFEST_URL !='')
                                            <button class="btn btn-success btn-sm" type="button" >shipment complete <i class="fa fa-truck" aria-hidden="true"></i></button>
                                            @else
                                            <button class="btn btn-warning btn-sm" type="button" onclick="conwv_ordermanifest('{{$orderid}}')">Shipment Request <i class="fa fa-truck" aria-hidden="true"></i></button>
                                            @endif
                                        @else
                                            <button class="btn btn-warning btn-sm" type="button">Send Order <i class="fa fa-truck" aria-hidden="true"></i></button>
                                        @endif
                                    </div> 
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                @if(count( $ship) > 0)
                                    @if($ship[0]->LABEL_URL !='' && $ship[0]->ORDER_RETURN == 'NO')
                                        <button class="btn btn-danger" type="button"  onclick="conwv_order_cancel('{{$orderid}}')">Order Cancel</button>
                                    @else
                                        <button class="btn btn-danger" type="button" >Order Canceled successfully</button>
                                    @endif
                                @endif
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>
        <div class="row">
            <div class="panel">
                    @if(session('success'))
                  <div class="alert alert-success">
                        <button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
                        <i class="fa fa-smile-o fa-2" aria-hidden="true"> </i><strong> {{ session('success') }}</strong>
                    </div>
                @elseif(session('error'))
                    <div class="alert alert-danger">
                        <button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
                        <i class="fa fa-exclamation-triangle" aria-hidden="true"></i> <strong> {{ session('error') }}</strong>
                    </div>
                @endif
            
                <div class="panel-body">
<div class="mb-10 pull-left"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('ticket_reply');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>Order No.</th>
                                <th class="min-tablet">Shipment Id </th>
								<th class="min-tablet">Order Id</th>
                                <th class="min-tablet">AWB Code</th>
                                <th class="min-tablet">Courier Company  Name/Id</th>
                                <th class="min-tablet">Pickup Date</th>
                                <th class="min-tablet">Pickup</th>
								<th class="min-tablet">Manifest Url</th>
                                <th class="min-tablet">Label Url</th>
                                <th class="min-tablet">Invoice Url</th>
                                <th class="min-tablet">Torder Return</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($ship) > 0)
                            <tr>
                                <td>{{$ship[0]->CART_CODE}}</td>
                                <td class="min-tablet">{{$ship[0]->SHIPMENT_Id}} </td>
                                <td class="min-tablet">{{$ship[0]->ORDER_ID}} </td>
                                <td class="min-tablet">{{$ship[0]->AWB_CODE}} </td>
                                <td class="min-tablet">{{$ship[0]->COURIER_NAME}}/{{$ship[0]->COURIER_ID}}</td>
                                <td class="min-tablet">{{$ship[0]->PICKUP_SCHEDULED_DATE}} </td>
                                <td class="min-tablet">{{$ship[0]->PICKUP_DATA}} </td>
                                <td class="min-tablet"><a class="btn btn-warning btn-sm"  href="{{$ship[0]->MANIFEST_URL}}"><i class="fa fa-download" aria-hidden="true"></i></a> </td>
                                <td class="min-tablet"><a class="btn btn-warning btn-sm"  href="{{$ship[0]->LABEL_URL}}"><i class="fa fa-download" aria-hidden="true"></i></a> </td>
                                <td class="min-tablet"><a class="btn btn-warning btn-sm"  href="{{$ship[0]->INVOICE_URL}}"><i class="fa fa-download" aria-hidden="true"></i></a> </td>
                                <td class="min-tablet">{{$ship[0]->ORDER_RETURN}} </td>
            
                            </tr>
                            @endif
                           
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        </div>

            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>


<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">  

    function conwv_order(get_id)
    {
        bootbox.confirm('Are you sure you want send this order?', function(result){
            if((result==true))
            {
                $.ajax({
                   type:"POST",
                   url:"{{ url('/order_send') }}",
                   data:{"_token": "{{ csrf_token() }}", "txt_orderid": get_id},
                   success:function(result)
                    {
                        if(result['type'] == 'success')
                        {
                            location.reload();
                        }
                        else
                        {
                            bootbox.alert(result['message']);
                        }
                    }
                });
            }
        }); 
    }


    function conwv_order_awb(get_id)
    {           

        var txt_shipment_id = $('#txt_shipment_id').val();

        if(get_id == '')
        {
            bootbox.alert("Please Select Couriers");
        }
        if(txt_shipment_id == '')
        {
            bootbox.alert("shipment id not found");
        }
        else
        {
            var dd_couriers = $("#dd_couriers").selectpicker().val();

            bootbox.confirm('Are you sure you want send this order?', function(result){
                if((result==true))
                {
                    $.ajax({
                       type:"POST",
                       url:"{{ url('/assign_awb') }}",
                       data:{"_token": "{{ csrf_token() }}", "txt_orderid": get_id, "dd_couriers":dd_couriers, "shipment_id":txt_shipment_id},
                       success:function(result)
                        {
                            if(result['type'] == 'success')
                            {
                                location.reload();
                            }
                            else
                            {
                                bootbox.alert(result['message']);
                            }
                            //location.reload();
                        }
                    });
                }
            }); 
        }
    }


    function conwv_orderRequest(get_id)
    {
        var txt_shipment_id = $('#txt_shipment_id').val();

        if(get_id == '')
        {
            bootbox.alert("Please Select Couriers");
        }
        if(txt_shipment_id == '')
        {
            bootbox.alert("shipment id not found");
        }
        else
        {
            bootbox.confirm('Are you sure you want send this order?', function(result){
                if((result==true))
                {
                    $.ajax({
                       type:"POST",
                       url:"{{ url('/shipmentpickuprequest') }}",
                       data:{"_token": "{{ csrf_token() }}", "txt_orderid": get_id, "shipment_id":txt_shipment_id},
                       success:function(result)
                        {
                            if(result['type'] == 'success')
                            {
                                location.reload();
                            }
                            else
                            {
                                bootbox.alert(result['message']);
                            }
                        }
                    });
                }
            }); 
        }
    }


    function conwv_ordermanifest(get_id)
    {
        var txt_shipment_id = $('#txt_shipment_id').val();

        if(get_id == '')
        {
            bootbox.alert("Please Select Couriers");
        }
        if(txt_shipment_id == '')
        {
            bootbox.alert("shipment id not found");
        }
        else
        {
            bootbox.confirm('Are you sure you want send this order?', function(result){
                if((result==true))
                {
                    $.ajax({
                       type:"POST",
                       url:"{{ url('/generate_invoice') }}",
                       data:{"_token": "{{ csrf_token() }}", "txt_orderid": get_id, "shipment_id":txt_shipment_id},
                       success:function(result)
                        {
                            if(result['type'] == 'success')
                            {
                                location.reload();
                            }
                            else
                            {
                                bootbox.alert(result['message']);
                            }
                        }
                    });
                }
            }); 
        }
    }


    function conwv_order_cancel(get_id)
    {
        var txt_shipment_id = $('#txt_shipment_id').val();

        if(get_id == '')
        {
            bootbox.alert("Please Select Couriers");
        }
        if(txt_shipment_id == '')
        {
            bootbox.alert("shipment id not found");
        }
        else
        {
            bootbox.confirm('Are you sure you want Order Cancel?', function(result){
                if((result==true))
                {
                    $.ajax({
                       type:"POST",
                       url:"{{ url('/order_cancel') }}",
                       data:{"_token": "{{ csrf_token() }}", "txt_orderid": get_id, "shipment_id":txt_shipment_id},
                       success:function(result)
                        {
                            if(result['type'] == 'success')
                            {
                                location.reload();
                            }
                            else
                            {
                                bootbox.alert(result['message']);
                            }
                        }
                    });
                }
            }); 
        }
    }

    
</script>
<script type="text/javascript">
  function assign_ticket(id){
	var empid = $('#'+id).val();
		var tick_id = id;
		if (confirm("You want to Assigned Ticket This User ?")) {
			$.ajax({
			   type:"POST",
			   url:"{{ url('/assigned_ticket') }}",
			   data:{"_token": "{{ csrf_token() }}", "empid": empid, "tick_id":tick_id},
			   success:function(result)
				{
					location.reload();
				}
			});
		}	
        }
</script>
@endsection