@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">PRODUCT VARIANTS</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        @if(Session::has('uproduct_msg')) 
          <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
              <h4 class="alert-heading">{{ Session::get("uproduct_msg") }}</h4>
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
              </button>
          </div>
        @endif

        <div class="row">
            
          <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">PRODUCTS VARIANTS</h3>
                    </div>
                
                    <div class="collapse in">
                        <div class="panel-body">
                            <div class="text-right">
                                <div class="form-group">
                                    <a class="btn btn-success" href="{{url('create_variant')}}">Add Product Variant</a>
                                </div>
                                <div class="form-group">
                                    <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('Variant_listing');">Export To Excel</button>
                                </div>
                            </div>
                            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>S.No</th>
                                        <th class="min-tablet">Product Name</th>
                                        <th>SKU Id</th>
                                        <th class="min-tablet">Price</th>
                                        <th class="min-tablet">Discount Price</th>
                                        <th class="min-tablet">Unit</th>
                                        <th class="min-tablet">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                  <?php $i=1;?>
                                  @foreach($product_variants as $values)
                                    <tr>
                                        <td>{{$i++}}</td>
                                        <td>{{$values->PROD_NAME}}</td>
                                        <td>{{$values->VARNT_SKU}}</td>
                                        <td>{{$values->VARNT_PRICE}}</td>
                                        <td>{{$values->VARNT_DISCPRICE}}</td>
                                        <td>{{$values->UNIT_NAME}}</td>
                                        <td>
                                            <a class="btn btn-success btn-xs" href="{{url('view_variant/'.$values->VARNT_ID)}}">EDIT</a>
                                            <button data-id="{{$values->VARNT_ID}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$values->VARNT_STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                
    
            </div>

            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">

                        <form action="{{url('variant_status')}}" method="POST"> 
                            {{ csrf_field() }}

                            <!--Modal header-->
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                                <h4 class="modal-title">CHANGE PRODUCT VARIANT STATUS</h4>
                            </div>

                            <!--Modal body-->
                            <div class="modal-body">
                                <div class="form-group">
                                    <input id="txt_prodid" name="txt_prodid" type="hidden" class="form-control" required="required">
                                </div>
                                <p class="text-semibold text-main">PRODUCT NAME :-<span id="prodname"></span></p>
                                <br>
                                <p class="text-semibold text-main">Would you like to change the status of product ?</p>

                            </div>

                            <!--Modal footer-->
                            <div class="modal-footer">
                                <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                                <button class="btn btn-primary" type="submit">Yes</button>
                            </div>

                        </form>
                        </div>
                    </div>
                </div>

        </div>    
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>

<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var prodname = $(this).data('prodname');
        $('#txt_prodid').val(id);
        $('#prodname').text(prodname);
    });
});
</script>
@endsection
