@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">PRODUCT</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
    </div>age content-->
    <!--===================================================-->
    <div id="page-content">

		@if(Session::has('uproduct_msg')) 
          <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
              <h4 class="alert-heading">{{ Session::get("uproduct_msg") }}</h4>
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
              </button>
          </div>
        @endif

        <div class="row">
          <div class="panel">
            <div class="panel-heading">
              <div class="panel-control">
                <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
              </div>
              <h3 class="panel-title">PRODUCTS LISTING</h3>
            </div>
            <div class="collapse in">
              <div class="panel-body">
                <div class="text-right">
                  <div class="form-group">
                    <a class="btn btn-success pull-left" href="{{url('create_prod')}}">Add Product</a><button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('Category_listing');">Export To Excel</button>
                  </div>
                </div>
                <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th>S.No</th>
                      <th>Product Name</th>
                      <th>SKU Id</th>
                      <th>Brand Name</th>
                      <th>Market Name</th>
                      <th>Category Name</th>
                      <th>QR Code</th>
                      <th>Group Name</th>
                      <th>Price</th>
                      <th>Discount Price</th>
                      <th>Unit</th>
                      <th>Capacity</th>
                      <th>Is Featured</th>
                      <th>Is Deliverable</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                  <?php $i=1;?>
                  @foreach($products as $values)
                    <tr>
                      <td>{{$i++}}</td>
                      <td>{{$values->PROD_NAME}}</td>
                      <td>{{$values->PROD_SKU}}</td>
                      <td>{{$values->PROD_BRAND_NAME}}</td>
                      <td>{{$values->MARKET_NAME}}</td>
                      <td>{{$values->CAT_NAME}}</td>
                      <td><img src="{{asset('/qrcodes/'.$values->PROD_QRCODE)}}" width="100"></td>
                      <td>{{$values->GROUP_NAME}}</td>
                      <td>{{$values->PROD_PRICE}}</td>
                      <td>{{$values->PROD_DISCPRICE}}</td>
                      <td>{{$values->UNIT_NAME}}</td>
                      <td>{{$values->PROD_CAPACITY}}</td>
                      <td>{{$values->PROD_FEATURED}}</td>
                      <td>{{$values->PROD_DELIV}}</td>
                      <td><a class="btn btn-success btn-xs" href="{{url('view_prod/'.$values->PROD_ID)}}" target="_blank">EDIT</a><button data-id="{{$values->PROD_ID}}" data-prodname="{{$values->PROD_NAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$values->STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button></td>
                    </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                <form action="{{url('prod_status')}}" method="POST"> 
                {{ csrf_field() }}
                <!--Modal header-->
                  <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                    <h4 class="modal-title">CHANGE PRODUCT STATUS</h4>
                  </div>
                  <!--Modal body-->
                  <div class="modal-body">
                    <div class="form-group">
                      <input id="txt_prodid" name="txt_prodid" type="hidden" class="form-control" required="required">
                    </div>
                    <p class="text-semibold text-main">PRODUCT NAME :-<span id="prodname"></span></p>
                    <br>
                    <p class="text-semibold text-main">Would you like to change the status of product ?</p>
                  </div>
                  <!--Modal footer-->
                  <div class="modal-footer">
                    <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                    <button class="btn btn-primary" type="submit">Yes</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>  
    </div>
    <!--===================================================-->
    <!--End page content-->
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var prodname = $(this).data('prodname');
        $('#txt_prodid').val(id);
        $('#prodname').text(prodname);
    });
});
</script>
@endsection