@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Shopping Product</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Shopping Product</a></li>
        <li class="active">PARENT CATEGORY</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                  @if ($errors->any())
                  <div class="alert alert-danger">
                      <ul>
                          @foreach ($errors->all() as $error)
                              <li>{{ $error }}</li>
                          @endforeach
                      </ul>
                  </div>
                  @endif

                  @if(Session::has('pcat_msg')) 
                  <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                      <h4 class="alert-heading">{{ Session::get("pcat_msg") }}</h4>
                      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  @endif

                  
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">PARENT CATEGORY</h3>
                    </div>

                    <div class="collapse in">
                        @if(!isset($single_parentcat[0]->CAT_ID))
                        <form class="form-horizontal" enctype="multipart/form-data" action="{{url('/add_parentcat')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Category Name</label>
                                            <input type="text" id="txt_catname" name="txt_catname" class="form-control" placeholder="Enter Category Name.">

                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-labels-12">Description</label>
                                            <textarea id="txt_desc" name="txt_desc" class="form-control" placeholder="Enter Description."></textarea>                                        
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Image</label>
                                            <input type="file" id="txt_image" name="txt_image" class="form-control" placeholder="Enter Category Image.">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-labe col-md-4 col-sm-4 col-xs-12">Status</label>
                                            <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_status" id="dd_status">
                                                <option value="-1">Select Status</option>
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select>
                                        </div>
                                    </div>      

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button type="submit" class="btn btn-success">Save</button>
                                <button class="btn btn-primary" type="reset">Reset</button>                           
                            </div>
                        </form>
                        @elseif(isset($single_parentcat[0]->CAT_ID))
                        <form class="form-horizontal" enctype="multipart/form-data" action="{{url('/update_parentcat/'.$single_parentcat[0]->CAT_ID)}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Category Name</label>
                                            <input type="text" id="txt_catname" name="txt_catname" class="form-control" value="{{$single_parentcat[0]->CAT_NAME}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Description</label>
                                            <textarea id="txt_desc" name="txt_desc" class="form-control">{{$single_parentcat[0]->CAT_DESC}}</textarea>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Image</label>
                                            <img src="{{asset('/images/parentcat_logo/'.$single_parentcat[0]->CAT_IMG)}}" alt="" height="50" width="50">
                                            <input type="file" id="txt_image" name="txt_image" class="form-control" placeholder="Enter Category Image.">
                                            <input type="hidden" id="txt_oldimage" name="txt_oldimage" class="form-control" value="{{$single_parentcat[0]->CAT_IMG}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Status</label>
                                            <select class="form-control" name="dd_status" id="dd_status">
                                                <option value="-1">Select Status</option>
                                                <option value="1" {{$single_parentcat[0]->CAT_STATUS == 'ACTIVE' ? 'selected' : ''}} >Active</option>
                                                <option value="2" {{$single_parentcat[0]->CAT_STATUS == 'INACTIVE' ? 'selected' : ''}} >InActive</option>
                                            </select>
                                        </div>
                                    </div>                  

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button type="submit" class="btn btn-success">Save</button>
                                <button class="btn btn-primary" type="reset">Reset</button>                           
                            </div>
                        </form>
                        @endif
                    </div>
        
                </div>

            </div>    
            
            <div class="col-md-8">
                <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">CATEGORY LISTING</h3>
                    </div>
                
                    <div class="collapse in">
                        <div class="panel-body">
                            <div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('ledger-report');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                                    
                            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                      <th>S.No</th>
                                        <th>Category Name</th>
                                        <th class="min-tablet">Description</th>
                                        <th class="min-tablet">Image</th>
                                        <th class="min-tablet">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                  <?php $i=1;?>
                                    @foreach($all_parentcat as $value)
                                    <tr>
                                        <td>{{$i++}}</td>
                                        <td>{{$value->CAT_NAME}}</td>
                                        <td>{{$value->CAT_DESC}}</td>
                                        <td><img class=" rounded " style="width:50px" src="{{asset('/images/parentcat_logo/'.$value->CAT_IMG)}}" alt=""></td>
                                        <td>
                                            <a class="btn btn-success btn-xs" href="{{url('edit_parentcat/'.$value->CAT_ID)}}">EDIT</a>
                                            <button data-id="{{$value->CAT_ID}}" data-catname="{{$value->CAT_NAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$value->CAT_STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
                                        </td>
                                    </tr>
                                    @endforeach
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                
                </div>

                <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">

                        <form action="{{url('cat_status')}}" method="POST"> 
                            {{ csrf_field() }}

                            <!--Modal header-->
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                                <h4 class="modal-title">CHANGE CATEGORY STATUS</h4>
                            </div>

                            <!--Modal body-->
                            <div class="modal-body">
                                <div class="form-group">
                                    <input id="txt_catid" name="txt_catid" type="hidden" class="form-control" required="required">
                                </div>
                                <p class="text-semibold text-main">CATEGORY NAME :-<span id="catname"></span></p>
                                <br>
                                <p class="text-semibold text-main">Would you like to change the status of category ?</p>

                            </div>

                            <!--Modal footer-->
                            <div class="modal-footer">
                                <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                                <button class="btn btn-primary" type="submit">Yes</button>
                            </div>

                        </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var catname = $(this).data('catname');
        $('#txt_catid').val(id);
        $('#catname').text(catname);
    });
});
</script>
@endsection
