@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Shopping Product</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Shopping Product</a></li>
        <li class="active">VARIATION TYPE</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        

        <div class="row">
            <div class="col-md-4">
              
                <div class="panel">

                  @if ($errors->any())
                  <div class="alert alert-danger">
                      <ul>
                          @foreach ($errors->all() as $error)
                              <li>{{ $error }}</li>
                          @endforeach
                      </ul>
                  </div>
                  @endif

                  @if(Session::has('grp_msg')) 
                  <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                      <h4 class="alert-heading">{{ Session::get("grp_msg") }}</h4>
                      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  @endif

                  
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">VARIATION TYPE</h3>
                    </div>

                    <div class="collapse in">
                        @if(!isset($single_option[0]->OPTIONGR_ID))
                        <form class="form-horizontal" enctype="multipart/form-data" action="{{url('/create_option')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Variation Name</label>
                                            <input type="text" id="txt_grname" name="txt_grname" class="form-control" placeholder="Enter Group Name.">
                                        </div>
                                    </div>                         

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button type="submit" class="btn btn-success">Save</button>
                                <button class="btn btn-primary" type="reset">Reset</button>                           
                            </div>
                        </form>
                        @elseif(isset($single_option[0]->OPTIONGR_ID))
                        <form class="form-horizontal" enctype="multipart/form-data" action="{{url('/update_option/'.$single_option[0]->OPTIONGR_ID)}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Variation Name</label>
                                            <input type="text" id="txt_grname" name="txt_grname" class="form-control" value="{{$single_option[0]->OPTIONGR_NAME}}">
                                        </div>
                                    </div>                         

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button type="submit" class="btn btn-success">Save</button>
                                <button class="btn btn-primary" type="reset">Reset</button>                           
                            </div>
                        </form>
                        @endif

                    </div>
        
                </div>

            </div>    
            
          <div class="col-md-8">
              <div class="panel">
                  <div class="panel-heading">
                      <div class="panel-control">
                          <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                      </div>
                      <h3 class="panel-title">OPTION LISTING</h3>
                  </div>
              
                  <div class="collapse in">
                      <div class="panel-body">
                          <div class="text-right">
                              <div class="form-group">
                                  <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('Option_listing');">Export To Excel</button>
                              </div>
                          </div>
                          <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                              <thead>
                                  <tr>
                                      <th>S.No</th>
                                      <th>Option Name</th>
                                      <th class="min-tablet">Action</th>
                                  </tr>
                              </thead>
                              <tbody>
                                    <?php $i=1;?>
                                    @foreach($options as $value)
                                    <tr>
                                        <td>{{$i++}}</td>
                                        <td>{{$value->OPTIONGR_NAME}}</td>
                                        <td>
                                            <a class="btn btn-success btn-xs" href="{{url('view_option/'.$value->OPTIONGR_ID)}}">EDIT</a>
                                            <button data-id="{{$value->OPTIONGR_ID}}" data-optname="{{$value->OPTIONGR_NAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$value->OP_STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
                                        </td>
                                    </tr>
                                    @endforeach
                                  
                              </tbody>
                          </table>
                      </div>
                  </div>
              
              </div>

              <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">

                        <form action="{{url('option_status')}}" method="POST"> 
                            {{ csrf_field() }}

                            <!--Modal header-->
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                                <h4 class="modal-title">CHANGE OPTION STATUS</h4>
                            </div>

                            <!--Modal body-->
                            <div class="modal-body">
                                <div class="form-group">
                                    <input id="txt_optid" name="txt_optid" type="hidden" class="form-control" required="required">
                                </div>
                                <p class="text-semibold text-main">OPTION NAME :-<span id="optname"></span></p>
                                <br>
                                <p class="text-semibold text-main">Would you like to change the status of option ?</p>

                            </div>

                            <!--Modal footer-->
                            <div class="modal-footer">
                                <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                                <button class="btn btn-primary" type="submit">Yes</button>
                            </div>

                        </form>
                        </div>
                    </div>
                </div>
          </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->


<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var optname = $(this).data('optname');
        $('#txt_optid').val(id);
        $('#optname').text(optname);
    });
});
</script>
@endsection