@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">Edit Market</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        

        <div class="row">
            
            <div class="panel">

              @if ($errors->any())
              <div class="alert alert-danger">
                  <ul>
                      @foreach ($errors->all() as $error)
                          <li>{{ $error }}</li>
                      @endforeach
                  </ul>
              </div>
              @endif

              @if(Session::has('umarket_msg')) 
              <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                  <h4 class="alert-heading">{{ Session::get("umarket_msg") }}</h4>
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                  </button>
              </div>
              @endif

              
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">EDIT MARKET</h3>
                </div>

                <div class="collapse in">
                    
                    <form class="form-horizontal" enctype="multipart/form-data" action="{{url('/update_market/'.$markets[0]->MK_ID)}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">
                            <div class="row">
                                
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Market Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_mkname" name="txt_mkname" class="form-control" value="{{$markets[0]->MK_NAME}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Image</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="file" id="txt_image" name="txt_image" class="form-control">
                                        <input type="hidden" id="txt_oldimage" name="txt_oldimage" class="form-control" value="{{$markets[0]->MK_IMAGE}}">
                                      </div>
                                    </div>
                                </div>

								                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Mobile No.</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="number" id="txt_mobile" name="txt_mobile" class="form-control" value="{{$markets[0]->MK_PHONE}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Address</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea class="form-control" id="txt_address" name="txt_address" placeholder="Enter Addess.">{{$markets[0]->MK_ADDRESS}}</textarea>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Latitude</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_lat" name="txt_lat" class="form-control" placeholder="Enter Latitude." value="{{$markets[0]->MK_LAT}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Longitude</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_long" name="txt_long" class="form-control" placeholder="Enter Longitude." value="{{$markets[0]->MK_LONG}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Description</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea class="form-control" id="txt_desc" name="txt_desc" placeholder="Enter Description.">{{$markets[0]->MK_DESC}}</textarea>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Closed</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                          <input id="rb_featured" class="magic-radio" type="radio" name="rb_mktclosed" value="1" {{$markets[0]->MK_CLOSED == 1 ? 'checked' : '' }} required>
                                          <label for="rb_featured">IS CLOSED</label>
                                          <input id="rb_featured_not" class="magic-radio" type="radio" name="rb_mktclosed" value="2" {{$markets[0]->MK_CLOSED == 2 ? 'checked' : '' }}>
                                          <label for="rb_featured_not">IS OPENED</label>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Deliverable</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                          <input id="rb_deliverable" class="magic-radio" type="radio" name="rb_deliverable" value="1" {{$markets[0]->MK_AVLDELIVERY == 1 ? 'checked' : '' }} required>
                                          <label for="rb_deliverable">DELIVERABLE</label>
                                          <input id="rb_deliverable_not" class="magic-radio" type="radio" name="rb_deliverable" value="2" {{$markets[0]->MK_AVLDELIVERY == 2 ? 'checked' : '' }}>
                                          <label for="rb_deliverable_not">NOT DELIVERABLE</label>
                                      </div>
                                    </div>
                                </div>
                                      
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Status</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control selectpicker" data-live-search="true" data-width="100%"name="dd_status" id="dd_status">
                                            <option value="-1">Select Status</option>
                                            <option value="1" {{$markets[0]->MK_STATUS == 1 ? 'selected' : '' }}>Active</option>
                                            <option value="2" {{$markets[0]->MK_STATUS == 2 ? 'selected' : '' }}>InActive</option>
                                        </select>
                                      </div>
                                    </div>
                                </div>           

                            </div>
                        </div>
                        <div class="panel-footer text-center">
                            <button type="submit" class="btn btn-success">Save</button>
                            <button class="btn btn-primary" type="reset">Reset</button>                           
                        </div>
                    </form>

                </div>
    
            </div>

        </div>    
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection