@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Service Details</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('service_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("service_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Service Details</h3>
                    </div>

                    <div class="collapse in">
                        @if(!isset($single_services[0]->SR_TYPEID))
                        <form id="add-service" action="{{url('create_service')}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_servicename">Service Name</label>
                                            <input type="text" name="txt_servicename" id="txt_servicename" class="form-control">
                                        </div>
                                    </div>
									<div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_servicetype">Service Type</label>
                                            <select class="form-control" name="dd_servicetype" id="dd_servicetype" required>
                                                <option value="-1">Select</option>
                                                <option value="1">PREPAID</option>
                                                <option value="2">UTILITY</option>
                                                <option value="3">MONEY TRANSFER</option>
                                                <option value="4">AEPS</option>
                                                <option value="5">PANTOKEN</option>
                                                <option value="6">TRAVEL</option>
                                                <option value="7">INSURANCE</option>
                                                <option value="8">BBPS</option>
                                            </select>  
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_bal_type">Balance Type</label>
                                            <select class="form-control" name="dd_bal_type" id="dd_bal_type" required>
                                                <option value="-1">Select </option>
                                                <option value="1">MAIN</option>
                                                <option value="2">DMR</option>
                                                <option value="3">AEPS</option>
                                            </select>  
                                        </div>
                                    </div>                              
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_servicename">URL</label>
                                            <input type="url" name="txt_url" id="txt_url" class="form-control">
                                        </div>
                                    </div>   
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description</label>
                                            <textarea type="text" name="txt_desc" id="txt_desc" class="form-control" placeholder="Enter Description" required=""></textarea>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_service_surcharge">Service Surcharge</label>
                                            <input type="number" name="txt_service_surcharge" id="txt_service_surcharge" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_service_image">Service Icon</label>
                                            <input type="file" name="txt_service_image" id="txt_service_image" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Status</label>
                                            <select class="form-control" name="dd_status" id="dd_status" required>
                                                <option value="-1">Select</option>
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select>  
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add-service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @elseif(isset($single_services[0]->SR_TYPEID))
                        <form id="edit-service" action="{{url('update_service/'.$single_services[0]->SR_TYPEID)}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_servicename">Service Name</label>
                                            <input type="text" name="txt_servicename" id="txt_servicename" class="form-control" value="{{$single_services[0]->SR_NAME}}">
                                        </div>
                                    </div>
									<div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_servicetype">Service Type</label>
                                            <select class="form-control" name="dd_servicetype" id="dd_servicetype" required>
                                                <option value="-1">Select</option>
                                                <option value="1" {{$single_services[0]->SR_TYPE == 'PREPAID' ? 'selected' : ''}}>PREPAID</option>
                                                <option value="2" {{$single_services[0]->SR_TYPE == 'UTILITY' ? 'selected' : ''}}>UTILITY</option>
                                                <option value="3" {{$single_services[0]->SR_TYPE == 'MONEY TRANSFER' ? 'selected' : ''}}>MONEY TRANSFER</option>
                                                <option value="4" {{$single_services[0]->SR_TYPE == 'AEPS' ? 'selected' : ''}}>AEPS</option>
                                                <option value="5" {{$single_services[0]->SR_TYPE == 'PANTOKEN' ? 'selected' : ''}}>PANTOKEN</option>
                                                <option value="6" {{$single_services[0]->SR_TYPE == 'TRAVEL' ? 'selected' : ''}}>TRAVEL</option>
                                                <option value="7" {{$single_services[0]->SR_TYPE == 'INSURANCE' ? 'selected' : ''}}>INSURANCE</option>
                                                <option value="8" {{$single_services[0]->SR_TYPE == 'BBPS' ? 'selected' : ''}}>BBPS</option>
                                            </select>  
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_bal_type">Balance Type</label>
                                            <select class="form-control" name="dd_bal_type" id="dd_bal_type" required>
                                                <option value="-1">Select </option>
                                                <option value="1" {{$single_services[0]->SR_BAL_TYPE == 'MAIN' ? 'selected' : ''}}>MAIN</option>
                                                <option value="2" {{$single_services[0]->SR_BAL_TYPE == 'DMR' ? 'selected' : ''}}>DMR</option>
                                                <option value="3" {{$single_services[0]->SR_BAL_TYPE == 'AEPS' ? 'selected' : ''}}>AEPS</option>
                                            </select>  
                                        </div>
                                    </div>                              
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_servicename">URL</label>
                                            <input type="url" name="txt_url" id="txt_url" class="form-control" value="{{$single_services[0]->SR_URL}}">
                                        </div>
                                    </div>  
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description</label>
                                            <textarea type="text" name="txt_desc" id="txt_desc" class="form-control" placeholder="Enter Description" required=""> {{$single_services[0]->SR_DESC}}</textarea>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_service_surcharge">Service Surcharge</label>
                                            <input type="number" name="txt_service_surcharge" id="txt_service_surcharge" class="form-control" value="{{$single_services[0]->SR_SURCHARGE}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <img src="{{asset('/images/service_image/'.$single_services[0]->SR_IMG)}}" height="50" width="50">
                                            <label class="control-label" for="txt_service_image">Service Icon</label>
                                            <input type="file" name="txt_service_image" id="txt_service_image" class="form-control">
                                            <input type="hidden" name="txt_sr_oldimage" id="txt_sr_oldimage" class="form-control" value="{{$single_services[0]->SR_IMG}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Status</label>
                                            <select class="form-control" name="dd_status" id="dd_status" required>
                                                <option value="-1">Select</option>
                                                <option value="1" {{$single_services[0]->SR_STATUS == 'Active' ? 'selected' : ''}}>Active</option>
                                                <option value="2" {{$single_services[0]->SR_STATUS == 'InActive' ? 'selected' : ''}}>InActive</option>
                                            </select>  
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit-service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>
            </div>

            <div class="col-md-8">
                <div class="panel">
                
                    <div class="panel-body">
                        <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>Service Name</th>
                                    <th class="min-tablet">Description</th>
                                    <th class="min-tablet">Icon</th>
                                    <th class="min-tablet">Service Surcharge</th>
                                    <th class="min-tablet">Edit</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $i=1;?>
                             @foreach($services as $sr)

                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{$sr->SR_NAME}}</td>
                                    <td>{{$sr->SR_DESC}}</td>
                                    <td><img src="{{asset('/images/service_image/'.$sr->SR_IMG)}}" height="50" width="50"></td>
                                    <td>{{$sr->SR_SURCHARGE}}</td>
                                    <td><a class="btn btn-success btn-xs" href="{{url('edit_service/'.$sr->SR_TYPEID)}}">Edit</a></td>
                                </tr>
                             @endforeach
                                
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>

        </div> 
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection