@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">View News</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="col-md-4">
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('message_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">View News</h3>
                    </div>

                    <div class="collapse in">
        
                        @if(isset($singlenews[0]->NewsId))
                        <form id="edit-news" action="{{ url('/update_news_detail/'.$singlenews[0]->NewsId) }}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_title">Title</label>
                                            <input type="text" name="txt_title" id="txt_title" class="form-control" value="{{$singlenews[0]->NewsTitle}}" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_news_for">News For</label>
                                            <select class="form-control" name="dd_news_for" id="dd_news_for" required>
                                                <option value="-1">Select</option>
                                                <option value="1" {{$singlenews[0]->NewsFor == 'EMPLOYEE' ? 'selected' : ''}}>Employee</option>
                                                <option value="2" {{$singlenews[0]->NewsFor == 'MEMBER' ? 'selected' : ''}}>Member</option>
                                                <option value="3" {{$singlenews[0]->NewsFor == 'ALL' ? 'selected' : ''}}>All</option>
                                            </select>  
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Events/News Description</label>
                                            <textarea id="txt_desc" name="txt_desc"  class="form-control" placeholder="Enter Events/News Description" rows="5"  required>{{$singlenews[0]->NewsDes}}</textarea>
                                        </div>
                                    </div> 

                                    

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Status</label>
                                            <select class="form-control" name="dd_status" id="dd_status" required>
                                                <option value="-1">Select</option>
                                                <option value="1" {{$singlenews[0]->NewsStatus == 'ACTIVE' ? 'selected' : ''}}>Active</option>
                                                <option value="2" {{$singlenews[0]->NewsStatus == 'INACTIVE' ? 'selected' : ''}}>InActive</option>
                                            </select>  
                                        </div>
                                    </div>
                                </div>    
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit-news')">Save</button>
                            </div>
                        </form>
                        @elseif(!isset($singlebank[0]->NewsId))
                        <form id="add-news" action="{{ url('/add_news') }}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_title">Title</label>
                                            <input type="text" name="txt_title" id="txt_title" class="form-control" placeholder="Enter Title." required>
                                        </div>
                                    </div>    

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_news_for">News For</label>
                                            <select class="form-control" name="dd_news_for" id="dd_news_for" required>
                                                <option value="-1">Select</option>
                                                <option value="1">Employee</option>
                                                <option value="2">Member</option>
                                                <option value="3">All</option>
                                            </select>  
                                        </div>
                                    </div>
                                    
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Events/News Description</label>
                                            <textarea id="txt_desc" name="txt_desc"  class="form-control" placeholder="Enter Events/News Description" rows="5"  required>Enter Description</textarea>
                                        </div>
                                    </div> 

                                    

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Status</label>
                                            <select class="form-control" name="dd_status" id="dd_status" required>
                                                <option value="-1">Select</option>
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select>  
                                        </div>
                                    </div>
                                </div>    
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add-news')">Save</button>
                            </div>
                        </form>
                        @endif
                    </div>
        
                </div>
            </div>
            

            <div class="col-md-8">
                <div class="panel">
                    
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.NO.</th>
                                    <th>NEWS</th>
                                    <th>NEWS FOR</th>
                                    <th class="min-tablet">DESCRIPTION</th>
                                    <th class="min-tablet">NEWS CREATED DATE</th>
                                    <th class="min-tablet">EDIT</th>
                                    <!-- <th class="min-tablet">DELETE</th> -->
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1;?>
                                @foreach($user_news as $value)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{$value->NewsTitle}}</td>
                                    <td>{{$value->NewsFor}}</td>
                                    <td>{{$value->NewsDes}}</td>
                                    
                                    <td>{{$value->NewsDate}}</td>                                
                                    <td>
                                        <a class="btn btn-success btn-xs" href="{{url('view_news/'.$value->NewsId)}}">Edit</a>
                                        <button data-id="{{$value->NewsId}}" data-name="{{$value->NewsTitle}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$value->NewsStatus == 'ACTIVE' ? 'Active' : 'InActive'}}</button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
            
                </div>
            </div>

            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                    <form action="{{url('news_status')}}" method="POST"> 
                        {{ csrf_field() }}

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title">CHANGE NEWS STATUS</h4>
                        </div>

                        <!--Modal body-->
                        <div class="modal-body">
                            <div class="form-group">
                                <input id="txt_statusregid" name="txt_statusregid" type="hidden" class="form-control" required="required">
                            </div>
                            <p class="text-semibold text-main">NEWS TITLE :-<span id="news"></span></p>
                            <br>
                            <p class="text-semibold text-main">Would you like to change the status of news ?</p>

                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                            <button class="btn btn-primary" type="submit">Yes</button>
                        </div>

                    </form>
                    </div>
                </div>
            </div> 

        </div>      
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var brand = $(this).data('name');
        $('#txt_statusregid').val(id);
        $('#news').text(brand);
    });
});
</script>
@endsection