@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Bank Master</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('bank_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("bank_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Bank Master</h3>
                    </div>

                    <div class="collapse in">
        
                        

                        @if(isset($singlebank[0]->BANK_ID))
                        <form id="update-bank" action="{{url('/update_bank_detail/'.$singlebank[0]->BANK_ID)}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bank_name">Bank Name</label>
                                            <input type="text" name="txt_bank_name" id="txt_bank_name" class="form-control" value="{{$singlebank[0]->BANK_NAME}}" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_ifsc_code">Bank IFSC Code</label>
                                            <input type="text" name="txt_ifsc_code" id="txt_ifsc_code" class="form-control" value="{{$singlebank[0]->BANK_IFSC}}" onfocusout="bank_ifsc_validate();" onfocusin="bank_ifsc_validate();" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">For</label>
                                            <div class="radio">
                                                <input id="rb_active" class="magic-radio" type="radio" name="rb_status" value="1" {{$singlebank[0]->BANK_STATUS == 'ACTIVE' ? 'checked' : '' }} required>
                                                <label for="rb_active">Active</label>
            
                                                <input id="rb_inactive" class="magic-radio" type="radio" name="rb_status" value="2" {{$singlebank[0]->BANK_STATUS == 'INACTIVE'? 'checked' : '' }} >
                                                <label for="rb_inactive">Deactive</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">   
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="button" onclick="conwv('update-bank')">Save</button>
                                            <button class="btn btn-default" type="button">Close</button>
                                        </div>
                                    </div>
                                </div>    
                            </div>
                        </form>
                        @elseif(!isset($singlebank[0]->BANK_ID))
                        <form id="add-bank" action="{{url('add_bank_master')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bank_name">Bank Name</label>
                                            <input type="text" name="txt_bank_name" id="txt_bank_name" class="form-control" placeholder="Enter Bank Name." required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_ifsc_code">Bank IFSC Code</label>
                                            <input type="text" name="txt_ifsc_code" id="txt_ifsc_code" class="form-control" placeholder="Enter Bank IFSC Code." onfocusout="bank_ifsc_validate();" onfocusin="bank_ifsc_validate();" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">For</label>
                                            <div class="radio">
                                                <input id="rb_active" class="magic-radio" type="radio" name="rb_status" value="1" required>
                                                <label for="rb_active">Active</label>
            
                                                <input id="rb_inactive" class="magic-radio" type="radio" name="rb_status" value="2" >
                                                <label for="rb_inactive">Deactive</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">   
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="button" onclick="conwv('add-bank')">Save</button>
                                            <button class="btn btn-default" type="button">Close</button>
                                        </div>
                                    </div>
                                </div>    
                            </div>
                        </form>
                        @endif

                    </div>
        
                </div>
            
            </div>

            <div class="col-md-8">
                <div class="panel">
                    
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>BANK ID</th>
                                    <th>BANK NAME</th>
                                    <th>BANK IFSC CODE</th>
                                    <th class="min-tablet">EDIT</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php $i=1;?>
                                @foreach($bank as $value)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{$value->BANK_NAME}}</td>
                                    <td>{{$value->BANK_IFSC}}</td>
                                    <td>
                                        <a class="btn btn-success btn-xs" href="{{url('view_bank/'.$value->BANK_ID)}}">EDIT</a>
                                        <button data-id="{{$value->BANK_ID}}" data-bankname="{{$value->BANK_NAME}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$value->BANK_STATUS == '1' ? 'Active' : 'InActive'}}</button></td>
                                </tr>
                                @endforeach
                                

                            </tbody>
                        </table>
                    </div>
            
                </div>
            </div>

            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                    <form action="{{url('bank_status')}}" method="POST"> 
                        {{ csrf_field() }}

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title">CHANGE BANK STATUS</h4>
                        </div>

                        <!--Modal body-->
                        <div class="modal-body">
                            <div class="form-group">
                                <input id="txt_statusregid" name="txt_statusregid" type="hidden" class="form-control" required="required">
                            </div>
                            <p class="text-semibold text-main">BANK NAME :-<span id="bankname"></span></p>
                            <br>
                            <p class="text-semibold text-main">Would you like to change the status of bank ?</p>

                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                            <button class="btn btn-primary" type="submit">Yes</button>
                        </div>

                    </form>
                    </div>
                </div>
            </div>

        </div>    
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var bankname = $(this).data('bankname');
        $('#txt_statusregid').val(id);
        $('#bankname').text(bankname);
    });
});
</script>
@endsection
