@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">MANAGE BANK ACCOUNT</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('adminbk_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("adminbk_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">MANAGE BANK ACCOUNT</h3>
                    </div>

                    <div class="collapse in">
                        @if(isset($SB_CA[0]->ADMINBANK_ID))
                        <form id="edit-admin-bank" action="{{url('update_bank_account/'.$SB_CA[0]->ADMINBANK_ID)}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_bank">Select Bank</label>

                                            <select class="form-control" name="dd_bank" id="dd_bank" required>
                                                <option value="-1">Select</option>
                                                @foreach($bank as $bk)
                                                <option value="{{$bk->BANK_ID}}" {{$SB_CA[0]->BANK_ID == $bk->BANK_ID ? 'selected' : ''}}>{{$bk->BANK_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_name_atbank_account">Name at Account</label>
                                            <input type="text" name="txt_name_atbank_account" id="txt_name_atbank_account" class="form-control" value="{{$SB_CA[0]->NAME_AT_BANK}}" required>
                                        </div>
                                    </div>  

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bank_branch">Bank Branch</label>
                                            <input type="text" name="txt_bank_branch" id="txt_bank_branch" class="form-control" value="{{$SB_CA[0]->BANK_BRANCH}}" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bank_account_no">Account Number</label>
                                            <input type="text" name="txt_bank_account_no" id="txt_bank_account_no" class="form-control" value="{{$SB_CA[0]->BANK_ACCOUNT}}" required>
                                        </div>
                                    </div>

                                </div>
                                    
                                <div class="row">     

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_bank_account_type">Account Type</label>
                                            <select class="form-control" name="dd_bank_account_type" id="dd_bank_account_type" required>
                                                <option value="">Select</option>
                                                <option value="1" {{$SB_CA[0]->BANKACCOUNT_TYPE == 'SAVING' ? 'selected' : ''}}>Saving</option>
                                                <option value="2" {{$SB_CA[0]->BANKACCOUNT_TYPE == 'CURRENT' ? 'selected' : ''}}>Current</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bank_ifsc">IFSC Code</label>
                                            <input type="text" name="txt_bank_ifsc" id="txt_bank_ifsc" class="form-control" value="{{$SB_CA[0]->BANK_IFSCODE}}" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_banklogo">Bank Logo</label>
                                            <div>
                                                <img src="{{asset('/images/bank_logo/'.$SB_CA[0]->BANK_LOGO)}}" height="50" width="50">
                                            </div>
                                            <input type="file" name="txt_banklogo" id="txt_banklogo" class="form-control">
                                            <input type="hidden" name="txt_banklogohd" id="txt_banklogohd" value="{{$SB_CA[0]->BANK_LOGO}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_bank_account_status">Status</label>
                                            <select class="form-control" id="dd_bank_account_status" name="dd_bank_account_status" required>
                                                <option value="">Select</option>
                                                <option value="1" {{$SB_CA[0]->BANK_STATUS == 'ACTIVE' ? 'selected' : ''}}>Active</option>
                                                <option value="2" {{$SB_CA[0]->BANK_STATUS == 'IN ACTIVE' ? 'selected' : ''}}>Inactive</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit-admin-bank')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @elseif(!isset($SB_CA[0]->ADMINBANK_ID))
                        <form id="add-admin-bank" action="{{url('add_bank_account')}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_bank">Select Bank</label> 
                                            <select class="form-control" name="dd_bank" id="dd_bank" required>
                                                <option value="-1">Select</option>
                                                @foreach($bank as $bk)
                                                <option value="{{$bk->BANK_ID}}">{{$bk->BANK_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_name_atbank_account">Name at Account</label>
                                            <input type="text" name="txt_name_atbank_account" id="txt_name_atbank_account" class="form-control" placeholder="Enter Name at Account." required>
                                        </div>
                                    </div>   

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bank_branch">Bank Branch</label>
                                            <input type="text" name="txt_bank_branch" id="txt_bank_branch" class="form-control" placeholder="Enter Bank Branch." required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bank_account_no">Account Number</label>
                                            <input type="text" name="txt_bank_account_no" id="txt_bank_account_no" class="form-control" placeholder="Enter Account Number." required>
                                        </div>
                                    </div>

                                </div>
                                    
                                <div class="row">     

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_bank_account_type">Account Type</label>
                                            <select class="form-control" name="dd_bank_account_type" id="dd_bank_account_type" required>
                                                <option value="">Select</option>
                                                <option value="1">Saving</option>
                                                <option value="2">Current</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bank_ifsc">IFSC Code</label>
                                            <input type="text" name="txt_bank_ifsc" id="txt_bank_ifsc" class="form-control" placeholder="Enter IFSC Code." required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_banklogo">Bank Logo</label>
                                            <input type="file" name="txt_banklogo" id="txt_banklogo" class="form-control">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_bank_account_status">Status</label>
                                            <select class="form-control" id="dd_bank_account_status" name="dd_bank_account_status" required>
                                                <option value="">Select</option>
                                                <option value="1">Active</option>
                                                <option value="2">Inactive</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add-admin-bank')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>

            </div>
            
            <div class="col-md-8">

                <div class="panel">
                    
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No.</th>
                                    <th>User Id</th>
                                    <th class="min-tablet">Bank Name</th>
                                    <th class="min-tablet">Name at Bank</th>
                                    <th class="min-tablet">Account Number</th>
                                    <th class="min-tablet">IFSC Code</th>
                                    <th class="min-tablet">Branch</th>
                                    <th class="min-tablet">Status</th>
                                    <th class="min-tablet">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1;?>
                                @foreach($company_bank_account as $value)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{ $value->USER_ID }}</td>
                                    <td>{{ $value->BANK_NAME }}</td>
                                    <td>{{ $value->NAME_AT_BANK }}</td>
                                    <td>{{ $value->BANK_ACCOUNT }}</td>
                                    <td>{{ $value->BANK_IFSCODE }}</td>
                                    <td>{{ $value->BANK_BRANCH }}</td>
                                    <td>{{ $value->BANK_STATUS }}</td>
                                    <td>
                                        <a href="{{ url('bank_account/'.$value->ADMINBANK_ID) }}" class="btn btn-success btn-xs">EDIT</a>
                                        <button data-id="{{$value->ADMINBANK_ID}}" data-acc="{{$value->BANK_ACCOUNT}}" data-status="{{$value->BANK_STATUS}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$value->BANK_STATUS == 'ACTIVE' ? 'ACTIVE' : 'IN ACTIVE'}}</button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
            
                </div>

            </div>



        </div>

        <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">

                <form action="{{url('bank_account_status')}}" method="POST"> 
                    {{ csrf_field() }}

                    <!--Modal header-->
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                        <h4 class="modal-title">CHANGE BANK ACCOUNT STATUS</h4>
                    </div>

                    <!--Modal body-->
                    <div class="modal-body">
                        <div class="form-group">
                            <input id="txt_admin_bank_id" name="txt_admin_bank_id" type="hidden" class="form-control" required="required">
                            <input id="txt_admin_bank_status" name="txt_admin_bank_status" type="hidden" class="form-control" required="required" value="ACTIVE">
                        </div>
                        <p class="text-semibold text-main">BANK ACCOUNT NO :-<span id="acc"></span></p>
                        <br>
                        <p class="text-semibold text-main">Would you like to change the status of bank ?</p>

                    </div>

                    <!--Modal footer-->
                    <div class="modal-footer">
                        <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                        <button class="btn btn-primary" type="submit">Yes</button>
                    </div>

                </form>
                </div>
            </div>
        </div> 
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var acc = $(this).data('acc');
        var status = $(this).data('status');
        $('#txt_admin_bank_id').val(id);
        $('#txt_admin_bank_status').val(status);
        $('#acc').text(acc);
    });
});
</script>
@endsection
