@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
ul{
    list-style-type: none;
}
input[type=checkbox], input[type=radio]{
	margin-right: 10px;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
            <li class="active">Assign User Services</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('service_msg')) 
                        <div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
                            <h4 class="alert-heading">{{ Session::get('service_msg') }}</h4>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Assign User Services</h3>
                    </div>
                    
                    <div class="collapse in">
                    
                        <form action="{{ url('user_assign_services') }}" id="assign_services" method="post" accept-charset="utf-8">
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_memberid">Member Id <span class="text-danger">*</span></label>
                                            <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." required value="{{$USERID}}"  autocomplete="off">
											<ul class="list-group costom-list" id="member_name"> </ul>
                                        </div>
                                    </div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
                                        </div>
                                    </div>
                                </div>
                            </div>    
                        </form>  
                        @if($get_useralldetail != '')
                        @foreach( $get_useralldetail as $con)
                        @endforeach
                        <form id="add_user_assign_services" action="{{ url('add_user_assign_services') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <input id="txt_membercode" name="txt_membercode" type="hidden" required value="{{$con->RegCode}}" readonly>
                                <input id="txt_userid" name="txt_userid" type="hidden" required="required" value="{{$con->RegId}}" readonly>
                                 
                                <ul>
										@foreach($services as $sr1)
												<li><input type="checkbox" class="parent" id="ckb_user_service{{$sr1->SR_TYPEID}}" name="ckb_user_service[]" value="{{$sr1->SR_TYPEID}}" 
												@foreach($selected_services as $sr2)
												@if($sr2->MS_SERVICE_ID == $sr1->SR_TYPEID)
												checked='checked'
												@endif
												@endforeach
												><label for="ckb_user_service{{$sr1->SR_TYPEID}}">{{$sr1->SR_NAME}}</label></li>
                                    
										@endforeach
                                </ul>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success"  type="button"  onclick="conwv('add_user_assign_services')">Update</button>
                                <button type="reset" class="btn btn-primary">Reset</button> 
                            </div>
                        </form>
                        @endif
                        
                    </div>
                    
                </div>
            </div>
            
        </div>
        
        
    </div>
    <!--===================================================-->
    <!--End page content-->
    
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
<script>
$(function() {
  $("li:has(li) > input[type='checkbox']").change(function() {
    $(this).siblings('ul').find("input[type='checkbox']").prop('checked', this.checked);
  });
  $("input[type='checkbox'] ~ ul input[type='checkbox']").change(function() {
    $(this).closest("li:has(li)").children("input[type='checkbox']").prop('checked', $(this).closest('ul').find("input[type='checkbox']").is(':checked'));
  });
});
</script>

@endsection