@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
ul{
    list-style-type: none;
}
li{
	list-style: none;
}
input[type=checkbox], input[type=radio]{
	margin-right: 10px;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
            <li class="active">Assign User Menu</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('umenu_msg')) 
                        <div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
                            <h4 class="alert-heading">{{ Session::get('umenu_msg') }}</h4>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Assign User Menu</h3>
                    </div>
                    
                    <div class="collapse in">
                    
                        <form action="{{'user_assign_menu'}}" id="bank_edit" method="post" accept-charset="utf-8">
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_memberid">Member Id *</label>
                                            <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." required value={{$USERID}}>
                                        </div>
                                    </div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
                                        </div>
                                    </div>
                                </div>
                            </div>    
                        </form>  
                        @if($get_useralldetail != '')
						@php
						$role_id = explode(".",$get_useralldetail[0]->MemberRoleId);
						$role_id = $role_id[0];
						$us_ud = 'U_'.$role_id[0];
						@endphp
                        <form id="add_user_assign_menu" action="{{ url('add_user_assign_menu') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <input id="txt_membercode" name="txt_membercode" type="hidden" required value="{{$get_useralldetail[0]->RegCode}}" readonly>
                                <input id="txt_userid" name="txt_userid" type="hidden" required="required" value="{{$get_useralldetail[0]->RegId}}" readonly>
                                 
                                <ul>
                                @foreach($menus as $mn)
									@if($mn->ASMENU_PARENTID == '-1')
                                   <li><input type="checkbox" class="parent" id="ckb_usermenu{{$mn->ASMENU_ID}}" name="ckb_usermenu[]" value="{{$mn->ASMENU_ID}}" 
									@php  $menu_user_roles = explode(',', $mn->ASMENU_ROLE); @endphp
									@if(in_array($us_ud, $menu_user_roles))
										checked="checked" disabled
									@endif
									@if(isset($selected_menus[0]))
									@if(in_array($mn->ASMENU_ID,$selected_menus))
										checked="checked"
										@endif
									@endif
								><label for="ckb_usermenu{{$mn->ASMENU_ID}}">{{$mn->ASMENU_NAME}} </label>
                                   <ul>
                                    @foreach($menus as $mn1)
                                    @if($mn1->ASMENU_PARENTID==$mn->ASMENU_ID)
                                        <li><input type="checkbox" class="child" id="ckb_usermenu1{{$mn1->ASMENU_ID}}" name="ckb_usermenu[]" value="{{$mn1->ASMENU_ID}}" 
										@php  $menu_user_role = explode(',', $mn1->ASMENU_ROLE); @endphp
										@if(in_array($us_ud, $menu_user_role))
											checked="checked" disabled
										@endif
										@if(isset($selected_menus[0]))
										@if(in_array($mn1->ASMENU_ID,$selected_menus))
										checked="checked"
										@endif
										@endif
								><label for="ckb_usermenu1{{$mn1->ASMENU_ID}}">{{$mn1->ASMENU_NAME}}</label></li> 
                                    @endif
                                    @endforeach
                                    </ul>
                                    </li>
									@endif
                                @endforeach
                                </ul>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success"  type="button"  onclick="conwv('add_user_assign_menu')">Add</button>
                                <button type="reset" class="btn btn-primary">Reset</button> 
                            </div>
                        </form>
                        @endif
                        
                    </div>
                    
                </div>
            </div>
            
        </div>
        
        
    </div>
    <!--===================================================-->
    <!--End page content-->
    
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
<script>
$(function() {
  $("li:has(li) > input[type='checkbox']").change(function() {
    $(this).siblings('ul').find("input[type='checkbox']").prop('checked', this.checked);
  });
  $("input[type='checkbox'] ~ ul input[type='checkbox']").change(function() {
    $(this).closest("li:has(li)").children("input[type='checkbox']").prop('checked', $(this).closest('ul').find("input[type='checkbox']").is(':checked'));
  });
});
</script>

@endsection