@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Update Bank Account</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Update Bank Account</h3>
                    </div>

                    <div class="collapse in">
        
                        <form id="edit-admin-bank" action="{{ url('/admin/update_bankacc') }}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">User Id</label>
                                            <input type="text" id="txtuserid" name="txtuserid" class="form-control" placeholder="Enter User Id." required>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">   
                                        <div class="form-group">
                                            <label class="control-label" for="txtname">Name</label>
                                            <input type="text" id="txtname" name="txtname" class="form-control" placeholder="Enter Name." required>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txtaccname">A/C Holder Name</label>
                                            <input type="text" id="txtaccname" name="txtaccname" class="form-control" placeholder="Enter A/C Holder Name." required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txtcbsaccno">CBS A/C Number</label>
                                            <input type="text" id="txtcbsaccno" name="txtcbsaccno" class="form-control" placeholder="Enter CBS A/C Number." required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="ddbank">Bank Name</label>
                                            <select class="form-control" id="ddbank" name="ddbank">
                                                <option>Select Bank Name</option>
                                                @foreach($bank as $value)
                                                    <option value="{{$value->m_bank_id}}">{{$value->m_bank_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txtifsccode">IFSC Code</label>
                                            <input type="text" id="txtifsccode" name="txtifsccode" class="form-control" placeholder="Enter IFSC Code." required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="control-label" for="txtbankbranch">Bank Branch</label>
                                            <input type="text" id="txtbankbranch" name="txtbankbranch" class="form-control" placeholder="Enter Bank Branch." required>
                                        </div>
                                    </div>
                                </div>    
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit-admin-bank')">Update</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

