@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Static Content Details</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-12">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('staticcnt_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("staticcnt_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Static Content Details</h3>
                    </div>

                    <div class="collapse in">
                        @if(isset($singlecnt[0]->STCNT_ID))
                        <form id="edit-static-content" action="{{url('update_static_cnt/'.$singlecnt[0]->STCNT_ID)}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_m10_staticcnt_title">Title</label>
                                            <input type="text" name="txt_m10_staticcnt_title" id="txt_m10_staticcnt_title" class="form-control" value="{{$singlecnt[0]->STCNT_TITLE}}" required>
                                        </div>
                                    </div>   

                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_m10_staticcnt_variable">Variable</label>
                                            <input type="text" name="txt_m10_staticcnt_variable" id="txt_m10_staticcnt_variable" class="form-control" value="{{$singlecnt[0]->STCNT_VAR}}" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="status">Status</label>
                                            <select class="form-control" name="status" id="status" required>
                                                <option value="">Select</option>
                                                <option value="1" {{$singlecnt[0]->STCNT_STATUS == 'Active' ? 'selected' : ''}}>Active</option>
                                                <option value="2" {{$singlecnt[0]->STCNT_STATUS == 'InActive' ? 'selected' : ''}}>InActive</option>
                                            </select> 
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_m10_staticcnt_content">Description</label>
                                            <textarea type="text" id="demo-summernote" name="txt_m10_staticcnt_content" class="form-control" placeholder="Enter Description." required>{{$singlecnt[0]->STCNT_CONTENT}}</textarea>
                                        </div>
                                    </div>

                                </div>


                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit-static-content')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @elseif(!isset($singlecnt[0]->STCNT_ID))
                        <form id="add-static-content" action="{{url('add_static_cnt')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_m10_staticcnt_title">Title</label>
                                            <input type="text" name="txt_m10_staticcnt_title" id="txt_m10_staticcnt_title" class="form-control" placeholder="Enter Title." required>
                                        </div>
                                    </div>   

                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_m10_staticcnt_variable">Variable</label>
                                            <input type="text" name="txt_m10_staticcnt_variable" id="txt_m10_staticcnt_variable" class="form-control" placeholder="Enter Variable." required>
                                        </div>
                                    </div>

                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="control-label" for="status">Status</label>
                                            <select class="form-control" name="status" id="status" required>
                                                <option value="">Select</option>
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_m10_staticcnt_content">Description</label>
                                            <textarea type="text" id="demo-summernote" name="txt_m10_staticcnt_content" class="form-control" placeholder="Enter Description." required></textarea>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add-static-content')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>
            </div>

            <div class="col-md-12">

                <div class="panel">
                    
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No.</th>
                                    <th>Title</th>
                                    <th class="min-tablet">Variable</th>
                                    <th class="min-tablet">Description</th>
                                    <th class="min-tablet">Created At</th>
                                    <th class="min-tablet">Edit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1;?>
                                @foreach($static_cont as $value)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{ $value->STCNT_TITLE }}</td>
                                    <td>{{ $value->STCNT_VAR }}</td>
                                    <td>{!! $value->STCNT_CONTENT !!}</td>
                                    <td>{{ $value->STCNT_CREATED_AT }}</td>
                                    <td>
                                        <a href="{{ url('static_cnt/'.$value->STCNT_ID) }}" class="btn btn-success btn-xs">EDIT</a>
                                        <button data-id="{{$value->STCNT_ID}}" data-staticcntname="{{$value->STCNT_TITLE}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$value->STCNT_STATUS == 'Active' ? 'Active' : 'InActive'}}</button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
            
                </div>

            </div>

            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                    <form action="{{url('static_cnt_status')}}" method="POST"> 
                        {{ csrf_field() }}

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title">CHANGE STATIC CONTENT STATUS</h4>
                        </div>

                        <!--Modal body-->
                        <div class="modal-body">
                            <div class="form-group">
                                <input id="txt_statusregid" name="txt_statusregid" type="hidden" class="form-control" required="required">
                            </div>
                            <p class="text-semibold text-main">STATIC CONTENT TITLE :-<span id="staticcntname"></span></p>
                            <br>
                            <p class="text-semibold text-main">Would you like to change the status of static content ?</p>

                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                            <button class="btn btn-primary" type="submit">Yes</button>
                        </div>

                    </form>
                    </div>
                </div>
            </div>

        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var staticcntname = $(this).data('staticcntname');
        $('#txt_statusregid').val(id);
        $('#staticcntname').text(staticcntname);
    });
});
</script>
@endsection
