@extends('mainlayout')
@section('content')

<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Service Charge Management</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Service Charge</h3>
                    </div>

                    <div class="collapse in">
                        @if(isset($single_adminsr[0]->SC_ID))
                        <form id="edit_service" action="{{url('/update_admin_services/'.$single_adminsr[0]->SC_ID)}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Affiliate <span class="text-danger">*</span></label>
                                            <select name="dd_affiliate" id="dd_affiliate" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Affiliate</option>
                                                @foreach($affil as $values)
                                                <option value="{{$values->AFFI_ID}}" {{ $values->AFFI_ID == $single_adminsr[0]->AFFILIATE_ID ? 'selected' : ''}}>{{$values->AFFI_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Role <span class="text-danger">*</span></label>
                                            <select name="dd_role" id="dd_role" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Role</option>
                                                @foreach($admin_roles as $values)
                                                <option value="{{$values->ROLE_ID}}" {{$single_adminsr[0]->USER_ROLE_ID==$values->USER_ROLE_ID? 'selected' : ''}}>{{$values->ROLE_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                     <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select  Fee Type <span class="text-danger">*</span></label>
                                            <select name="dd_feetype" id="dd_feetype" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Fee Type</option>
												@foreach($bdtype as $value)
                                                <option value="{{$value->m70_bdt_id}}" {{ $value->m70_bdt_id == $single_adminsr[0]->BDT_LEDGER_ID ? 'selected' : ''}}>{{$value->m70_bdt_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Balance Type <span class="text-danger">*</span></label>
                                            <select name="dd_balance_type" id="dd_balance_type" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select  Balance Type</option>
												<option value="1"  {{$single_adminsr[0]->BAL_TYPE_INT== 1? 'selected' : ''}}>MAIN</option>
												<option value="2"  {{$single_adminsr[0]->BAL_TYPE_INT== 2? 'selected' : ''}}>DMR</option>
                                            </select>
                                        </div>
                                    </div>
									<div class="col-md-12">
										<div class="form-group">
											<label class="control-label" for="dd_service">Services <span class="text-danger">*</span> </label>
												<select multiple="multiple"  id="demo-select2-multiple-selects" class="form-control" name="dd_service[]" data-width="100%" data-placeholder="Select Servcices" onchange="getservices(this.id)">
												@foreach($service as $value)
												<option value="{{$value->m03_sr_type_id}}" @if(in_array($value->m03_sr_type_id, explode(",",$single_adminsr[0]->SERVICE_ID))) selected @endif>{{$value->m03_service_name}}</option>
												@endforeach
											</select>
										</div>
									</div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Amount</label>
                                            <input type="number" name="txt_amount" id="txt_amount" class="form-control" value="{{$single_adminsr[0]->SC_AMOUNT}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_dist_ratio">Distribution Ratio <code>%</code></label>
                                            <input type="number" name="txt_dist_ratio" id="txt_dist_ratio" class="form-control" value="{{$single_adminsr[0]->SC_DIST_RATIO}}" maxlength="3">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description <span class="text-danger">*</span></label>
                                            <input type="text" name="txt_desc" id="txt_desc" class="form-control" value="{{$single_adminsr[0]->SC_DESC}}">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit_service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @else
                        <form id="add_service" action="{{url('/add_admin_services')}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Affiliate <span class="text-danger">*</span></label>
                                            <select name="dd_affiliate" id="dd_affiliate" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Affiliate</option>
                                                @foreach($affil as $values)
                                                <option value="{{$values->AFFI_ID}}" {{ $values->AFFI_ID == 1 ? 'selected' : ''}}>{{$values->AFFI_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Role <span class="text-danger">*</span></label>
                                            <select name="dd_role" id="dd_role" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Role</option>
                                                @foreach($admin_roles as $values)
                                                <option value="{{$values->ROLE_ID}}">{{$values->ROLE_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Fee Type <span class="text-danger">*</span></label>
                                            <select name="dd_feetype" id="dd_feetype" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select  Fee Type</option>
												@foreach($bdtype as $value)
                                                <option value="{{$value->m70_bdt_id}}" {{ $value->m70_bdt_id == '' ? 'selected' : ''}}>{{$value->m70_bdt_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Balance Type <span class="text-danger">*</span></label>
                                            <select name="dd_balance_type" id="dd_balance_type" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select  Balance Type</option>
												<option value="1">MAIN</option>
												<option value="2">DMR</option>
                                            </select>
                                        </div>
                                    </div>
									<div class="col-md-12">
										<div class="form-group">
											<label class="control-label" for="dd_service">Services <span class="text-danger">*</span><span class="text-danger">*</span> </label>
												<select multiple="multiple"  id="demo-select2-multiple-selects" class="form-control" name="dd_service[]" data-width="100%" data-placeholder="Select Servcices" onchange="getservices(this.id)">
												@foreach($service as $value)
												<option value="{{$value->m03_sr_type_id}}" {{old('dd_service') == $value->m03_sr_type_id? 'selected':''}}>{{$value->m03_service_name}}</option>
												@endforeach
											</select>
										</div>
									</div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Amount <span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount" id="txt_amount" class="form-control" placeholder="Enter Amount">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_dist_ratio">Distribution Ratio <code>%</code></label>
                                            <input type="number" name="txt_dist_ratio" id="txt_dist_ratio" class="form-control" placeholder="Enter Distribution Ratio"  maxlength="3">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description <span class="text-danger">*</span></label>
                                            <input type="text" name="txt_desc" id="txt_desc" class="form-control" placeholder="Enter Description">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add_service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>

            </div>
            
        

            <div class="col-md-8">
                <div class="panel">
                
                    <div class="panel-body" style="overflow-x:auto;">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No</th>
									<th class="min-tablet">Affiliate</th>
                                    <th class="min-tablet">User Role</th>
									<th class="min-tablet">Type</th>
									<th class="min-tablet">Service</th>
                                    <th class="min-tablet">Amount</th>
                                    <th class="min-tablet">Distribution Ratio</th>
                                    <th>Description</th>
                                    <th class="min-tablet">Action</th>
                                    <th class="min-tablet">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>
                               @foreach($all_adminsr as $values)
                               <tr>
                                    <td>{{$i++}}</td>
									<td>{{$values->AFFILIATE_NAME}}</td>
                                    <td>{{$values->USER_ROLE_NAME}}</td> 
									<td>{{$values->BDT_LEDGER_NMAE}}</td>
								   <td>
										@if($values->SERVICE_ID != '')
												@php $sr = explode(",",$values->SERVICE_ID); @endphp
													@foreach($service as $value)
														@foreach($sr as $valu)
														@if($value->m03_sr_type_id == $valu)
															<button  class="btn btn-success btn-xs " style="margin: 1px;" >{{$value->m03_service_name}} </button>
														@endif
														@endforeach
													@endforeach
											  @endif						
									</td>
                                    <td>{{$values->SC_AMOUNT}}</td>
                                    <td>{{$values->SC_DIST_RATIO}}</td>
                                    <td>{{$values->SC_DESC}}</td>
                                    <td><a class="btn btn-success btn-xs" href="{{url('view_admin_services/'.$values->SC_ID)}}">EDIT</a></td>
									<td><a class="btn btn-{{$values->STATUS == 'ACTIVE' ? 'success':'danger'}} btn-xs" href="{{url('status_admin_services/'.$values->SC_ID.'/'.$values->STATUS)}}">{{$values->STATUS}}</a></td>
                                </tr>
                               @endforeach
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>

        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script type="text/javascript">
$(document).ready(function(){
$("#demo-select2-multiple-selects").select2();
});
</script>
@endsection