@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 30px;
}

.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 22px;
  width: 22px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #ff8834;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Ecommerce Setting</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li class="active">Social Authentication</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-12">
                <div class="panel">
                
                    <div class="panel-body">
					<div class="row">
                        <h3 class="col-12 pb-20 clr-stripe"><img src="{{asset('/images/razorpay.jpg')}}" alt="razorpay">   <span class="pull-right"><label class="switch"><input type="checkbox"><span class="slider"></span></label></span></h3>
                            

                            <div class="col-md-6">    
                                <!-- facebook_app_id Field -->
                                <div class="form-group col-md-12">
                                    <label for="" class="control-label">Razorpay Key</label>
                                        <input class="form-control" placeholder="Razorpay Key Here" name="" type="text" id="" value="">
                                        <div class="form-text text-muted">
                                            Insert Razorpay Key
                                        </div>
                                </div>
                            </div>    
                            <div class="col-md-6">
                                <!-- facebook_app_secret Field -->
                                <div class="form-group ">
                                    <label for="" class="control-label text-right">Razorpay Secret</label>
                                        <input class="form-control" placeholder="Razorpay Secret Key Here" name="" type="text" id="" value="">
                                        <div class="form-text text-muted">
                                            Insert Razorpay Secret Key
                                        </div>
                                </div>
                            </div>    
						</div>
						<hr>
					<div class="row">
                        <h3 class="col-12 pb-20 clr-stripe"><img src="{{asset('/images/payu.png')}}" alt="payu">   <span class="pull-right"><label class="switch"><input type="checkbox"><span class="slider"></span></label></span></h3>
                            

                            <div class="col-md-6">    
                                <!-- facebook_app_id Field -->
                                <div class="form-group col-md-12">
                                    <label for="" class="control-label">PayU Key</label>
                                        <input class="form-control" placeholder="PayU Key Here" name="" type="text" id="" value="">
                                        <div class="form-text text-muted">
                                            Insert PayU Key
                                        </div>
                                </div>
                            </div>    
                            <div class="col-md-6">
                                <!-- facebook_app_secret Field -->
                                <div class="form-group ">
                                    <label for="" class="control-label text-right">PayU Secret</label>
                                        <input class="form-control" placeholder="PayU Secret Key Here" name="" type="text" id="" value="">
                                        <div class="form-text text-muted">
                                            Insert PayU Secret Key
                                        </div>
                                </div>
                            </div>    
						</div>
						<hr>
					<div class="row">
                        <h3 class="col-12 pb-20 clr-stripe"><i class="mr-3 fa fa-cc-stripe"></i> Stripe  <span class="pull-right"><label class="switch"><input type="checkbox"><span class="slider"></span></label></span></h3>
                            

                            <div class="col-md-6">    
                                <!-- facebook_app_id Field -->
                                <div class="form-group col-md-12">
                                    <label for="" class="control-label">Stripe Key</label>
                                        <input class="form-control" placeholder="Stripe Key Here" name="" type="text" id="" value="">
                                        <div class="form-text text-muted">
                                            Insert Stripe Key
                                        </div>
                                </div>
                            </div>    
                            <div class="col-md-6">
                                <!-- facebook_app_secret Field -->
                                <div class="form-group ">
                                    <label for="" class="control-label text-right">Stripe Secret</label>
                                        <input class="form-control" placeholder="Stripe Secret Key Here" name="" type="text" id="" value="">
                                        <div class="form-text text-muted">
                                            Insert Stripe Secret Key
                                        </div>
                                </div>
                            </div>    
						</div>
						<hr>
						<div class="row">
                        <h3 class="col-12 pb-20 clr-paypal"><i class="mr-3 fa fa-cc-paypal"></i> PayPal  <span class="pull-right"><label class="switch"><input type="checkbox"><span class="slider"></span></label></span></h3>
                            <div class="col-md-12">    
                                <!-- facebook_app_id Field -->
                                <div class="form-group col-md-12">
                                    <label for="" class="control-label fs-17 weight700">Enable Live Mode</label>
                                        <input type="checkbox" id="" name="' value="">
                                </div>
                            
                                <!-- facebook_app_secret Field -->
                                <div class="form-group col-md-6">
                                    <label for="" class="control-label text-right">PayPal Username</label>
                                     <input class="form-control" placeholder="Enter PayPal Username Here" name="" type="text" id="" value="">
                                        
                                </div>
								<div class="form-group col-md-6">
                                    <label for="" class="control-label text-right">PayPal Password</label>
                                     <input class="form-control" placeholder="Enter PayPal Password Here" name="" type="text" id="" value="">
                                        
                                </div>
								<div class="form-group col-md-6">
								    <label for="" class="control-label text-right">PayPal Sceret Key</label>
                                    <input class="form-control" placeholder="Enter PayPal Sceret Key Here" name="" type="text" id="" value="">
                                </div>
								<div class="form-group col-md-6">
								    <label for="" class="control-label text-right">PayPal App ID</label>
                                    <input class="form-control" placeholder="Enter PayPal App ID Here" name="" type="text" id="" value="">
                                </div>
                            </div>    
						</div>
						<hr>
						<div class="row">
                        <h3 class="col-12 pb-20 "><i class="mr-3 fa fa-rupee"></i> Default Tax</h3>
                            <div class="col-md-12">    
								<div class="form-group col-md-6">
								    <label for="" class="control-label text-right">Default Tax</label>
                                    <input class="form-control" placeholder="20" name="" type="text" id="" value="">
									<div class="form-text text-muted">
                                            Insert Default Tax Ex: 20 for (20%)
                                        </div>
                                </div>
                            </div>    
						</div>
						<hr>
						<div class="row">
                        <h3 class="col-12 pb-20 "><i class="mr-3 fa fa-money"></i> Default Currency</h3>
                            <div class="col-md-12">    
								<div class="form-group col-md-6">
                                       <label class="control-label" for="">Default Currency</label>
                                       <select class="form-control" id="" name="">
												<option value="1">INR</option>
                                        </select>
                                 </div>
								<div class="form-group col-md-12">
                                    <label for="" class="control-label fs-17 weight700">Show currency in the right of price</label>
                                        <input type="checkbox" id="" name="' value="">
                                </div>
                            </div>    
						</div>
						<hr>
                            <!-- Submit Field -->
                            <div class="form-group mt-4 col-12 text-right">
                                <button type="button" class="btn btn-success" onclick="conwv('edit-social');">
                                    <i class="fa fa-save"></i> Save Social Authentication
                                </button>
                                <a href="" class="btn btn-default"><i class="fa fa-undo"></i> Cancel</a>
                            </div>
                    </div>
                
                </div>
            </div>

        </div>

        <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">

                <form action="{{url('wl_news_status')}}" method="POST"> 
                    {{ csrf_field() }}

                    <!--Modal header-->
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                        <h4 class="modal-title">CHANGE NEWS STATUS</h4>
                    </div>

                    <!--Modal body-->
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="control-label">NEWS TITLE :-  <span id="newsname"></span></label>
                            <input id="txt_statusregid" name="txt_statusregid" type="hidden" class="form-control" required="required">
                        </div>
                        <br>
                        <p class="text-semibold text-main">Would you like to change the status of news ?</p>

                    </div>

                    <!--Modal footer-->
                    <div class="modal-footer">
                        <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                        <button class="btn btn-primary" type="submit">Yes</button>
                    </div>

                </form>
                </div>
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>


<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    function get_status_details(obj,id)
    {
        alert(id);
        $('#txt_statusregid').val(id);
        $('#newsname').html($(obj).data('name'));
    } 
});
</script>
@endsection