@extends('mainlayout')
@section('content')
  
    <link href="{{asset('plugins/switchery/switchery.min.css')}}" rel="stylesheet">
    <script src="{{asset('plugins/switchery/switchery.min.js')}}"></script>
    <script src="{{asset('plugins/chosen/chosen.jquery.min.js')}}"></script>
    <script src="{{asset('plugins/noUiSlider/nouislider.min.js')}}"></script>
 <script src="{{asset('js/demo/form-component.js')}}"></script>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Operator Details</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('operator_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("operator_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Operator Details</h3>
                    </div>

                    <div class="collapse in">
                        @if(isset($singleopt[0]->TelecomBrandId))
                        <form id="edit-operator" action="{{url('/update_operator/'.$singleopt[0]->TelecomBrandId)}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_service">Select Service</label>
                                            <select class="form-control" name="dd_service" id="dd_service" required>
                                                <option value="-1">SELECT SERVICE</option>
                                                @foreach($services as $sr)
                                                <option value="{{$sr->SR_TYPEID}}" {{$sr->SR_TYPEID == $singleopt[0]->ServiceTypeId ? 'selected' : ''}}>{{$sr->SR_NAME}}</option>
                                                @endforeach
                                            </select>  
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_name">Operator Name</label>
                                            <input type="text" name="txt_brand_name" id="txt_brand_name" class="form-control" value="{{$singleopt[0]->BrandName}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_code">Operator Code</label>
                                            <input type="text" name="txt_brand_code" id="txt_brand_code" class="form-control" value="{{$singleopt[0]->BrandCode}}">
                                        </div>
                                    </div>  

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_minamount">Min Recharge Amount</label>
                                            <input type="text" name="txt_brand_minamount" id="txt_brand_minamount" class="form-control" value="{{$singleopt[0]->MinAmount}}">
                                        </div>
                                    </div>  

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_minamount">Max Recharge Amount</label>
                                            <input type="text" name="txt_brand_maxamount" id="txt_brand_maxamount" class="form-control" value="{{$singleopt[0]->MaxAmount}}">
                                        </div>
                                    </div>                                    

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_repeatrecharge">Repeat Recharge</label>
                                            <input type="text" name="txt_brand_repeatrecharge" id="txt_brand_repeatrecharge" class="form-control" value="{{$singleopt[0]->RepeatRecharge}}">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="brand_image">Operator Image</label>
                                            <img src="{{asset('/images/brand_image/'.$singleopt[0]->BrandImage)}}" height="50" width="50">
                                            <input type="file" name="brand_image" id="brand_image" class="form-control">
                                            <input type="hidden" name="txt_brand_imagehd" id="txt_brand_imagehd" class="form-control" value="{{$singleopt[0]->BrandImage}}">
                                        </div>
                                    </div>
									@if($singleopt[0]->Account == 1)
									<div class="col-sm-12" >
										<div class="form-group">
											<label class="control-label" for="txt_ac_desc">Ac Description</label>
											<input type="text" name="txt_ac_desc" id="txt_ac_desc" value="{{$singleopt[0]->AcDesc}}" class="form-control" placeholder="Enter Account Description" >
										</div>
									</div>
									@else
										<div class="col-sm-12">
										<div class="form-group">
															<p class="text-main">This Account &emsp;
															<input id="demo-sw-checked" name="txt_account" onchange="show_input()" type="checkbox"></p>
														</div>
										</div>
										<div class="col-sm-12"  id="ac1" style="display: none;">
											<div class="form-group">
												<label class="control-label" for="txt_ac_desc">Ac Description</label>
												<input type="text" name="txt_ac_desc" id="txt_ac_desc" class="form-control" placeholder="Enter Account Description" >
											</div>
										</div>
									@endif
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="status">Status</label>
                                            <select class="form-control" name="status" id="status" required>
                                                <option value="">Select</option>
                                                <option value="1" {{$singleopt[0]->BrandStatus == 'Active' ? 'selected' : ''}}>Active</option>
                                                <option value="2" {{$singleopt[0]->BrandStatus == 'InActive' ? 'selected' : ''}}>InActive</option>
                                            </select>  
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit-operator')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @elseif(!isset($singleopt[0]->TelecomBrandId))
                        <form id="add-operator" action="{{url('/add_operator')}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_service">Select Service</label>
                                            <select class="form-control" name="dd_service" id="dd_service" required>
                                                <option value="-1">SELECT SERVICE</option>
                                                @foreach($services as $sr)
                                                <option value="{{$sr->SR_TYPEID}}">{{$sr->SR_NAME}}</option>
                                                @endforeach
                                            </select>  
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_name">Operator Name</label>
                                            <input type="text" name="txt_brand_name" id="txt_brand_name" class="form-control" placeholder="Enter Operator Name.">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_code">Operator Code</label>
                                            <input type="text" name="txt_brand_code" id="txt_brand_code" class="form-control" placeholder="Enter Operator Code.">
                                        </div>
                                    </div>  

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_minamount">Min Recharge Amount</label>
                                            <input type="text" name="txt_brand_minamount" id="txt_brand_minamount" class="form-control" placeholder="Enter Min Recharge Amount.">
                                        </div>
                                    </div>    

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_minamount">Max Recharge Amount</label>
                                            <input type="text" name="txt_brand_maxamount" id="txt_brand_maxamount" class="form-control" placeholder="Enter Max Recharge Amount.">
                                        </div>
                                    </div>                                    

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_brand_repeatrecharge">Repeat Recharge</label>
                                            <input type="text" name="txt_brand_repeatrecharge" id="txt_brand_repeatrecharge" class="form-control" placeholder="Enter Repeat Recharge.">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="brand_image">Operator Image</label>
                                            <input type="file" name="brand_image" id="brand_image" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
									<div class="form-group">
                                                        <p class="text-main">This Account &emsp;
                                                        <input id="demo-sw-checked" name="txt_account" onchange="show_input()" type="checkbox"></p>
                                                    </div>
									</div>
									<div class="col-sm-12"  id="ac1" style="display: none;">
										<div class="form-group">
											<label class="control-label" for="txt_ac_desc">Ac Description</label>
											<input type="text" name="txt_ac_desc" id="txt_ac_desc" class="form-control" placeholder="Enter Account Description" >
										</div>
									</div>
									<div id="ac"></div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="status">Status</label>
                                            <select class="form-control" name="status" id="status" required>
                                                <option value="">Select</option>
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select>  
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add-operator')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>

            </div>    
            

            <div class="col-md-8">
                <div class="panel">
                
                    <div class="panel-body">
                        <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>Operator</th>
                                    <th class="min-tablet">Code</th>
                                    <th class="min-tablet">Min. Amt.</th>
                                    <th class="min-tablet">Max. Amt.</th>
                                    <th class="min-tablet">After Repeat</th>
                                    <th class="min-tablet">Image</th>
                                    <th class="min-tablet">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1;?>
                                @foreach($OPERATOR as $value)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{$value->BrandName}}</td>
                                    <td>{{$value->BrandCode}}</td>
                                    <td>{{$value->MinAmount}}</td>
                                    <td>{{$value->MaxAmount}}</td>
                                    <td>{{$value->RepeatRecharge}}</td>
                                    <td><img src="{{asset('/images/brand_image/'.$value->BrandImage)}}" height="50" width="50"></td>
                                    <td>
                                        <a class="btn btn-success btn-xs" href="{{url('/operator/'.$value->TelecomBrandId)}}">EDIT</a>
                                        <button data-id="{{$value->TelecomBrandId}}" data-brand="{{$value->BrandName}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$value->BrandStatus == 'Active' ? 'Active' : 'InActive'}}</button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                    <form action="{{url('/operator_status')}}" method="POST"> 
                        {{ csrf_field() }}

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title">CHANGE OPERATOR STATUS</h4>
                        </div>

                        <!--Modal body-->
                        <div class="modal-body">
                            <div class="form-group">
                                <input id="txt_statusregid" name="txt_statusregid" type="hidden" class="form-control" required="required">
                            </div>
                            <p class="text-semibold text-main">OPERATOR NAME :-<span id="brand"></span></p>
                            <br>
                            <p class="text-semibold text-main">Would you like to change the status of operator ?</p>

                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                            <button class="btn btn-primary" type="submit">Yes</button>
                        </div>

                    </form>
                    </div>
                </div>
            </div> 
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var brand = $(this).data('brand');
        $('#txt_statusregid').val(id);
        $('#brand').text(brand);
    });
});

    function show_input()
    { 
		if($("#demo-sw-checked").prop("checked") == true)
		{
			$("#ac1").show();
		}
		if($("#demo-sw-checked").prop("checked") == false)
		{
			$("#ac1").hide();
		}

    }
</script>

@endsection