@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Message Details</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('msg_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("msg_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Message Details</h3>
                    </div>

                    <div class="collapse in">
                        @if(isset($singlemsg[0]->MSG_ID))
                        <form id="edit-message" action="{{url('update_message/'.$singlemsg[0]->MSG_ID)}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
									<div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="messages_type">Message Type</label>
                                            <select class="form-control" name="messages_type" id="messages_type" required>
                                                <option value="">Select</option>
                                                <option value="2" {{$singlemsg[0]->MSG_TYPE == 'CAMPAIGAN' ? 'selected' : ''}}>Campaign</option>
                                                <option value="1" {{$singlemsg[0]->MSG_TYPE == 'NON CAMPAIGAN' ? 'selected' : ''}}>Non-campaign</option>
                                            </select> 
                                        </div>
                                    </div>

									<div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="messages_category">Message Category</label>
                                            <select class="form-control" name="messages_category" id="messages_category" required>
                                                <option value="">Select</option>
                                                <option value="1" {{$singlemsg[0]->MSG_CAT_TYPE == 'Occassion' ? 'selected' : ''}}>Occassion</option>
												<option value="2" {{$singlemsg[0]->MSG_CAT_TYPE == 'Reminders' ? 'selected' : ''}}>Reminders</option>
												<option value="3" {{$singlemsg[0]->MSG_CAT_TYPE == 'Thank You' ? 'selected' : ''}}>Thank you</option>
												<option value="4" {{$singlemsg[0]->MSG_CAT_TYPE == 'Sorry' ? 'selected' : ''}}>Sorry</option>
                                                <option value="5" {{$singlemsg[0]->MSG_CAT_TYPE == 'Festivals' ? 'selected' : ''}}>Festivals</option>
												<option value="6" {{$singlemsg[0]->MSG_CAT_TYPE == 'Payments' ? 'selected' : ''}}>Payments</option>
												<option value="7" {{$singlemsg[0]->MSG_CAT_TYPE == 'Other' ? 'selected' : ''}}>Other</option>
												<option value="8" {{$singlemsg[0]->MSG_CAT_TYPE == 'Transactional' ? 'selected' : ''}}>Transactional</option>
												<option value="9" {{$singlemsg[0]->MSG_CAT_TYPE == 'Promotional' ? 'selected' : ''}}>Promotionals</option>
                                            </select> 
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_msg_title">Title</label>
                                            <input type="text" name="txt_msg_title" id="txt_msg_title" class="form-control" value="{{$singlemsg[0]->MSG_TITLE}}" required>
                                        </div>
                                    </div>   

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_msg_subject">Subject</label>
                                            <input type="text" name="txt_msg_subject" id="txt_msg_subject" class="form-control" value="{{$singlemsg[0]->MSG_SUBJECT}}" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_msg_variable">Variable</label>
                                            <input type="text" name="txt_msg_variable" id="txt_msg_variable" class="form-control" value="{{$singlemsg[0]->MSG_VAR}}" required>
                                        </div>
                                    </div>     
                                
                                </div>   

                                <div class="row"> 
								      <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="msg_sent_from">Sent From</label>
                                            <select class="form-control" name="msg_sent_from" id="msg_sent_from" required readonly>
                                                <option value="">Select</option>
                                                <option value="Email" {{$singlemsg[0]->MSG_SENT_FROM == 'Email' ? 'selected' : ''}}>Email</option>
                                                <option value="SMS" {{$singlemsg[0]->MSG_SENT_FROM == 'SMS' ? 'selected' : ''}}>SMS</option>
                                            </select> 
                                        </div>
                                    </div>
                                    <div class="col-sm-12" id="EM">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_msg_content">@if($singlemsg[0]->MSG_SENT_FROM == 'Email') Email @else SMS @endif  Description</label>
                                            <textarea type="text" name="txt_msg_content" @if($singlemsg[0]->MSG_SENT_FROM == 'Email')  id="demo-summernote" @endif class="form-control" placeholder="Enter Description" required>{{$singlemsg[0]->MSG_CONTENT}}</textarea>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="status">Status</label>
                                            <select class="form-control" name="status" id="status" required>
                                                <option value="">Select</option>
                                                <option value="1" {{$singlemsg[0]->MSG_STATUS == 'Active' ? 'selected' : ''}}>Active</option>
                                                <option value="2" {{$singlemsg[0]->MSG_STATUS == 'InActive' ? 'selected' : ''}}>InActive</option>
                                            </select> 
                                        </div>
                                    </div>

                                </div>


                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit-message')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @elseif(!isset($singlemsg[0]->MSG_ID))
                        <form id="add-message" action="{{url('add_message')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
										<div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="messages_type">Message Type</label>
                                            <select class="form-control" name="messages_type" id="messages_type" required>
                                                <option value="">Select</option>
                                                <option value="2">Campaign</option>
                                                <option value="1">Non-campaign</option>
                                            </select> 
                                        </div>
                                    </div>

									<div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="messages_category">Message Category</label>
                                            <select class="form-control" name="messages_category" id="messages_category" required>
                                                <option value="">Select</option>
                                                <option value="1">Occasion</option>
												<option value="2">Reminders</option>
												<option value="3">Thank you</option>
												<option value="4">Sorry</option>
                                                <option value="5">Festivals</option>
												<option value="6">Payments</option>
												<option value="7">Other</option>
												<option value="8">Transactional</option>
												<option value="9">Promotionals</option>
                                            </select> 
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_msg_title">Title</label>
                                            <input type="text" name="txt_msg_title" id="txt_msg_title" class="form-control" placeholder="Enter Title" required>
                                        </div>
                                    </div>   

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_MSG_SUBJECTject">Subject</label>
                                            <input type="text" name="txt_msg_subject" id="txt_msg_subject" class="form-control" placeholder="Enter Subject" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_msg_variable">Variable</label>
                                            <input type="text" name="txt_msg_variable" id="txt_msg_variable" class="form-control" placeholder="Enter Variable" required>
                                        </div>
                                    </div>     
                                
                                </div>   

                                <div class="row"> 
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="msg_sent_from">Sent From</label>
                                            <select class="form-control" name="msg_sent_from" id="msg_sent_from" onchange="msg_from(this.id)" required>
                                                <option value="">Select</option>
                                                <option value="Email">Email</option>
                                                <option value="SMS">SMS</option>
                                            </select> 
                                        </div>
                                    </div>
                                    <div class="col-sm-12" id="EM">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_msg_content">Email Description</label>
                                            <textarea type="text" name="txt_msg_content" id="demo-summernote" class="form-control" placeholder="Enter Description" required></textarea>
                                        </div>
                                    </div>
                                    <div class="col-sm-12" id="SM" style="display: none;">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_msg_contents">SMS Description</label>
                                            <textarea type="text" name="txt_msg_contents" id="txt_msg_contents" class="form-control" placeholder="Enter Description" required></textarea>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="status">Status</label>
                                            <select class="form-control" name="status" id="status" required>
                                                <option value="">Select</option>
                                                <option value="1">Active</option>
                                                <option value="2">InActive</option>
                                            </select> 
                                        </div>
                                    </div>

									

                                </div>


                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add-message')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>

            </div>
            

            <div class="col-md-8">

                <div class="panel">
                    
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No.</th>
                                    <th>Content</th>
                                    <th class="min-tablet">Subject</th>
                                    <th class="min-tablet">Variable</th>
                                    <th class="min-tablet">Sent From</th>
                                    <th class="min-tablet">Created At</th>
                                    <th class="min-tablet">Edit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1;?>
                                @foreach($user_msg as $value)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td style="width: 20%; zoom:8%">{!! $value->MSG_CONTENT !!}</td>
                                    <td>{{ $value->MSG_SUBJECT}}</td>
                                    <td>{{ $value->MSG_VAR }}</td>
                                    <td>{{ $value->MSG_SENT_FROM }}</td>
                                    <td>{{ $value->MSG_CREATED_AT }}</td>
                                    <td>
                                        <a href="{{ url('message/'.$value->MSG_ID) }}" class="btn btn-success btn-xs">EDIT</a>
                                        <button data-id="{{$value->MSG_ID}}" data-msgname="{{$value->MSG_TITLE}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$value->MSG_STATUS == 'Active' ? 'Active' : 'InActive'}}</button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
            
                </div>

            </div>

            <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                    <form action="{{url('message_status')}}" method="POST"> 
                        {{ csrf_field() }}

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title">CHANGE MESSAGE STATUS</h4>
                        </div>

                        <!--Modal body-->
                        <div class="modal-body">
                            <div class="form-group">
                                <input id="txt_statusregid" name="txt_statusregid" type="hidden" class="form-control" required="required">
                            </div>
                            <p class="text-semibold text-main">MESSAGE TITLE :-<span id="msgname"></span></p>
                            <br>
                            <p class="text-semibold text-main">Would you like to change the status of message ?</p>

                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                            <button class="btn btn-primary" type="submit">Yes</button>
                        </div>

                    </form>
                    </div>
                </div>
            </div> 

        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var msgname = $(this).data('msgname');
        $('#txt_statusregid').val(id);
        $('#msgname').text(msgname);
    });
});
function msg_from(id){
	if($('#'+id).val() == 'Email')
	{
		$('#SM').hide();
		$('#EM').show();
	}
	if($('#'+id).val() == 'SMS')
	{
		$('#EM').hide();
		$('#SM').show();
	}
	
}
</script>
@endsection