@extends('mainlayout')
@section('content')

<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Service Charge Management</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Service Charge</h3>
                    </div>

                    <div class="collapse in">
                        @if(count($data['single']) > 0)

                                @php 
                                    $id ='';
                                    if($data['single'][0]->m78_level_comfor == 'SERVICE')
                                    {
                                        $id = $data['single'][0]->m03_services;
                                    }
                                    if($data['single'][0]->m78_level_comfor == 'TOPUP')
                                    {
                                         $id = $data['single'][0]->m27_topup_id;
                                    }
                                @endphp


                        <form id="edit_service" action="{{url('/update-level-commission/'.$id)}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Affiliate <span class="text-danger">*</span></label>
                                            <select name="dd_affiliate" id="dd_affiliate" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Affiliate</option>
                                                @foreach($affil as $values)
                                                <option value="{{$values->AFFI_ID}}" {{ $values->AFFI_ID == $data['single'][0]->m22_affiliate_id ? 'selected' : ''}}>{{$values->AFFI_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Balance Type <span class="text-danger">*</span></label>
                                            <select name="dd_balance_type" id="dd_balance_type" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select  Balance Type</option>
												<option value="1"  {{$data['single'][0]->tr03_bal_type== 'MAIN'? 'selected' : ''}}>MAIN</option>
												<option value="2"  {{$data['single'][0]->tr03_bal_type== 'DMR'? 'selected' : ''}}>DMR</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Commission For <span class="text-danger">*</span></label>
                                            <select name="dd_commission_type" id="dd_commission_type" class="form-control selectpicker" data-live-search="true" data-width="100%" disabled>
                                                <option value="">Select Commission Type</option>
                                                <option value="1" {{$data['single'][0]->m78_level_comfor== 'SERVICE'? 'selected' : ''}}>SERVICE</option>
                                                <option value="2" {{$data['single'][0]->m78_level_comfor== 'TOPUP'? 'selected' : ''}}>TOPUP</option>
                                            </select>
                                            <input type="hidden" name="dd_commission_types" id="dd_commission_types" class="form-control" value="{{$data['single'][0]->m78_level_comfor}}">
                                            <span id="divdd_commission_type" style="color:red"> <span>
                                        </div>
                                    </div>

									<div class="col-md-12" @if($data['single'][0]->m78_level_comfor == 'TOPUP') style="display: none;" @endif>
										<div class="form-group">
											<label class="control-label" for="dd_service">Services <span class="text-danger">*</span> </label>
											<select  id="form-control selectpicker" class="form-control" name="dd_service"  data-placeholder="Select Servcices" disabled>
												@foreach($service as $value)
												<option value="{{$value->m03_sr_type_id}}"  {{$data['single'][0]->m03_services== $value->m03_sr_type_id? 'selected' : ''}}>{{$value->m03_service_name}}</option>
												@endforeach
											</select>
											<input type="hidden" name="dd_services" id="dd_services" class="form-control" value="{{$data['single'][0]->m03_services}}">
										</div>
									</div>


                                    <div class="col-md-12" @if($data['single'][0]->m78_level_comfor == 'SERVICE') style="display: none;" @endif>
                                        <div class="form-group">
                                            <label class="control-label" for="dd_service">Top <span class="text-danger">*</span> </label>
                                            <select  id="form-control selectpicker" class="form-control" name="dd_service"  data-placeholder="Select Servcices" disabled>
                                                @foreach($toupdata as $value)
                                                <option value="{{$value->m27_pack_id}}"  {{$data['single'][0]->m27_topup_id== $value->m27_pack_id? 'selected' : ''}}>{{$value->m27_pack_name}}</option>
                                                @endforeach
                                            </select>
                                            <input type="hidden" name="dd_services" id="dd_services" class="form-control" value="{{$data['single'][0]->m03_services}}">
                                        </div>
                                    </div>


								@foreach($data['single'] as $key => $value)
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level {{$key+1}}</label>
                                            <input type="number" name="txt_amount[]" id="txt_amount{{$key+1}}" class="form-control" value="{{$value->m78_deduction_amount}}">
                                        </div>
                                        <span id="divtxt_amount{{$key+1}}" style="color:red"> <span>
                                    </div>
								@endforeach
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description <span class="text-danger">*</span></label>
                                            <input type="text" name="txt_desc" id="txt_desc" class="form-control" value="{{$data['single'][0]->m78_description}}">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwvs('edit_service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @else
                        <form id="add_service" action="{{url('/create-level-commission')}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Affiliate <span class="text-danger">*</span></label>
                                            <select name="dd_affiliate" id="dd_affiliate" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Affiliate</option>
                                                @foreach($affil as $values)
                                                <option value="{{$values->AFFI_ID}}" {{ $values->AFFI_ID == 1 ? 'selected' : ''}}>{{$values->AFFI_NAME}}</option>
                                                @endforeach
                                            </select>
											<span id="divtdd_affiliate" style="color:red"> <span>
                                        </div>
                                    </div>
                                    <!-- div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Role <span class="text-danger">*</span></label>
                                            <select name="dd_role" id="dd_role" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Role</option>
                                                @foreach($admin_roles as $values)
                                                <option value="{{$values->ROLE_ID}}" {{ $values->ROLE_ID == 9 ? 'selected' : ''}}>{{$values->ROLE_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div -->
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Balance Type <span class="text-danger">*</span></label>
                                            <select name="dd_balance_type" id="dd_balance_type" class="form-control selectpicker" data-live-search="true" data-width="100%">
												<option value="1">MAIN</option>
												<option value="2">DMR</option>
                                            </select>
											<span id="divdd_balance_type" style="color:red"> <span>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Select Commission For <span class="text-danger">*</span></label>
                                            <select name="dd_commission_type" id="dd_commission_type" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Commission Type</option>
                                                <option value="1">SERVICE</option>
                                                <option value="2">TOPUP</option>
                                            </select>
                                            <span id="divdd_commission_type" style="color:red"> <span>
                                        </div>
                                    </div>
									<div class="col-md-12"  id="select_service">
										<div class="form-group">
											<label class="control-label" for="dd_service">Services <span class="text-danger">*</span> </label>
												<select multiple="multiple"  id="demo-select2-multiple-selects" class="form-control" name="dd_service[]" data-width="100%" data-placeholder="Select Servcices">
												@foreach($service as $value)
												<option value="{{$value->m03_sr_type_id}}" {{old('dd_service') == $value->m03_sr_type_id? 'selected':''}}>{{$value->m03_service_name}}</option>
												@endforeach
											</select>
										</div>
									</div>
                                    <div class="col-md-12" id="select_topup">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_topup">Topup <span class="text-danger">*</span> </label>
                                                <select multiple="multiple"  id="demo-select2-multiple-select" class="form-control" name="dd_topup[]" data-width="100%" data-placeholder="Select Servcices">
                                                @foreach($toupdata as $value)
                                                <option value="{{$value->m27_pack_id}}" {{old('dd_topup') == $value->m27_pack_id? 'selected':''}}>{{$value->m27_pack_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 1 <span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount1" value="0" class="form-control" placeholder="Enter %" >
											<span id="divtxt_amount1" style="color:red"> <span>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 2<span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount2" value="0" class="form-control" placeholder="Enter %">
											<span id="divtxt_amount2" style="color:red"> <span>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 3<span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount3" value="0" class="form-control" placeholder="Enter %">
											<span id="divtxt_amount3" style="color:red"> <span>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 4<span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount4" value="0" class="form-control" placeholder="Enter %">
											<span id="divtxt_amount4" style="color:red"> <span>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 5<span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount5" value="0" class="form-control" placeholder="Enter %">
											<span id="divtxt_amount5" style="color:red"> <span>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 6<span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount6" value="0" class="form-control" placeholder="Enter %">
											<span id="divtxt_amount6" style="color:red"> <span>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 7<span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount7" value="0" class="form-control" placeholder="Enter %">
											<span id="divtxt_amount7" style="color:red"> <span>
                                        </div>
                                    </div>


                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 8<span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount8" value="0" class="form-control" placeholder="Enter %">
											<span id="divtxt_amount8" style="color:red"> <span>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 9<span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount9" value="0" class="form-control" placeholder="Enter %">
											<span id="divtxt_amount9" style="color:red"> <span>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_amount">Level 10 <span class="text-danger">*</span></label>
                                            <input type="number" name="txt_amount[]" id="txt_amount10" value="0" class="form-control" placeholder="Enter %">
											<span id="divtxt_amount10" style="color:red"> <span>
                                        </div>
                                    </div>
                                    <div class="col-sm-12"  style="display: none;">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_dist_ratio">Distribution Ratio <code>%</code></label>
                                            <input type="number" name="txt_dist_ratio" id="txt_dist_ratio" class="form-control" placeholder="Enter Distribution Ratio"  maxlength="3">
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description <span class="text-danger">*</span></label>
                                            <input type="text" name="txt_desc" id="txt_desc" class="form-control" placeholder="Enter Description">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwvs('add_service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
        
                </div>

            </div>
            
        

            <div class="col-md-8">
                <div class="panel">
                
                    <div class="panel-body" style="overflow-x:auto;">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No</th>
									<th class="min-tablet">Affiliate</th>
                                    <th class="min-tablet">Level</th>
                                    <th class="min-tablet">Comm For</th>
									<th class="min-tablet">Name</th>
                                    <th class="min-tablet">Distribution %</th>
                                    <th>Description</th>
                                    <th class="min-tablet">Action</th>
                                    <th class="min-tablet">Status</th>
                                </tr>
                            </thead>
                            <tbody>
							@foreach($data['all'] as $key => $value)
                                @php 
                                    $id ='';
                                    if($value->level_comfor == 'SERVICE')
                                    {
                                        $id = $value->services;
                                    }
                                    if($value->level_comfor == 'TOPUP')
                                    {
                                         $id = $value->pack_id;
                                    }
                                @endphp
                             <tr>
                                    <th>{{$key+1}}</th>
									<th class="min-tablet">{{$value->affiliate_name}}</th>
                                    <th class="min-tablet">Level {{$value->level}}</th>
                                    <th class="min-tablet">{{$value->level_comfor}}</th>
                                    @if($value->level_comfor == 'SERVICE')
									<th class="min-tablet">{{$value->service_name}}</th>
                                    @else
                                    <th class="min-tablet">{{$value->pack_name}}</th>
                                    @endif
                                    <th class="min-tablet">{{$value->deduction_amount}}</th>
                                    <th>{{$value->description}}</th>
                                    <th class="min-tablet"><a class="btn btn-success btn-xs" href="{{url('edit-level-commission/'.$id.'/'.$value->level_comfor)}}">EDIT</a></th>
                                    <th class="min-tablet"><a class="btn btn-{{$value->status == 'ACTIVE' ? 'success':'danger'}} btn-xs" href="{{url('status-level-commission/'.$value->lvl_id.'/'.$value->status)}}">{{$value->status}}</a></th>
                                </tr>
							@endforeach
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>

        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script type="text/javascript">
$(document).ready(function(){
$("#demo-select2-multiple-selects").select2();
$("#demo-select2-multiple-select").select2();

$("#select_service").hide();
$("#select_topup").hide();


});


$("#dd_commission_type" ).change(function() {
    if($("#dd_commission_type" ).val() == 1)
    {
        $("#select_service").show();
        $("#select_topup").hide();
    }
    if($("#dd_commission_type" ).val() == 2)
    {
        $("#select_service").hide();
        $("#select_topup").show();
    }

});

 
function conwvs(get_id)
{
	if($('#dd_balance_type').val() == '')
	{
		$('#divdd_balance_type').html('please Select Balance Type')
	}	
	else if($('#dd_commission_type').val() == '')
	{
		$('#divdd_commission_type').html('please Select Commission For')
	}	 
    else if($('#dd_affiliate').val() == '')
    {
        $('#divdd_affiliate').html('please Select Select Affiliate')
    }   
    else if(parseFloat($('#txt_amount1').val()) > 25.1)
    {
        $('#divtxt_amount1').html('please enter a value less than 25 %')
    }   
    else if(parseFloat($('#txt_amount2').val()) > 25.1)
    {
        $('#divtxt_amount2').html('please enter a value less than 25 %')
    }   
    else if(parseFloat($('#txt_amount3').val()) > 25.1)
    {
        $('#divtxt_amount3').html('please enter a value less than 25 %')
    }   
    else if(parseFloat($('#txt_amount4').val()) > 25.1)
    {
        $('#divtxt_amount4').html('please enter a value less than 25 %')
    }   
    else if(parseFloat($('#txt_amount5').val()) > 25.1)
    {
        $('#divtxt_amount5').html('please enter a value less than 25 %')
    }   
    else if(parseFloat($('#txt_amount6').val()) > 25.1)
    {
        $('#divtxt_amount6').html('please enter a value less than 25 %')
    }   
    else if(parseFloat($('#txt_amount7').val()) > 25.1)
    {
        $('#divtxt_amount7').html('please enter a value less than 25 %')
    }   
    else if(parseFloat($('#txt_amount8').val()) > 25.1)
    {
        $('#divtxt_amount8').html('please enter a value less than 25 %')
    }   
    else if(parseFloat($('#txt_amount9').val()) > 25.1)
    {
        $('#divtxt_amount9').html('please enter a value less than 25 %')
    }   
    else if(parseFloat($('#txt_amount10').val()) > 25.1)
    {
        $('#divtxt_amount10').html('please enter a value less than 25 %')
    }
	else
	{
		bootbox.confirm('Are you sure to Submit from?', function(result){
			if(result==true)
			{
				document.getElementById(get_id).submit();
			}
		}); 
	}


}
</script>
@endsection