@extends('mainlayout')
@section('content')

<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Ecommerce Setting</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li class="active">Ecommerece Image Size</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('image_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("image_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Ecommerce Image Size</h3>
                    </div>

                    <div class="collapse in">
                     @if(!isset($single_image[0]->m76_image_id))
                        <form id="add-banner" action="{{url('/ecom_image_size_save')}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
								

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_name"> Name</label>
                                            <input type="text" name="txt_name" id="txt_name" class="form-control empty" placeholder="Enter Banner Name">
                                            <span class="text-danger" id="divtxt_name"></span>
                                        </div>
                                         
                                    </div>

                                      <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="num_image_width">Width (in pixels)</label>
                                            <input type="text" name="txt_image_width" id="txt_image_width" class="form-control empty" placeholder="Enter Image Width">
                                            <span class="text-danger" id="divtxt_image_width"></span>
                                        </div>
                                             

                                    </div>


                                      <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="num_image_height">Height (in pixels)</label>
                                            <input type="text" name="txt_image_height" id="txt_image_height" class="form-control empty" placeholder="Enter Image Height" onblur="check_dub_data()">
                                            <span class="text-danger" id="divtxt_image_height"></span>
                                            
                                        </div>
                                        

                                    </div>
                                    

							

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_image_status"> Status</label>
                                            <select class="form-control opt" id="dd_image_status" name="dd_image_status">
                                                <option value="1">Active</option>
                                                <option value="2">Deactive</option>
                                            </select>
                                            <span class="text-danger" id="divdd_image_status"></span>

                                        </div>
                                        
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add-banner')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>

                        @elseif(isset($single_image[0]->m76_image_id))
                            <form id="update-banner" action="{{url('/ecom_image_size_update/'.$single_image[0]->m76_image_id)}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_name"> Name</label>
                                            <input type="text" name="txt_name" id="txt_name" class="form-control empty" value="{{$single_image[0]->m76_name}}" placeholder="Enter Image Banner image Name" >
                                            <span class="text-danger" id="divtxt_name"></span>
                                        </div>
                                          

                                    </div>

                                      <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="num_image_width">Width (in pixels)</label>
                                            <input type="text" name="txt_image_width" id="txt_image_width" class="form-control empty" value="{{$single_image[0]->m76_width}}" placeholder="Enter Image Width" >
                                            <span class="text-danger" id="divtxt_image_width"></span>
                                        </div>
                                        
                                    </div>


                                      <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="num_image_height">Height (in pixels)</label>
                                            <input type="text" name="txt_image_height" id="txt_image_height" class="form-control empty" value="{{$single_image[0]->m76_height}}" placeholder="Enter Image Height" 
                                            onblur="check_dub_data()">
                                            <span class="text-danger" id="divtxt_image_height"></span>
                                        </div>
                                     
                                        

                                    </div>
                                    

                            

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_image_status"> Status</label>
                                            <select class="form-control opt" id="dd_image_status" name="dd_image_status">
                                                <option value="1">Active</option>
                                                <option value="2">Deactive</option>
                                            </select>
                                        </div>
                                         <span class="text-danger" id="divdd_image_status"></span>

                                    </div>

                                </div>
                            </div>

                            <div class="panel-footer text-center">
                                <button class="btn btn-warning" type="button" onclick="conwv('update-banner')">Update</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                           @endif
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="panel">
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>NAME</th>
                                    <th class="min-tablet">WIDTH (in pixels)</th>
                                    <th class="min-tablet">HEIGHT (in pixels)</th>
									<th class="min-tablet">ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                  <?php $i=1; ?>
                               @foreach($results as $result)
                               <tr>
                                   <td>{{$i++}}</td>
                                   <td>{{$result->m76_name}}</td>
                                   <td>{{$result->m76_width}}</td>
                                   <td>{{$result->m76_height}}</td>
                                      <td>
                                        <a class="btn btn-success btn-xs" href="{{url('imagesize_edit/'.$result->m76_image_id)}}">EDIT</a>

                                        <a href="{{url('imagesize_status/'.$result->m76_image_id)}}">
                                        <button data-id="{{$result->m76_image_id}}" data-name="{{$result->m76_name}}" data-target="#demo-default-modal" data-toggle="modal" class="btn btn-primary btn-xs val">{{$result->m76_status == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
                                        </a>
                                    </td>
                               </tr>
                              @endforeach
                             
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>

        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<input type="hidden" id="e_result">
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>

<script>
function conwv(get_id)
{
            if(check(get_id) && check_dub_data())
    {
            bootbox.confirm('Are you sure to Submit?', function(result){
            if((result==true))
            {
                document.getElementById(get_id).submit();
            }
        });
    }else
    {
        return false;
    }
}

function check_dub_data(){

var img_name=$('#txt_name').val();
var img_width=$('#txt_image_width').val();
var img_height=$('#txt_image_height').val();
/*alert(img_height+"x"+img_height);*/

$.ajax({
        type:"POST",
        url:"{{ url('check_img_height_width') }}",
        data:{"_token": "{{ csrf_token() }}", "img_width" :img_width,"img_height":img_height,"img_name":img_name},
        success:function(result)
                        {
                            /*$('#herr').html(result);*/
                             $('#e_result').val("");
                            $('#e_result').val(result);
                        }
});

                        if($('#e_result').val() == 'false')
                        {
                            $("#divtxt_image_height").html("The Combination of Height width Already exist..");
                            return false;
                        }
                         if($('#e_result').val() == 'true')
                        {
                            $("#divtxt_name").html("Name is Already exist..");
                            return false;
                        }
                        else
                        {
                            return true;
                        }
   
} 
</script>
@endsection