@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Holiday Master</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content"> 

        <div class="row">
            
            <div class="panel">

                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                @if(Session::has('message')) 
                <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                    <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">Holiday Master</h3>
                </div>

                <div class="collapse in">
    
                    <form action="" method="POST">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="control-label" for="txtimg">Image Upload</label>
                                        <input type="file" name="txtimg" id="txtimg" class="form-control" required>
                                    </div>
                                </div>

                                <div class="col-sm-4 text-center">   
                                    <div class="form-group">
                                        <button class="btn btn-success" type="submit">Preview</button>
                                        <img src="" align="middle" style="height:85px;width:86px;">
                                    </div>
                                </div>

                                <div class="col-sm-4">   
                                    <div class="form-group">
                                        <label class="control-label" for="txtdate">Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txtdate" id="txtdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                        </div>
                                    </div>
                                </div>
                            </div>  

                            <div class="row">
                                <div class="col-sm-12">
                                    
                                    <label class="control-label" for="desc-summernote">Description</label>
                            
                                    <!--Summernote-->
                                    <!--===================================================-->
                                    <textarea id="demo-summernote" required>   
                                    </textarea>
                                    <!--===================================================-->
                                    <!-- End Summernote -->
                                       
                                </div>
                            </div> 

                            <div class="row">
                                <div class="col-sm-12">
                                    <button class="btn btn-success" type="submit">Save</button> 
                                </div>
                            </div> 
                        </div>
                    </form>
                </div>
    
            </div>
            
        </div>

        <div class="row">
            <div class="panel">
                
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>BANK ID</th>
                                <th>BANK NAME</th>
                                <th class="min-tablet">EDIT</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td></td>
                                <td></td>
                                <td><button class="btn btn-success btn-xs" type="submit">EDIT</button></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
        
            </div>
        </div>


        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

