@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Gallery/Achiever Details</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
        
            <div class="panel">

                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                @if(Session::has('message')) 
                <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                    <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">Gallery/Achiever Details</h3>
                </div>

                <div class="collapse in">
    
                    <form action="" method="POST">
                        <div class="panel-body">
                            <div class="row">

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label">Type</label>
                                        <div class="radio">
                                            <input id="rbgallery" class="magic-radio" type="radio" name="rbgallery" value="0" required>
                                            <label for="rbgallery">Gallery</label>
        
                                            <input id="rbachievers" class="magic-radio" type="radio" name="rbgallery" value="1">
                                            <label for="rbachievers">Achievers</label>

                                            <input id="rbdownloads" class="magic-radio" type="radio" name="rbgallery" value="2">
                                            <label for="rbdownloads">Downloads</label>
                                        </div>
                                    </div>
                                </div> 

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="ddaward">Image List</label>
                                        <select class="form-control" id="ddaward" name="ddaward">
                                            <option>AWARD CEREMONY</option>
                                        </select>
                                    </div>
                                </div>
                            
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtimg">Image Upload</label>
                                        <input type="file" name="txtimg" id="txtimg" class="form-control">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group text-center">
                                        <button class="btn btn-success" type="button">Preview</button>
                                        <img src="" align="middle" style="height:85px;width:86px;">
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label" for="txtdes">Description</label>
                                        <textarea id="txtdes" name="txtdes" rows="4" class="form-control" required></textarea>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit" onclick="return confirm('Are you sure you want to submit?');">Save</button>
                            <button class="btn btn-default" type="button">Close</button>
                        </div>
                    </form>
                    
                </div>
    
            </div>  
            
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

