@extends('mainlayout')
@section('content')

<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Custom Message </h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Master</a></li>
        <li class="active">Custom Message </li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Custom Message </h3>
                    </div>

                    <div class="collapse in">
                        @if($data['single'] != '')
                        <form id="edit_service" action="{{url('update-custom-message/'.$data['single'][0]->ID)}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_name">Route URL</label>
                                            <input type="text" name="txt_name" id="txt_name" class="form-control" value="{{ $data['single'][0]->ROUTE_URL}}">
                                        </div>
                                    </div>
                                     <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Send From</label>
                                            <select name="dd_sms_type" id="dd_sms_type" onchange="select_temp_type(this.id)" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Send From</option>
												<option value="1" {{ $data['single'][0]->SMS_TYPE == 'EMAIL' ? 'selected' : ''}}>EMAIL</option>
                                                <option value="2" {{ $data['single'][0]->SMS_TYPE == 'SMS' ? 'selected' : ''}}>SMS</option>
												<option value="3" {{ $data['single'][0]->SMS_TYPE == 'BOTH' ? 'selected' : ''}}>BOTH</option>
                                            </select>
                                        </div>
                                    </div>
                                     <div class="col-sm-12" id="em" style="display: {{ $data['single'][0]->TEMP_EMAIL_ID == '' ? 'none':''}} ">
                                        <div class="form-group">
                                            <label class="control-label">Email Template</label>
                                            <select name="dd_template" id="dd_template" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Template</option>
												@foreach($data['1'] as $value)
												<option value="{{$value->MSG_ID}}" {{ $value->MSG_ID == $data['single'][0]->TEMP_EMAIL_ID ? 'selected':'' }}>{{$value->MSG_TITLE}}</option> 
												@endforeach
                                            </select>
                                        </div>
                                    </div>
                                     <div class="col-sm-12"  id="sm" style="display: {{ $data['single'][0]->TEMP_SMS_ID == '' ? 'none':''}}">
                                        <div class="form-group">
                                            <label class="control-label">SMS Template</label>
                                            <select name="dd_templates" id="dd_templates" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Template</option>
												@foreach($data['2'] as $value)
												<option value="{{$value->MSG_ID}}" {{ $value->MSG_ID == $data['single'][0]->TEMP_SMS_ID ? 'selected':'' }}>{{$value->MSG_TITLE}}</option> 
												@endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description</label>
                                            <input type="text" name="txt_desc" id="txt_desc" class="form-control" value="{{$data['single'][0]->DESC}}">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('edit_service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @else
                        <form id="add_service" action="{{url('/create-custom-message')}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_name">Route URL</label>
                                            <input type="text" name="txt_name" id="txt_name" class="form-control" value="">
                                        </div>
                                    </div>
                                     <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label">Send From</label>
                                            <select name="dd_sms_type" id="dd_sms_type" onchange="select_temp_type(this.id)" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Send From</option>
												<option value="1" {{ old('dd_sms_type') == '1' ? 'selected' : ''}}>EMAIL</option>
                                                <option value="2" {{ old('dd_sms_type') == '2' ? 'selected' : ''}}>SMS</option>
												<option value="3" {{ old('dd_sms_type') == '3' ? 'selected' : ''}}>BOTH</option>
                                            </select>
                                        </div>
                                    </div>
                                     <div class="col-sm-12" id="em" style="display:none">
                                        <div class="form-group">
                                            <label class="control-label">Email Template</label>
                                            <select name="dd_template" id="dd_template" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Template</option>
                                            </select>
                                        </div>
                                    </div>
                                     <div class="col-sm-12"  id="sm" style="display:none">
                                        <div class="form-group">
                                            <label class="control-label">SMS Template</label>
                                            <select name="dd_templates" id="dd_templates" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                                <option value="">Select Template</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_desc">Description</label>
                                            <input type="text" name="txt_desc" id="txt_desc" class="form-control" placeholder="Enter Description">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conwv('add_service')">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                        
                    </div>
                </div>
            </div>
            
        

            <div class="col-md-8">
                <div class="panel">
                
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th class="min-tablet">S.No</th>
                                    <th class="min-tablet">Name</th>
									<th class="min-tablet">Type</th>
                                    <th class="min-tablet">Description</th>
                                    <th class="min-tablet">Action</th>
									<th class="min-tablet">Status</th>
                                </tr>
                            </thead>	
							@foreach($data['all'] as $key => $value)
								<tr>
                                    <th class="min-tablet">{{$key+1}}</th>
                                    <th class="min-tablet">{{$value->ROUTE_URL}}</th>
									<th class="min-tablet">{{$value->SMS_TYPE}}</th>
                                    <th class="min-tablet">{{$value->DESC}}</th>
                                    <th class="min-tablet"><a class="btn btn-xs btn-success" href="{{url('edit-custom-message/'.$value->ID)}}"> Edit</a></th>
									<th class="min-tablet"><a class="btn btn-xs btn-{{$value->STATUS == 'ACTIVE'? 'success':'danger' }}" href="{{url('status-custom-message/'.$value->ID.'/'.$value->STATUS)}}">{{$value->STATUS}}</a></th>
                                </tr>
							@endforeach
                            <tbody>
                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script> 
function select_temp_type(id)
{
	var type = $('#'+id).val();
	if(type != '')
	{
            $.ajax({
               type:"POST",
               url:"{{ url('/get-template-types')}}",
               data:{"_token": "{{ csrf_token() }}", "type":type },
               success:function(result)
               {   
                    if(result == '')
                    {
                        alert('DATA NOT FOUND');
                    }
                    else
                    {
						if(result['1'] != '' && result['2'] != '')
						{
							$('#em').show();
							$('#sm').show();
							$('#dd_template').empty();
							$("#dd_template").append('<option value="">Select Template</option>');
							$.each(result['1'],function(key,value){
								$("#dd_template").append('<option value="'+result['1'] [key].MSG_ID+'">'+result['1'] [key].MSG_TITLE+'</option>');
							});

							$('#dd_templates').empty();
							$("#dd_templates").append('<option value="">Select Template</option>');
							$.each(result['2'] ,function(key,value){
								$("#dd_templates").append('<option value="'+result['2'] [key].MSG_ID+'">'+result['2'] [key].MSG_TITLE+'</option>');
							});

						}
						if(result['1'] != '' && result['2'] == '')
						{	
							$('#em').show();
							$('#sm').hide();
							$('#dd_templates').empty();
							$('#dd_template').empty();
							$("#dd_template").append('<option  value="">Select Template</option>');
							$.each(result['1'],function(key,value){
								$("#dd_template").append('<option value="'+result['1'] [key].MSG_ID+'">'+result['1'] [key].MSG_TITLE+'</option>');
							});
							}
						if(result['2'] != '' && result['1'] == '')
						{
							$('#sm').show();
							$('#em').hide();
							$('#dd_templates').empty();
							$('#dd_template').empty();
							$("#dd_templates").append('<option value="">Select Template</option>');
							$.each(result['2'] ,function(key,value){
								$("#dd_templates").append('<option value="'+result['2'] [key].MSG_ID+'">'+result['2'] [key].MSG_TITLE+'</option>');
							});
						}
                        $('.selectpicker').selectpicker('refresh');
                    }    
               }

            });

	}
}

</script>
@endsection